/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.multimerge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.multimerge.MultiMergeJoinMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class MultiMergeJoinDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MultiMergeJoinMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "MergeJoinSortWarning";
    private CCombo[] wInputStepArray;
    private CCombo joinTypeCombo;
    private Text[] keyValTextBox;
    private Map<String, Integer> inputFields;
    private RowMetaInterface prev;
    private ColumnInfo[] ciKeys;
    private static final int margin = 4;
    private MultiMergeJoinMeta joinMeta;
    private String[] inputSteps;

    public MultiMergeJoinDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.joinMeta = (MultiMergeJoinMeta)in;
        this.wInputStepArray = new CCombo[tr.getPrevStepNames(this.stepname).length];
        this.keyValTextBox = new Text[this.wInputStepArray.length];
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.joinMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MultiMergeJoinDialog.this.joinMeta.setChanged();
            }
        };
        this.backupChanged = this.joinMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Shell.Label", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 16384);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(15, -4);
        this.fdlStepname.top = new FormAttachment(0, 4);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18444);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(15, 0);
        this.fdStepname.top = new FormAttachment(0, 4);
        this.fdStepname.right = new FormAttachment(35, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.createInputStreamWidgets(lsMod);
        this.createJoinTypeWidget(lsMod);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, 4, (Control)this.joinTypeCombo);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MultiMergeJoinDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MultiMergeJoinDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MultiMergeJoinDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.joinMeta.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void createJoinTypeWidget(ModifyListener lsMod) {
        Label joinTypeLabel = new Label((Composite)this.shell, 16384);
        joinTypeLabel.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Type.Label", (String[])new String[0]));
        this.props.setLook((Control)joinTypeLabel);
        FormData fdlType = new FormData();
        fdlType.left = new FormAttachment(0, 0);
        fdlType.right = new FormAttachment(15, -4);
        fdlType.top = this.wInputStepArray.length > 0 ? new FormAttachment((Control)this.wInputStepArray[this.wInputStepArray.length - 1], 4) : new FormAttachment((Control)this.wStepname, 4);
        joinTypeLabel.setLayoutData((Object)fdlType);
        this.joinTypeCombo = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.joinTypeCombo);
        this.joinTypeCombo.setItems(MultiMergeJoinMeta.join_types);
        this.joinTypeCombo.addModifyListener(lsMod);
        FormData fdType = new FormData();
        fdType.top = this.wInputStepArray.length > 0 ? new FormAttachment((Control)this.wInputStepArray[this.wInputStepArray.length - 1], 4) : new FormAttachment((Control)this.wStepname, 4);
        fdType.left = new FormAttachment(15, 0);
        fdType.right = new FormAttachment(35, 0);
        this.joinTypeCombo.setLayoutData((Object)fdType);
    }

    private void createInputStreamWidgets(ModifyListener lsMod) {
        this.inputSteps = this.transMeta.getPrevStepNames(this.stepname);
        for (int index = 0; index < this.inputSteps.length; ++index) {
            Label wlStep = new Label((Composite)this.shell, 16384);
            wlStep.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.InputStep", (String[])new String[0]) + (index + 1));
            this.props.setLook((Control)wlStep);
            FormData fdlStep = new FormData();
            fdlStep.left = new FormAttachment(0, 0);
            fdlStep.right = new FormAttachment(15, -4);
            fdlStep.top = index == 0 ? new FormAttachment((Control)this.wStepname, 4) : new FormAttachment((Control)this.wInputStepArray[index - 1], 4);
            wlStep.setLayoutData((Object)fdlStep);
            this.wInputStepArray[index] = new CCombo((Composite)this.shell, 2048);
            this.props.setLook((Control)this.wInputStepArray[index]);
            if (this.inputSteps != null) {
                this.wInputStepArray[index].setItems(this.inputSteps);
            }
            this.wInputStepArray[index].addModifyListener(lsMod);
            FormData fdStep1 = new FormData();
            fdStep1.left = new FormAttachment(15, 0);
            fdStep1.top = index == 0 ? new FormAttachment((Control)this.wStepname, 4) : new FormAttachment((Control)this.wInputStepArray[index - 1], 4);
            fdStep1.right = new FormAttachment(35, 0);
            this.wInputStepArray[index].setLayoutData((Object)fdStep1);
            Label keyLabel = new Label((Composite)this.shell, 16384);
            keyLabel.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.JoinKeys", (String[])new String[0]));
            this.props.setLook((Control)keyLabel);
            FormData keyStep = new FormData();
            keyStep.left = new FormAttachment(35, 9);
            keyStep.right = new FormAttachment(45, -4);
            keyStep.top = index == 0 ? new FormAttachment((Control)this.wStepname, 4) : new FormAttachment((Control)this.wInputStepArray[index - 1], 4);
            keyLabel.setLayoutData((Object)keyStep);
            this.keyValTextBox[index] = new Text((Composite)this.shell, 18444);
            this.props.setLook((Control)this.keyValTextBox[index]);
            this.keyValTextBox[index].setText("");
            this.keyValTextBox[index].addModifyListener(lsMod);
            FormData keyData = new FormData();
            keyData.left = new FormAttachment(45, 9);
            keyData.right = new FormAttachment(65, -4);
            keyData.top = index == 0 ? new FormAttachment((Control)this.wStepname, 4) : new FormAttachment((Control)this.wInputStepArray[index - 1], 4);
            this.keyValTextBox[index].setLayoutData((Object)keyData);
            Button button = new Button((Composite)this.shell, 8);
            button.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.SelectKeys", (String[])new String[0]));
            button.addListener(13, (Listener)new ConfigureKeyButtonListener(this, this.keyValTextBox[index], index, lsMod));
            FormData buttonData = new FormData();
            buttonData.left = new FormAttachment(65, 4);
            buttonData.right = new FormAttachment(80, -4);
            buttonData.top = index == 0 ? new FormAttachment((Control)this.wStepname, 4) : new FormAttachment((Control)this.wInputStepArray[index - 1], 4);
            button.setLayoutData((Object)buttonData);
        }
    }

    private void configureKeys(final Text keyValTextBox, final int inputStreamIndex, ModifyListener lsMod) {
        this.inputFields = new HashMap<String, Integer>();
        final Shell subShell = new Shell(this.shell, 3312);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        subShell.setLayout((Layout)formLayout);
        subShell.setSize(200, 150);
        subShell.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.JoinKeys", (String[])new String[0]));
        subShell.setImage(GUIResource.getInstance().getImageTransGraph());
        Label wlKeys = new Label((Composite)subShell, 0);
        wlKeys.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.Keys", (String[])new String[0]));
        FormData fdlKeys = new FormData();
        fdlKeys.left = new FormAttachment(0, 0);
        fdlKeys.right = new FormAttachment(50, -4);
        fdlKeys.top = new FormAttachment(0, 4);
        wlKeys.setLayoutData((Object)fdlKeys);
        String[] keys = keyValTextBox.getText().split(",");
        int nrKeyRows = keys != null ? keys.length : 1;
        this.ciKeys = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.ColumnInfo.KeyField", (String[])new String[0]), 2, new String[]{""}, false)};
        final TableView wKeys = new TableView((VariableSpace)this.transMeta, (Composite)subShell, 68354, this.ciKeys, nrKeyRows, lsMod, this.props);
        FormData fdKeys = new FormData();
        fdKeys.top = new FormAttachment((Control)wlKeys, 4);
        fdKeys.left = new FormAttachment(0, 0);
        fdKeys.bottom = new FormAttachment(100, -70);
        fdKeys.right = new FormAttachment(100, -4);
        wKeys.setLayoutData(fdKeys);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = MultiMergeJoinDialog.this.transMeta.getStep(inputStreamIndex);
                try {
                    if (stepMeta != null) {
                        MultiMergeJoinDialog.this.prev = MultiMergeJoinDialog.this.transMeta.getStepFields(stepMeta);
                        if (MultiMergeJoinDialog.this.prev != null) {
                            for (int i = 0; i < MultiMergeJoinDialog.this.prev.size(); ++i) {
                                MultiMergeJoinDialog.this.inputFields.put(MultiMergeJoinDialog.this.prev.getValueMeta(i).getName(), i);
                            }
                            MultiMergeJoinDialog.this.setComboBoxes();
                        }
                    }
                }
                catch (KettleException e) {
                    MultiMergeJoinDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        Button getKeyButton = new Button((Composite)subShell, 8);
        getKeyButton.setText(BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.KeyFields.Button", (String[])new String[0]));
        FormData fdbKeys = new FormData();
        fdbKeys.top = new FormAttachment((Control)wKeys, 4);
        fdbKeys.left = new FormAttachment(0, 0);
        fdbKeys.right = new FormAttachment(100, -4);
        getKeyButton.setLayoutData((Object)fdbKeys);
        getKeyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseStepDialog.getFieldsFromPrevious(MultiMergeJoinDialog.this.prev, wKeys, 1, new int[]{1}, new int[0], -1, -1, null);
            }
        });
        Button okButton = new Button((Composite)subShell, 8);
        okButton.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.setButtonPositions(new Button[]{okButton}, 4, (Control)getKeyButton);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int nrKeys = wKeys.nrNonEmpty();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nrKeys; ++i) {
                    TableItem item = wKeys.getNonEmpty(i);
                    sb.append(item.getText(1));
                    if (nrKeys <= 1 || i == nrKeys - 1) continue;
                    sb.append(",");
                }
                keyValTextBox.setText(sb.toString());
                subShell.close();
            }
        });
        subShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
            }
        });
        for (int i = 0; i < keys.length; ++i) {
            TableItem item = wKeys.table.getItem(i);
            if (keys[i] == null) continue;
            item.setText(1, keys[i]);
        }
        subShell.pack();
        subShell.open();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKeys[0].setComboValues(fieldNames);
    }

    public void getData() {
        List infoStreams = this.joinMeta.getStepIOMeta().getInfoStreams();
        for (int i = 0; i < infoStreams.size(); ++i) {
            this.wInputStepArray[i].setText(this.joinMeta.getInputSteps()[i]);
        }
        String joinType = this.joinMeta.getJoinType();
        if (joinType != null && joinType.length() > 0) {
            this.joinTypeCombo.setText(joinType);
        } else {
            this.joinTypeCombo.setText(MultiMergeJoinMeta.join_types[0]);
        }
        String[] keyFields = this.joinMeta.getKeyFields();
        for (int i = 0; i < keyFields.length; ++i) {
            this.keyValTextBox[i].setText(Const.NVL((String)keyFields[i], (String)""));
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.joinMeta.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getMeta(MultiMergeJoinMeta meta) {
        int i;
        List infoStreams = meta.getStepIOMeta().getInfoStreams();
        if (infoStreams.size() == 0) {
            if (this.inputSteps != null && this.inputSteps.length != 0) {
                for (int i2 = 0; i2 < this.inputSteps.length; ++i2) {
                    meta.getStepIOMeta().addStream((StreamInterface)new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
                }
                infoStreams = meta.getStepIOMeta().getInfoStreams();
            }
        } else if (this.inputSteps != null && infoStreams.size() < this.inputSteps.length) {
            int requiredStreams = this.inputSteps.length - infoStreams.size();
            for (i = 0; i < requiredStreams; ++i) {
                meta.getStepIOMeta().addStream((StreamInterface)new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            }
            infoStreams = meta.getStepIOMeta().getInfoStreams();
        }
        int streamCount = infoStreams.size();
        meta.allocateInputSteps(streamCount);
        meta.allocateKeys(streamCount);
        for (i = 0; i < streamCount; ++i) {
            meta.getInputSteps()[i] = this.wInputStepArray[i].getText();
            ((StreamInterface)infoStreams.get(i)).setStepMeta(this.transMeta.findStep(this.wInputStepArray[i].getText()));
            meta.getKeyFields()[i] = this.keyValTextBox[i].getText();
        }
        meta.setJoinType(this.joinTypeCombo.getText());
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getMeta(this.joinMeta);
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.DialogTitle", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.Option1", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"MultiMergeJoinDialog.InputNeedSort.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
            this.props.saveProps();
        }
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private static class ConfigureKeyButtonListener
    implements Listener {
        MultiMergeJoinDialog dialog;
        Text textBox;
        int inputStreamIndex;
        ModifyListener listener;

        public ConfigureKeyButtonListener(MultiMergeJoinDialog dialog, Text textBox, int streamIndex, ModifyListener lsMod) {
            this.dialog = dialog;
            this.textBox = textBox;
            this.listener = lsMod;
            this.inputStreamIndex = streamIndex;
        }

        public void handleEvent(Event event) {
            this.dialog.configureKeys(this.textBox, this.inputStreamIndex, this.listener);
        }
    }
}

