/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.numberrange;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.numberrange.NumberRangeMeta;
import org.pentaho.di.trans.steps.numberrange.NumberRangeRule;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class NumberRangeDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = NumberRangeMeta.class;
    private NumberRangeMeta input;
    private CCombo inputFieldControl;
    private Text outputFieldControl;
    private Text fallBackValueControl;
    private TableView rulesControl;
    private FormData fdFields;

    public NumberRangeDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (NumberRangeMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NumberRangeDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"NumberRange.TypeLongDesc", (String[])new String[0]));
        this.wStepname = this.createLine(lsMod, BaseMessages.getString(PKG, (String)"NumberRange.StepName", (String[])new String[0]), null);
        this.inputFieldControl = this.createLineCombo(lsMod, BaseMessages.getString(PKG, (String)"NumberRange.InputField", (String[])new String[0]), (Control)this.wStepname);
        this.outputFieldControl = this.createLine(lsMod, BaseMessages.getString(PKG, (String)"NumberRange.OutputField", (String[])new String[0]), (Control)this.inputFieldControl);
        this.inputFieldControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)NumberRangeDialog.this.shell.getDisplay(), 1);
                NumberRangeDialog.this.shell.setCursor(busy);
                NumberRangeDialog.this.loadComboOptions();
                NumberRangeDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.fallBackValueControl = this.createLine(lsMod, BaseMessages.getString(PKG, (String)"NumberRange.DefaultValue", (String[])new String[0]), (Control)this.outputFieldControl);
        this.createRulesTable(lsMod);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText("OK");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText("Cancel");
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, 4, (Control)this.rulesControl);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                NumberRangeDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                NumberRangeDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NumberRangeDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.inputFieldControl.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                NumberRangeDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void createRulesTable(ModifyListener lsMod) {
        Label rulesLable = new Label((Composite)this.shell, 0);
        rulesLable.setText(BaseMessages.getString(PKG, (String)"NumberRange.Ranges", (String[])new String[0]));
        this.props.setLook((Control)rulesLable);
        FormData lableFormData = new FormData();
        lableFormData.left = new FormAttachment(0, 0);
        lableFormData.right = new FormAttachment(this.props.getMiddlePct(), -4);
        lableFormData.top = new FormAttachment((Control)this.fallBackValueControl, 4);
        rulesLable.setLayoutData((Object)lableFormData);
        int FieldsRows = this.input.getRules().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"NumberRange.LowerBound", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"NumberRange.UpperBound", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"NumberRange.Value", (String[])new String[0]), 1, false)};
        this.rulesControl = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)rulesLable, 4);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.rulesControl.setLayoutData(this.fdFields);
    }

    private Text createLine(ModifyListener lsMod, String lableText, Control prevControl) {
        Label lable = new Label((Composite)this.shell, 131072);
        lable.setText(lableText);
        this.props.setLook((Control)lable);
        FormData lableFormData = new FormData();
        lableFormData.left = new FormAttachment(0, 0);
        lableFormData.right = new FormAttachment(this.props.getMiddlePct(), -4);
        lableFormData.top = prevControl != null ? new FormAttachment(prevControl, 4) : new FormAttachment(0, 4);
        lable.setLayoutData((Object)lableFormData);
        Text control = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)control);
        control.addModifyListener(lsMod);
        FormData widgetFormData = new FormData();
        widgetFormData.left = new FormAttachment(this.props.getMiddlePct(), 0);
        widgetFormData.top = prevControl != null ? new FormAttachment(prevControl, 4) : new FormAttachment(0, 4);
        widgetFormData.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)widgetFormData);
        return control;
    }

    private CCombo createLineCombo(ModifyListener lsMod, String lableText, Control prevControl) {
        Label lable = new Label((Composite)this.shell, 131072);
        lable.setText(lableText);
        this.props.setLook((Control)lable);
        FormData lableFormData = new FormData();
        lableFormData.left = new FormAttachment(0, 0);
        lableFormData.right = new FormAttachment(this.props.getMiddlePct(), -4);
        lableFormData.top = prevControl != null ? new FormAttachment(prevControl, 4) : new FormAttachment(0, 4);
        lable.setLayoutData((Object)lableFormData);
        CCombo control = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)control);
        control.addModifyListener(lsMod);
        FormData widgetFormData = new FormData();
        widgetFormData.left = new FormAttachment(this.props.getMiddlePct(), 0);
        widgetFormData.top = prevControl != null ? new FormAttachment(prevControl, 4) : new FormAttachment(0, 4);
        widgetFormData.right = new FormAttachment(100, 0);
        control.setLayoutData((Object)widgetFormData);
        return control;
    }

    public void getData() {
        String fallBackValue;
        String outputField;
        this.wStepname.setText(this.stepname);
        String inputField = this.input.getInputField();
        if (inputField != null) {
            this.inputFieldControl.setText(inputField);
        }
        if ((outputField = this.input.getOutputField()) != null) {
            this.outputFieldControl.setText(outputField);
        }
        if ((fallBackValue = this.input.getFallBackValue()) != null) {
            this.fallBackValueControl.setText(fallBackValue);
        }
        for (int i = 0; i < this.input.getRules().size(); ++i) {
            NumberRangeRule rule = (NumberRangeRule)this.input.getRules().get(i);
            TableItem item = this.rulesControl.table.getItem(i);
            if (rule.getLowerBound() > -1.7976931348623157E308) {
                String lowerBoundStr = String.valueOf(rule.getLowerBound());
                item.setText(1, lowerBoundStr);
            }
            if (rule.getUpperBound() < Double.MAX_VALUE) {
                String upperBoundStr = String.valueOf(rule.getUpperBound());
                item.setText(2, upperBoundStr);
            }
            item.setText(3, rule.getValue());
        }
        this.rulesControl.setRowNums();
        this.rulesControl.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        String inputField = this.inputFieldControl.getText();
        this.input.setInputField(inputField);
        this.input.emptyRules();
        String fallBackValue = this.fallBackValueControl.getText();
        this.input.setFallBackValue(fallBackValue);
        this.input.setOutputField(this.outputFieldControl.getText());
        int count = this.rulesControl.nrNonEmpty();
        for (int i = 0; i < count; ++i) {
            TableItem item = this.rulesControl.getNonEmpty(i);
            String lowerBoundStr = Const.isEmpty((String)item.getText(1)) ? String.valueOf(-1.7976931348623157E308) : item.getText(1);
            String upperBoundStr = Const.isEmpty((String)item.getText(2)) ? String.valueOf(Double.MAX_VALUE) : item.getText(2);
            String value = item.getText(3);
            try {
                double lowerBound = Double.parseDouble(lowerBoundStr);
                double upperBound = Double.parseDouble(upperBoundStr);
                this.input.addRule(lowerBound, upperBound, value);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bounds of this rule are not numeric: lowerBound=" + lowerBoundStr + ", upperBound=" + upperBoundStr + ", value=" + value, e);
            }
        }
        this.dispose();
    }

    private void loadComboOptions() {
        try {
            RowMetaInterface r;
            String fieldvalue = null;
            if (this.inputFieldControl.getText() != null) {
                fieldvalue = this.inputFieldControl.getText();
            }
            if ((r = this.transMeta.getPrevStepFields(this.stepname)) != null) {
                this.inputFieldControl.setItems(r.getFieldNames());
            }
            if (fieldvalue != null) {
                this.inputFieldControl.setText(fieldvalue);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"NumberRange.TypeLongDesc", (String[])new String[0]), "Can't get fields", (Exception)((Object)ke));
        }
    }
}

