/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs.provider.bzip2.BZip2Constants;
import org.apache.commons.vfs.provider.bzip2.CRC;

class CBZip2InputStream
extends InputStream
implements BZip2Constants {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private CRC crc = new CRC();
    private boolean[] inUse = new boolean[256];
    private char[] seqToUnseq = new char[256];
    private char[] unseqToSeq = new char[256];
    private char[] selector = new char[18002];
    private char[] selectorMtf = new char[18002];
    private int[] unzftab = new int[256];
    private int[][] limit = new int[6][258];
    private int[][] base = new int[6][258];
    private int[][] perm = new int[6][258];
    private int[] minLens = new int[6];
    private boolean streamEnd;
    private int currentChar = -1;
    private int currentState = 1;
    private int rNToGo;
    private int rTPos;
    private int tPos;
    private int i2;
    private int count;
    private int chPrev;
    private int ch2;
    private int j2;
    private char z;
    private boolean m_blockRandomised;
    private int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private InputStream m_input;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int last;
    private char[] mll8;
    private int nInUse;
    private int origPtr;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int[] tt;

    CBZip2InputStream(InputStream inputStream) {
        this.bsSetStream(inputStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void badBlockHeader() {
        CBZip2InputStream.cadvise();
    }

    private static void blockOverrun() {
        CBZip2InputStream.cadvise();
    }

    private static void cadvise() {
        System.out.println("CRC Error");
    }

    private static void compressedStreamEOF() {
        CBZip2InputStream.cadvise();
    }

    private static void crcError() {
        CBZip2InputStream.cadvise();
    }

    public int available() throws IOException {
        if (!this.streamEnd) {
            return 1;
        }
        return 0;
    }

    public int read() {
        if (this.streamEnd) {
            return -1;
        }
        int n = this.currentChar;
        switch (this.currentState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return n;
    }

    private void setDecompressStructureSizes(int n) {
        if (0 > n || n > 9 || 0 > this.blockSize100k || this.blockSize100k > 9) {
            // empty if block
        }
        this.blockSize100k = n;
        if (n == 0) {
            return;
        }
        int n2 = 100000 * n;
        this.mll8 = new char[n2];
        this.tt = new int[n2];
    }

    private void setupBlock() {
        int n;
        int[] nArray = new int[257];
        nArray[0] = 0;
        for (n = 1; n <= 256; ++n) {
            nArray[n] = this.unzftab[n - 1];
        }
        for (n = 1; n <= 256; ++n) {
            int n2 = n;
            nArray[n2] = nArray[n2] + nArray[n - 1];
        }
        n = 0;
        while (n <= this.last) {
            char c = this.mll8[n];
            this.tt[nArray[c]] = n++;
            char c2 = c;
            nArray[c2] = nArray[c2] + 1;
        }
        nArray = null;
        this.tPos = this.tt[this.origPtr];
        this.count = 0;
        this.i2 = 0;
        this.ch2 = 256;
        if (this.m_blockRandomised) {
            this.rNToGo = 0;
            this.rTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.mll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 6;
            this.crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupNoRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 5;
            this.count = 1;
            this.setupNoRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.mll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                this.currentState = 7;
                this.j2 = 0;
                this.setupNoRandPartC();
            } else {
                this.currentState = 5;
                this.setupNoRandPartA();
            }
        }
    }

    private void setupNoRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 5;
            ++this.i2;
            this.count = 0;
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.i2 <= this.last) {
            this.chPrev = this.ch2;
            this.ch2 = this.mll8[this.tPos];
            this.tPos = this.tt[this.tPos];
            if (this.rNToGo == 0) {
                this.rNToGo = RAND_NUMS[this.rTPos];
                ++this.rTPos;
                if (this.rTPos == 512) {
                    this.rTPos = 0;
                }
            }
            --this.rNToGo;
            this.ch2 ^= this.rNToGo == 1 ? 1 : 0;
            ++this.i2;
            this.currentChar = this.ch2;
            this.currentState = 3;
            this.crc.updateCRC(this.ch2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.ch2 != this.chPrev) {
            this.currentState = 2;
            this.count = 1;
            this.setupRandPartA();
        } else {
            ++this.count;
            if (this.count >= 4) {
                this.z = this.mll8[this.tPos];
                this.tPos = this.tt[this.tPos];
                if (this.rNToGo == 0) {
                    this.rNToGo = RAND_NUMS[this.rTPos];
                    ++this.rTPos;
                    if (this.rTPos == 512) {
                        this.rTPos = 0;
                    }
                }
                --this.rNToGo;
                this.z = (char)(this.z ^ (this.rNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.j2 = 0;
                this.currentState = 4;
                this.setupRandPartC();
            } else {
                this.currentState = 2;
                this.setupRandPartA();
            }
        }
    }

    private void setupRandPartC() {
        if (this.j2 < this.z) {
            this.currentChar = this.ch2;
            this.crc.updateCRC(this.ch2);
            ++this.j2;
        } else {
            this.currentState = 2;
            ++this.i2;
            this.count = 0;
            this.setupRandPartA();
        }
    }

    private void getAndMoveToFrontDecode() {
        int n;
        int n2;
        int n3;
        int n4 = 100000 * this.blockSize100k;
        this.origPtr = this.readVariableSizedInt(24);
        this.recvDecodingTables();
        int n5 = this.nInUse + 1;
        int n6 = -1;
        int n7 = 0;
        for (int i = 0; i <= 255; ++i) {
            this.unzftab[i] = 0;
        }
        char[] cArray = new char[256];
        for (n3 = 0; n3 <= 255; ++n3) {
            cArray[n3] = (char)n3;
        }
        this.last = -1;
        n7 = 49;
        n3 = this.selector[++n6];
        int n8 = this.minLens[n3];
        int n9 = this.bsR(n8);
        while (n9 > this.limit[n3][n8]) {
            ++n8;
            while (this.bsLive < 1) {
                n2 = 0;
                try {
                    n2 = this.m_input.read();
                }
                catch (IOException iOException) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                if (n2 == -1) {
                    CBZip2InputStream.compressedStreamEOF();
                }
                this.bsBuff = this.bsBuff << 8 | n2 & 0xFF;
                this.bsLive += 8;
            }
            n = this.bsBuff >> this.bsLive - 1 & 1;
            --this.bsLive;
            n9 = n9 << 1 | n;
        }
        int n10 = this.perm[n3][n9 - this.base[n3][n8]];
        while (n10 != n5) {
            int n11;
            int n12;
            if (n10 == 0 || n10 == 1) {
                n12 = -1;
                n11 = 1;
                do {
                    n12 = n10 == 0 ? (n12 += 1 * n11) : (n12 += 2 * n11);
                    n11 *= 2;
                    if (n7 == 0) {
                        ++n6;
                        n7 = 50;
                    }
                    --n7;
                    n3 = this.selector[n6];
                    n8 = this.minLens[n3];
                    n9 = this.bsR(n8);
                    while (n9 > this.limit[n3][n8]) {
                        ++n8;
                        while (this.bsLive < 1) {
                            int n13 = 0;
                            try {
                                n13 = this.m_input.read();
                            }
                            catch (IOException iOException) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            if (n13 == -1) {
                                CBZip2InputStream.compressedStreamEOF();
                            }
                            this.bsBuff = this.bsBuff << 8 | n13 & 0xFF;
                            this.bsLive += 8;
                        }
                        n = this.bsBuff >> this.bsLive - 1 & 1;
                        --this.bsLive;
                        n9 = n9 << 1 | n;
                    }
                } while ((n10 = this.perm[n3][n9 - this.base[n3][n8]]) == 0 || n10 == 1);
                int n14 = n2 = this.seqToUnseq[cArray[0]];
                this.unzftab[n14] = this.unzftab[n14] + ++n12;
                while (n12 > 0) {
                    ++this.last;
                    this.mll8[this.last] = n2;
                    --n12;
                }
                if (this.last < n4) continue;
                CBZip2InputStream.blockOverrun();
                continue;
            }
            ++this.last;
            if (this.last >= n4) {
                CBZip2InputStream.blockOverrun();
            }
            n2 = cArray[n10 - 1];
            char c = this.seqToUnseq[n2];
            this.unzftab[c] = this.unzftab[c] + 1;
            this.mll8[this.last] = this.seqToUnseq[n2];
            for (n12 = n10 - 1; n12 > 3; n12 -= 4) {
                cArray[n12] = cArray[n12 - 1];
                cArray[n12 - 1] = cArray[n12 - 2];
                cArray[n12 - 2] = cArray[n12 - 3];
                cArray[n12 - 3] = cArray[n12 - 4];
            }
            while (n12 > 0) {
                cArray[n12] = cArray[n12 - 1];
                --n12;
            }
            cArray[0] = n2;
            if (n7 == 0) {
                ++n6;
                n7 = 50;
            }
            --n7;
            n3 = this.selector[n6];
            n8 = this.minLens[n3];
            n9 = this.bsR(n8);
            while (n9 > this.limit[n3][n8]) {
                ++n8;
                while (this.bsLive < 1) {
                    n11 = 0;
                    try {
                        n11 = (char)this.m_input.read();
                    }
                    catch (IOException iOException) {
                        CBZip2InputStream.compressedStreamEOF();
                    }
                    this.bsBuff = this.bsBuff << 8 | n11 & 0xFF;
                    this.bsLive += 8;
                }
                n = this.bsBuff >> this.bsLive - 1 & 1;
                --this.bsLive;
                n9 = n9 << 1 | n;
            }
            n10 = this.perm[n3][n9 - this.base[n3][n8]];
        }
    }

    private void bsFinishedWithStream() {
        if (this.m_input != null) {
            try {
                this.m_input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_input = null;
    }

    private int readVariableSizedInt(int n) {
        return this.bsR(n);
    }

    private char readUnsignedChar() {
        return (char)this.bsR(8);
    }

    private int readInt() {
        int n = 0;
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        n = n << 8 | this.bsR(8);
        return n;
    }

    private int bsR(int n) {
        int n2;
        while (this.bsLive < n) {
            n2 = 0;
            try {
                n2 = this.m_input.read();
            }
            catch (IOException iOException) {
                CBZip2InputStream.compressedStreamEOF();
            }
            if (n2 == -1) {
                CBZip2InputStream.compressedStreamEOF();
            }
            this.bsBuff = this.bsBuff << 8 | n2 & 0xFF;
            this.bsLive += 8;
        }
        n2 = this.bsBuff >> this.bsLive - n & (1 << n) - 1;
        this.bsLive -= n;
        return n2;
    }

    private void bsSetStream(InputStream inputStream) {
        this.m_input = inputStream;
        this.bsLive = 0;
        this.bsBuff = 0;
    }

    private void complete() {
        this.storedCombinedCRC = this.readInt();
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            CBZip2InputStream.crcError();
        }
        this.bsFinishedWithStream();
        this.streamEnd = true;
    }

    private void endBlock() {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            CBZip2InputStream.crcError();
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = n; n5 <= n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                if (cArray[n4] != n5) continue;
                nArray3[n6] = n4;
                ++n6;
            }
        }
        for (n5 = 0; n5 < 23; ++n5) {
            nArray2[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n7 = cArray[n5] + '\u0001';
            nArray2[n7] = nArray2[n7] + 1;
        }
        for (n5 = 1; n5 < 23; ++n5) {
            int n8 = n5;
            nArray2[n8] = nArray2[n8] + nArray2[n5 - 1];
        }
        for (n5 = 0; n5 < 23; ++n5) {
            nArray[n5] = 0;
        }
        n5 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            nArray[n4] = (n5 += nArray2[n4 + 1] - nArray2[n4]) - 1;
            n5 <<= 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            nArray2[n4] = (nArray[n4 - 1] + 1 << 1) - nArray2[n4];
        }
    }

    private void initBlock() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        char c3 = this.readUnsignedChar();
        char c4 = this.readUnsignedChar();
        char c5 = this.readUnsignedChar();
        char c6 = this.readUnsignedChar();
        if (c == '\u0017' && c2 == 'r' && c3 == 'E' && c4 == '8' && c5 == 'P' && c6 == '\u0090') {
            this.complete();
            return;
        }
        if (c != '1' || c2 != 'A' || c3 != 'Y' || c4 != '&' || c5 != 'S' || c6 != 'Y') {
            CBZip2InputStream.badBlockHeader();
            this.streamEnd = true;
            return;
        }
        this.storedBlockCRC = this.readInt();
        this.m_blockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void initialize() {
        char c = this.readUnsignedChar();
        char c2 = this.readUnsignedChar();
        if (c != 'h' || c2 < '1' || c2 > '9') {
            this.bsFinishedWithStream();
            this.streamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(c2 - 48);
        this.computedCombinedCRC = 0;
    }

    private void makeMaps() {
        this.nInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.inUse[i]) continue;
            this.seqToUnseq[this.nInUse] = (char)i;
            this.unseqToSeq[i] = (char)this.nInUse;
            ++this.nInUse;
        }
    }

    private void recvDecodingTables() {
        int n;
        int n2;
        int n3;
        int n4;
        this.buildInUseTable();
        this.makeMaps();
        int n5 = this.nInUse + 2;
        int n6 = this.bsR(3);
        int n7 = this.bsR(15);
        for (int i = 0; i < n7; ++i) {
            n4 = 0;
            while (this.bsR(1) == 1) {
                ++n4;
            }
            this.selectorMtf[i] = (char)n4;
        }
        char[] cArray = new char[6];
        for (n4 = 0; n4 < n6; n4 = (int)((char)(n4 + 1))) {
            cArray[n4] = n4;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            n2 = cArray[n3];
            for (n3 = this.selectorMtf[n4]; n3 > 0; --n3) {
                cArray[n3] = cArray[n3 - '\u0001'];
            }
            cArray[0] = n2;
            this.selector[n4] = n2;
        }
        char[][] cArray2 = new char[6][258];
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.bsR(5);
            for (n = 0; n < n5; ++n) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++n2;
                        continue;
                    }
                    --n2;
                }
                cArray2[n3][n] = (char)n2;
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = 32;
            n = 0;
            for (int i = 0; i < n5; ++i) {
                if (cArray2[n3][i] > n) {
                    n = cArray2[n3][i];
                }
                if (cArray2[n3][i] >= n2) continue;
                n2 = cArray2[n3][i];
            }
            this.hbCreateDecodeTables(this.limit[n3], this.base[n3], this.perm[n3], cArray2[n3], n2, n, n5);
            this.minLens[n3] = n2;
        }
    }

    private void buildInUseTable() {
        int n;
        boolean[] blArray = new boolean[16];
        for (n = 0; n < 16; ++n) {
            blArray[n] = this.bsR(1) == 1;
        }
        for (n = 0; n < 256; ++n) {
            this.inUse[n] = false;
        }
        for (n = 0; n < 16; ++n) {
            if (!blArray[n]) continue;
            for (int i = 0; i < 16; ++i) {
                if (this.bsR(1) != 1) continue;
                this.inUse[n * 16 + i] = true;
            }
        }
    }

    public void close() throws IOException {
        this.bsFinishedWithStream();
    }
}

