/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.ram.RamFileObject;
import org.apache.commons.vfs.util.RandomAccessMode;

public class RamFileRandomAccessContent
implements RandomAccessContent {
    byte[] buf;
    protected int filePointer = 0;
    private byte[] buffer8 = new byte[8];
    private byte[] buffer4 = new byte[4];
    private byte[] buffer2 = new byte[2];
    private byte[] buffer1 = new byte[1];
    private RandomAccessMode mode;
    private RamFileObject file;
    private InputStream rafis;

    public RamFileRandomAccessContent(RamFileObject ramFileObject, RandomAccessMode randomAccessMode) {
        this.buf = ramFileObject.getData().getBuffer();
        this.file = ramFileObject;
        this.mode = randomAccessMode;
        this.rafis = new InputStream(){

            public int read() throws IOException {
                try {
                    return RamFileRandomAccessContent.this.readByte();
                }
                catch (EOFException eOFException) {
                    return -1;
                }
            }

            public long skip(long l) throws IOException {
                RamFileRandomAccessContent.this.seek(RamFileRandomAccessContent.this.getFilePointer() + l);
                return l;
            }

            public void close() throws IOException {
            }

            public int read(byte[] byArray) throws IOException {
                return this.read(byArray, 0, byArray.length);
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3 = Math.min(n2, RamFileRandomAccessContent.this.getLeftBytes());
                RamFileRandomAccessContent.this.readFully(byArray, n, n3);
                return n3;
            }

            public int available() throws IOException {
                return RamFileRandomAccessContent.this.getLeftBytes();
            }
        };
    }

    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    public void seek(long l) throws IOException {
        this.filePointer = (int)l;
    }

    public long length() throws IOException {
        return this.buf.length;
    }

    public void close() throws IOException {
    }

    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public char readChar() throws IOException {
        int n = this.readUnsignedByte();
        int n2 = this.readUnsignedByte();
        return (char)((n << 8) + (n2 << 0));
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readInt() throws IOException {
        return this.readUnsignedByte() << 24 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 8 | this.readUnsignedByte();
    }

    public int readUnsignedByte() throws IOException {
        if (this.filePointer < this.buf.length) {
            return this.buf[this.filePointer++] & 0xFF;
        }
        throw new EOFException();
    }

    public int readUnsignedShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toUnsignedShort(this.buffer2);
    }

    public long readLong() throws IOException {
        this.readFully(this.buffer8);
        return RamFileRandomAccessContent.toLong(this.buffer8);
    }

    public short readShort() throws IOException {
        this.readFully(this.buffer2);
        return RamFileRandomAccessContent.toShort(this.buffer2);
    }

    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() != 0;
    }

    public int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("The skip number can't be negative");
        }
        long l = this.filePointer + n;
        if (l > (long)this.buf.length) {
            throw new IndexOutOfBoundsException("Tyring to skip too much bytes");
        }
        this.seek(l);
        return n;
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Length is lower than 0");
        }
        if (n2 > this.getLeftBytes()) {
            throw new IndexOutOfBoundsException("Read length (" + n2 + ") is higher than buffer left bytes (" + this.getLeftBytes() + ") ");
        }
        System.arraycopy(this.buf, this.filePointer, byArray, n, n2);
        this.filePointer += n2;
    }

    private int getLeftBytes() {
        return this.buf.length - this.filePointer;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.getLeftBytes() < n2) {
            int n3 = this.buf.length + n2 - this.getLeftBytes();
            this.file.resize(n3);
            this.buf = this.file.getData().getBuffer();
        }
        System.arraycopy(byArray, n, this.buf, this.filePointer, n2);
        this.filePointer += n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void writeByte(int n) throws IOException {
        this.write(n);
    }

    public static long toLong(byte[] byArray) {
        return ((long)byArray[7] & 0xFFL) + (((long)byArray[6] & 0xFFL) << 8) + (((long)byArray[5] & 0xFFL) << 16) + (((long)byArray[4] & 0xFFL) << 24) + (((long)byArray[3] & 0xFFL) << 32) + (((long)byArray[2] & 0xFFL) << 40) + (((long)byArray[1] & 0xFFL) << 48) + (((long)byArray[0] & 0xFFL) << 56);
    }

    public static byte[] toBytes(long l, byte[] byArray) {
        byArray[7] = (byte)l;
        byArray[6] = (byte)(l >>>= 8);
        byArray[5] = (byte)(l >>>= 8);
        byArray[4] = (byte)(l >>>= 8);
        byArray[3] = (byte)(l >>>= 8);
        byArray[2] = (byte)(l >>>= 8);
        byArray[1] = (byte)(l >>>= 8);
        byArray[0] = (byte)(l >>>= 8);
        return byArray;
    }

    public static short toShort(byte[] byArray) {
        return (short)RamFileRandomAccessContent.toUnsignedShort(byArray);
    }

    public static int toUnsignedShort(byte[] byArray) {
        return (byArray[1] & 0xFF) + ((byArray[0] & 0xFF) << 8);
    }

    public void write(int n) throws IOException {
        this.buffer1[0] = (byte)n;
        this.write(this.buffer1);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeBytes(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void writeChar(int n) throws IOException {
        this.buffer2[0] = (byte)(n >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(n >>> 0 & 0xFF);
        this.write(this.buffer2);
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int n) throws IOException {
        this.buffer4[0] = (byte)(n >>> 24 & 0xFF);
        this.buffer4[1] = (byte)(n >>> 16 & 0xFF);
        this.buffer4[2] = (byte)(n >>> 8 & 0xFF);
        this.buffer4[3] = (byte)(n & 0xFF);
        this.write(this.buffer4);
    }

    public void writeLong(long l) throws IOException {
        this.write(RamFileRandomAccessContent.toBytes(l, this.buffer8));
    }

    public void writeShort(int n) throws IOException {
        this.buffer2[0] = (byte)(n >>> 8 & 0xFF);
        this.buffer2[1] = (byte)(n & 0xFF);
        this.write(this.buffer2);
    }

    public void writeUTF(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF(string);
        dataOutputStream.flush();
        dataOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.write(byArray);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("deprecated");
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }
}

