/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MonitorInputStream
extends BufferedInputStream {
    private boolean finished;
    private long count = 0L;

    public MonitorInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public synchronized int available() throws IOException {
        if (this.finished) {
            return 0;
        }
        return super.available();
    }

    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        int n = super.read();
        if (n != -1) {
            ++this.count;
            return n;
        }
        this.close();
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.finished) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.count += (long)n3;
            return n3;
        }
        this.close();
        return -1;
    }

    public void close() throws IOException {
        if (this.finished) {
            return;
        }
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.onClose();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        this.finished = true;
        if (iOException != null) {
            throw iOException;
        }
    }

    protected void onClose() throws IOException {
    }

    public long getCount() {
        return this.count;
    }
}

