/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.springframework.extensions.jcr.SessionFactoryUtils;

public class JcrConstants {
    private static final String JCR_AUTOCREATED = "autoCreated";
    private static final String JCR_BASEVERSION = "baseVersion";
    private static final String JCR_CHILD = "child";
    private static final String JCR_CHILDNODEDEFINITION = "childNodeDefinition";
    private static final String JCR_CONTENT = "content";
    private static final String JCR_CREATED = "created";
    private static final String JCR_DATA = "data";
    private static final String JCR_DEFAULTPRIMARYTYPE = "defaultPrimaryType";
    private static final String JCR_DEFAULTVALUES = "defaultValues";
    private static final String JCR_ENCODING = "encoding";
    private static final String JCR_FROZENMIXINTYPES = "frozenMixinTypes";
    private static final String JCR_FROZENNODE = "frozenNode";
    private static final String JCR_FROZENPRIMARYTYPE = "frozenPrimaryType";
    private static final String JCR_FROZENUUID = "frozenUuid";
    private static final String JCR_HASORDERABLECHILDNODES = "hasOrderableChildNodes";
    private static final String JCR_ISCHECKEDOUT = "isCheckedOut";
    private static final String JCR_ISMIXIN = "isMixin";
    private static final String JCR_LANGUAGE = "language";
    private static final String JCR_LASTMODIFIED = "lastModified";
    private static final String JCR_LOCKISDEEP = "lockIsDeep";
    private static final String JCR_LOCKOWNER = "lockOwner";
    private static final String JCR_MANDATORY = "mandatory";
    private static final String JCR_MERGEFAILED = "mergeFailed";
    private static final String JCR_MIMETYPE = "mimeType";
    private static final String JCR_MIXINTYPES = "mixinTypes";
    private static final String JCR_MULTIPLE = "multiple";
    private static final String JCR_NAME = "name";
    private static final String JCR_NODETYPENAME = "nodeTypeName";
    private static final String JCR_ONPARENTVERSION = "onParentVersion";
    private static final String JCR_PREDECESSORS = "predecessors";
    private static final String JCR_PRIMARYITEMNAME = "primaryItemName";
    private static final String JCR_PRIMARYTYPE = "primaryType";
    private static final String JCR_PROPERTYDEFINITION = "propertyDefinition";
    private static final String JCR_PROTECTED = "protected";
    private static final String JCR_REQUIREDPRIMARYTYPES = "requiredPrimaryTypes";
    private static final String JCR_REQUIREDTYPE = "requiredType";
    private static final String JCR_ROOTVERSION = "rootVersion";
    private static final String JCR_SAMENAMESIBLINGS = "sameNameSiblings";
    private static final String JCR_STATEMENT = "statement";
    private static final String JCR_SUCCESSORS = "successors";
    private static final String JCR_SUPERTYPES = "supertypes";
    private static final String JCR_SYSTEM = "system";
    private static final String JCR_UUID = "uuid";
    private static final String JCR_VALUECONSTRAINTS = "valueConstraints";
    private static final String JCR_VERSIONHISTORY = "versionHistory";
    private static final String JCR_VERSIONLABELS = "versionLabels";
    private static final String JCR_VERSIONSTORAGE = "versionStorage";
    private static final String JCR_VERSIONABLEUUID = "versionableUuid";
    private static final String JCR_PATH = "path";
    private static final String JCR_SCORE = "score";
    private static final String MIX_LOCKABLE = "lockable";
    private static final String MIX_REFERENCEABLE = "referenceable";
    private static final String MIX_VERSIONABLE = "versionable";
    private static final String NT_BASE = "base";
    private static final String NT_CHILDNODEDEFINITION = "childNodeDefinition";
    private static final String NT_FILE = "file";
    private static final String NT_FOLDER = "folder";
    private static final String NT_FROZENNODE = "frozenNode";
    private static final String NT_HIERARCHYNODE = "hierarchyNode";
    private static final String NT_LINKEDFILE = "linkedFile";
    private static final String NT_NODETYPE = "nodeType";
    private static final String NT_PROPERTYDEFINITION = "propertyDefinition";
    private static final String NT_QUERY = "query";
    private static final String NT_RESOURCE = "resource";
    private static final String NT_UNSTRUCTURED = "unstructured";
    private static final String NT_VERSION = "version";
    private static final String NT_VERSIONHISTORY = "versionHistory";
    private static final String NT_VERSIONLABELS = "versionLabels";
    private static final String NT_VERSIONEDCHILD = "versionedChild";
    private boolean cache = true;
    private Session session = null;
    protected static final String JCR_NS = "http://www.jcp.org/jcr/1.0";
    protected static final String NT_NS = "http://www.jcp.org/jcr/nt/1.0";
    protected static final String MIX_NS = "http://www.jcp.org/jcr/mix/1.0";
    protected final Map<Integer, String> jcrCacheMap = new HashMap<Integer, String>();
    protected final Map<Integer, String> ntCacheMap = new HashMap<Integer, String>();

    public JcrConstants(Session session, boolean cache) {
        this.cache = cache;
        this.session = session;
    }

    public JcrConstants(Session session) {
        this(session, true);
    }

    protected String resolveName(String namespace, String property) {
        if (this.cache) {
            Map<Integer, String> map = JCR_NS.hashCode() == namespace.hashCode() ? this.jcrCacheMap : this.ntCacheMap;
            String result = map.get(new Integer(property.hashCode()));
            if (result == null) {
                result = this.computeName(namespace, property);
            }
            map.put(new Integer(property.hashCode()), result);
            return result;
        }
        return this.computeName(namespace, property);
    }

    protected String computeName(String namespace, String property) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.session.getNamespacePrefix(namespace));
            buffer.append(':');
            buffer.append(property);
            return buffer.toString();
        }
        catch (RepositoryException e) {
            throw SessionFactoryUtils.translateException(e);
        }
    }

    protected void createCache() {
        this.jcrCacheMap.put(new Integer(JCR_AUTOCREATED.hashCode()), this.computeName(JCR_NS, JCR_AUTOCREATED));
        this.jcrCacheMap.put(new Integer(JCR_BASEVERSION.hashCode()), this.computeName(JCR_NS, JCR_BASEVERSION));
        this.jcrCacheMap.put(new Integer(JCR_CHILD.hashCode()), this.computeName(JCR_NS, JCR_CHILD));
        this.jcrCacheMap.put(new Integer("childNodeDefinition".hashCode()), this.computeName(JCR_NS, "childNodeDefinition"));
        this.jcrCacheMap.put(new Integer(JCR_CONTENT.hashCode()), this.computeName(JCR_NS, JCR_CONTENT));
        this.jcrCacheMap.put(new Integer(JCR_CREATED.hashCode()), this.computeName(JCR_NS, JCR_CREATED));
        this.jcrCacheMap.put(new Integer(JCR_DATA.hashCode()), this.computeName(JCR_NS, JCR_DATA));
        this.jcrCacheMap.put(new Integer(JCR_DEFAULTPRIMARYTYPE.hashCode()), this.computeName(JCR_NS, JCR_DEFAULTPRIMARYTYPE));
        this.jcrCacheMap.put(new Integer(JCR_DEFAULTVALUES.hashCode()), this.computeName(JCR_NS, JCR_DEFAULTVALUES));
        this.jcrCacheMap.put(new Integer(JCR_ENCODING.hashCode()), this.computeName(JCR_NS, JCR_ENCODING));
        this.jcrCacheMap.put(new Integer(JCR_FROZENMIXINTYPES.hashCode()), this.computeName(JCR_NS, JCR_FROZENMIXINTYPES));
        this.jcrCacheMap.put(new Integer("frozenNode".hashCode()), this.computeName(JCR_NS, "frozenNode"));
        this.jcrCacheMap.put(new Integer(JCR_FROZENPRIMARYTYPE.hashCode()), this.computeName(JCR_NS, JCR_FROZENPRIMARYTYPE));
        this.jcrCacheMap.put(new Integer(JCR_FROZENUUID.hashCode()), this.computeName(JCR_NS, JCR_FROZENUUID));
        this.jcrCacheMap.put(new Integer(JCR_HASORDERABLECHILDNODES.hashCode()), this.computeName(JCR_NS, JCR_HASORDERABLECHILDNODES));
        this.jcrCacheMap.put(new Integer(JCR_ISCHECKEDOUT.hashCode()), this.computeName(JCR_NS, JCR_ISCHECKEDOUT));
        this.jcrCacheMap.put(new Integer(JCR_ISMIXIN.hashCode()), this.computeName(JCR_NS, JCR_ISMIXIN));
        this.jcrCacheMap.put(new Integer(JCR_LANGUAGE.hashCode()), this.computeName(JCR_NS, JCR_LANGUAGE));
        this.jcrCacheMap.put(new Integer(JCR_LASTMODIFIED.hashCode()), this.computeName(JCR_NS, JCR_LASTMODIFIED));
        this.jcrCacheMap.put(new Integer(JCR_LOCKISDEEP.hashCode()), this.computeName(JCR_NS, JCR_LOCKISDEEP));
        this.jcrCacheMap.put(new Integer(JCR_LOCKOWNER.hashCode()), this.computeName(JCR_NS, JCR_LOCKOWNER));
        this.jcrCacheMap.put(new Integer(JCR_MANDATORY.hashCode()), this.computeName(JCR_NS, JCR_MANDATORY));
        this.jcrCacheMap.put(new Integer(JCR_MERGEFAILED.hashCode()), this.computeName(JCR_NS, JCR_MERGEFAILED));
        this.jcrCacheMap.put(new Integer(JCR_MIMETYPE.hashCode()), this.computeName(JCR_NS, JCR_MIMETYPE));
        this.jcrCacheMap.put(new Integer(JCR_MIXINTYPES.hashCode()), this.computeName(JCR_NS, JCR_MIXINTYPES));
        this.jcrCacheMap.put(new Integer(JCR_MULTIPLE.hashCode()), this.computeName(JCR_NS, JCR_MULTIPLE));
        this.jcrCacheMap.put(new Integer(JCR_NAME.hashCode()), this.computeName(JCR_NS, JCR_NAME));
        this.jcrCacheMap.put(new Integer(JCR_NODETYPENAME.hashCode()), this.computeName(JCR_NS, JCR_NODETYPENAME));
        this.jcrCacheMap.put(new Integer(JCR_ONPARENTVERSION.hashCode()), this.computeName(JCR_NS, JCR_ONPARENTVERSION));
        this.jcrCacheMap.put(new Integer(JCR_PATH.hashCode()), this.computeName(JCR_NS, JCR_PATH));
        this.jcrCacheMap.put(new Integer(JCR_PREDECESSORS.hashCode()), this.computeName(JCR_NS, JCR_PREDECESSORS));
        this.jcrCacheMap.put(new Integer(JCR_PRIMARYITEMNAME.hashCode()), this.computeName(JCR_NS, JCR_PRIMARYITEMNAME));
        this.jcrCacheMap.put(new Integer(JCR_PRIMARYTYPE.hashCode()), this.computeName(JCR_NS, JCR_PRIMARYTYPE));
        this.jcrCacheMap.put(new Integer(JCR_PRIMARYITEMNAME.hashCode()), this.computeName(JCR_NS, JCR_PRIMARYITEMNAME));
        this.jcrCacheMap.put(new Integer("propertyDefinition".hashCode()), this.computeName(JCR_NS, "propertyDefinition"));
        this.jcrCacheMap.put(new Integer(JCR_PROTECTED.hashCode()), this.computeName(JCR_NS, JCR_PROTECTED));
        this.jcrCacheMap.put(new Integer(JCR_REQUIREDPRIMARYTYPES.hashCode()), this.computeName(JCR_NS, JCR_REQUIREDPRIMARYTYPES));
        this.jcrCacheMap.put(new Integer(JCR_REQUIREDTYPE.hashCode()), this.computeName(JCR_NS, JCR_REQUIREDTYPE));
        this.jcrCacheMap.put(new Integer(JCR_ROOTVERSION.hashCode()), this.computeName(JCR_NS, JCR_ROOTVERSION));
        this.jcrCacheMap.put(new Integer(JCR_SAMENAMESIBLINGS.hashCode()), this.computeName(JCR_NS, JCR_SAMENAMESIBLINGS));
        this.jcrCacheMap.put(new Integer(JCR_SCORE.hashCode()), this.computeName(JCR_NS, JCR_SCORE));
        this.jcrCacheMap.put(new Integer(JCR_STATEMENT.hashCode()), this.computeName(JCR_NS, JCR_STATEMENT));
        this.jcrCacheMap.put(new Integer(JCR_SUCCESSORS.hashCode()), this.computeName(JCR_NS, JCR_SUCCESSORS));
        this.jcrCacheMap.put(new Integer(JCR_SUPERTYPES.hashCode()), this.computeName(JCR_NS, JCR_SUPERTYPES));
        this.jcrCacheMap.put(new Integer(JCR_SYSTEM.hashCode()), this.computeName(JCR_NS, JCR_SYSTEM));
        this.jcrCacheMap.put(new Integer(JCR_UUID.hashCode()), this.computeName(JCR_NS, JCR_UUID));
        this.jcrCacheMap.put(new Integer(JCR_VALUECONSTRAINTS.hashCode()), this.computeName(JCR_NS, JCR_VALUECONSTRAINTS));
        this.jcrCacheMap.put(new Integer(JCR_VERSIONABLEUUID.hashCode()), this.computeName(JCR_NS, JCR_VERSIONABLEUUID));
        this.jcrCacheMap.put(new Integer("versionHistory".hashCode()), this.computeName(JCR_NS, "versionHistory"));
        this.jcrCacheMap.put(new Integer("versionLabels".hashCode()), this.computeName(JCR_NS, "versionLabels"));
        this.jcrCacheMap.put(new Integer(JCR_VERSIONSTORAGE.hashCode()), this.computeName(JCR_NS, JCR_VERSIONSTORAGE));
        this.jcrCacheMap.put(new Integer(MIX_LOCKABLE.hashCode()), this.computeName(MIX_NS, MIX_LOCKABLE));
        this.jcrCacheMap.put(new Integer(MIX_REFERENCEABLE.hashCode()), this.computeName(MIX_NS, MIX_REFERENCEABLE));
        this.jcrCacheMap.put(new Integer(MIX_VERSIONABLE.hashCode()), this.computeName(MIX_NS, MIX_VERSIONABLE));
        this.jcrCacheMap.put(new Integer(NT_BASE.hashCode()), this.computeName(NT_NS, NT_BASE));
        this.jcrCacheMap.put(new Integer("childNodeDefinition".hashCode()), this.computeName(NT_NS, "childNodeDefinition"));
        this.jcrCacheMap.put(new Integer(NT_FILE.hashCode()), this.computeName(NT_NS, NT_FILE));
        this.jcrCacheMap.put(new Integer(NT_FOLDER.hashCode()), this.computeName(NT_NS, NT_FOLDER));
        this.jcrCacheMap.put(new Integer("frozenNode".hashCode()), this.computeName(NT_NS, "frozenNode"));
        this.jcrCacheMap.put(new Integer(NT_HIERARCHYNODE.hashCode()), this.computeName(NT_NS, NT_HIERARCHYNODE));
        this.jcrCacheMap.put(new Integer(NT_LINKEDFILE.hashCode()), this.computeName(NT_NS, NT_LINKEDFILE));
        this.jcrCacheMap.put(new Integer(NT_NODETYPE.hashCode()), this.computeName(NT_NS, NT_NODETYPE));
        this.jcrCacheMap.put(new Integer("propertyDefinition".hashCode()), this.computeName(NT_NS, "propertyDefinition"));
        this.jcrCacheMap.put(new Integer(NT_QUERY.hashCode()), this.computeName(NT_NS, NT_QUERY));
        this.jcrCacheMap.put(new Integer(NT_RESOURCE.hashCode()), this.computeName(NT_NS, NT_RESOURCE));
        this.jcrCacheMap.put(new Integer(NT_UNSTRUCTURED.hashCode()), this.computeName(NT_NS, NT_UNSTRUCTURED));
        this.jcrCacheMap.put(new Integer(NT_VERSION.hashCode()), this.computeName(NT_NS, NT_VERSION));
        this.jcrCacheMap.put(new Integer(NT_VERSIONEDCHILD.hashCode()), this.computeName(NT_NS, NT_VERSIONEDCHILD));
        this.jcrCacheMap.put(new Integer("versionHistory".hashCode()), this.computeName(NT_NS, "versionHistory"));
        this.jcrCacheMap.put(new Integer("versionLabels".hashCode()), this.computeName(NT_NS, "versionLabels"));
    }

    public String getJCR_AUTOCREATED() {
        return this.resolveName(JCR_NS, JCR_AUTOCREATED);
    }

    public String getJCR_BASEVERSION() {
        return this.resolveName(JCR_NS, JCR_BASEVERSION);
    }

    public String getJCR_CHILD() {
        return this.resolveName(JCR_NS, JCR_CHILD);
    }

    public String getJCR_CHILDNODEDEFINITION() {
        return this.resolveName(JCR_NS, "childNodeDefinition");
    }

    public String getJCR_CONTENT() {
        return this.resolveName(JCR_NS, JCR_CONTENT);
    }

    public String getJCR_CREATED() {
        return this.resolveName(JCR_NS, JCR_CREATED);
    }

    public String getJCR_DATA() {
        return this.resolveName(JCR_NS, JCR_DATA);
    }

    public String getJCR_DEFAULTPRIMARYTYPE() {
        return this.resolveName(JCR_NS, JCR_DEFAULTPRIMARYTYPE);
    }

    public String getJCR_DEFAULTVALUES() {
        return this.resolveName(JCR_NS, JCR_DEFAULTVALUES);
    }

    public String getJCR_ENCODING() {
        return this.resolveName(JCR_NS, JCR_ENCODING);
    }

    public String getJCR_FROZENMIXINTYPES() {
        return this.resolveName(JCR_NS, JCR_FROZENMIXINTYPES);
    }

    public String getJCR_FROZENNODE() {
        return this.resolveName(JCR_NS, "frozenNode");
    }

    public String getJCR_FROZENPRIMARYTYPE() {
        return this.resolveName(JCR_NS, JCR_FROZENPRIMARYTYPE);
    }

    public String getJCR_FROZENUUID() {
        return this.resolveName(JCR_NS, JCR_FROZENUUID);
    }

    public String getJCR_HASORDERABLECHILDNODES() {
        return this.resolveName(JCR_NS, JCR_HASORDERABLECHILDNODES);
    }

    public String getJCR_ISCHECKEDOUT() {
        return this.resolveName(JCR_NS, JCR_ISCHECKEDOUT);
    }

    public String getJCR_ISMIXIN() {
        return this.resolveName(JCR_NS, JCR_ISMIXIN);
    }

    public String getJCR_LANGUAGE() {
        return this.resolveName(JCR_NS, JCR_LANGUAGE);
    }

    public String getJCR_LASTMODIFIED() {
        return this.resolveName(JCR_NS, JCR_LASTMODIFIED);
    }

    public String getJCR_LOCKISDEEP() {
        return this.resolveName(JCR_NS, JCR_LOCKISDEEP);
    }

    public String getJCR_LOCKOWNER() {
        return this.resolveName(JCR_NS, JCR_LOCKOWNER);
    }

    public String getJCR_MANDATORY() {
        return this.resolveName(JCR_NS, JCR_MANDATORY);
    }

    public String getJCR_MERGEFAILED() {
        return this.resolveName(JCR_NS, JCR_MERGEFAILED);
    }

    public String getJCR_MIMETYPE() {
        return this.resolveName(JCR_NS, JCR_MIMETYPE);
    }

    public String getJCR_MIXINTYPES() {
        return this.resolveName(JCR_NS, JCR_MIXINTYPES);
    }

    public String getJCR_MULTIPLE() {
        return this.resolveName(JCR_NS, JCR_MULTIPLE);
    }

    public String getJCR_NAME() {
        return this.resolveName(JCR_NS, JCR_NAME);
    }

    public String getJCR_NODETYPENAME() {
        return this.resolveName(JCR_NS, JCR_NODETYPENAME);
    }

    public String getJCR_ONPARENTVERSION() {
        return this.resolveName(JCR_NS, JCR_ONPARENTVERSION);
    }

    public String getJCR_PATH() {
        return this.resolveName(JCR_NS, JCR_PATH);
    }

    public String getJCR_PREDECESSORS() {
        return this.resolveName(JCR_NS, JCR_PREDECESSORS);
    }

    public String getJCR_PRIMARYITEMNAME() {
        return this.resolveName(JCR_NS, JCR_PRIMARYITEMNAME);
    }

    public String getJCR_PRIMARYTYPE() {
        return this.resolveName(JCR_NS, JCR_PRIMARYTYPE);
    }

    public String getJCR_PROPERTYDEFINITION() {
        return this.resolveName(JCR_NS, "propertyDefinition");
    }

    public String getJCR_PROTECTED() {
        return this.resolveName(JCR_NS, JCR_PROTECTED);
    }

    public String getJCR_REQUIREDPRIMARYTYPES() {
        return this.resolveName(JCR_NS, JCR_REQUIREDPRIMARYTYPES);
    }

    public String getJCR_REQUIREDTYPE() {
        return this.resolveName(JCR_NS, JCR_REQUIREDTYPE);
    }

    public String getJCR_ROOTVERSION() {
        return this.resolveName(JCR_NS, JCR_ROOTVERSION);
    }

    public String getJCR_SAMENAMESIBLINGS() {
        return this.resolveName(JCR_NS, JCR_SAMENAMESIBLINGS);
    }

    public String getJCR_SCORE() {
        return this.resolveName(JCR_NS, JCR_SCORE);
    }

    public String getJCR_STATEMENT() {
        return this.resolveName(JCR_NS, JCR_STATEMENT);
    }

    public String getJCR_SUCCESSORS() {
        return this.resolveName(JCR_NS, JCR_SUCCESSORS);
    }

    public String getJCR_SUPERTYPES() {
        return this.resolveName(JCR_NS, JCR_SUPERTYPES);
    }

    public String getJCR_SYSTEM() {
        return this.resolveName(JCR_NS, JCR_SYSTEM);
    }

    public String getJCR_UUID() {
        return this.resolveName(JCR_NS, JCR_UUID);
    }

    public String getJCR_VALUECONSTRAINTS() {
        return this.resolveName(JCR_NS, JCR_VALUECONSTRAINTS);
    }

    public String getJCR_VERSIONABLEUUID() {
        return this.resolveName(JCR_NS, JCR_VERSIONABLEUUID);
    }

    public String getJCR_VERSIONHISTORY() {
        return this.resolveName(JCR_NS, "versionHistory");
    }

    public String getJCR_VERSIONLABELS() {
        return this.resolveName(JCR_NS, "versionLabels");
    }

    public String getJCR_VERSIONSTORAGE() {
        return this.resolveName(JCR_NS, JCR_VERSIONSTORAGE);
    }

    public String getMIX_LOCKABLE() {
        return this.resolveName(MIX_NS, MIX_LOCKABLE);
    }

    public String getMIX_REFERENCEABLE() {
        return this.resolveName(MIX_NS, MIX_REFERENCEABLE);
    }

    public String getMIX_VERSIONABLE() {
        return this.resolveName(MIX_NS, MIX_VERSIONABLE);
    }

    public String getNT_BASE() {
        return this.resolveName(NT_NS, NT_BASE);
    }

    public String getNT_CHILDNODEDEFINITION() {
        return this.resolveName(NT_NS, "childNodeDefinition");
    }

    public String getNT_FILE() {
        return this.resolveName(NT_NS, NT_FILE);
    }

    public String getNT_FOLDER() {
        return this.resolveName(NT_NS, NT_FOLDER);
    }

    public String getNT_FROZENNODE() {
        return this.resolveName(NT_NS, "frozenNode");
    }

    public String getNT_HIERARCHYNODE() {
        return this.resolveName(NT_NS, NT_HIERARCHYNODE);
    }

    public String getNT_LINKEDFILE() {
        return this.resolveName(NT_NS, NT_LINKEDFILE);
    }

    public String getNT_NODETYPE() {
        return this.resolveName(NT_NS, NT_NODETYPE);
    }

    public String getNT_PROPERTYDEFINITION() {
        return this.resolveName(NT_NS, "propertyDefinition");
    }

    public String getNT_QUERY() {
        return this.resolveName(NT_NS, NT_QUERY);
    }

    public String getNT_RESOURCE() {
        return this.resolveName(NT_NS, NT_RESOURCE);
    }

    public String getNT_UNSTRUCTURED() {
        return this.resolveName(NT_NS, NT_UNSTRUCTURED);
    }

    public String getNT_VERSION() {
        return this.resolveName(NT_NS, NT_VERSION);
    }

    public String getNT_VERSIONEDCHILD() {
        return this.resolveName(NT_NS, NT_VERSIONEDCHILD);
    }

    public String getNT_VERSIONHISTORY() {
        return this.resolveName(NT_NS, "versionHistory");
    }

    public String getNT_VERSIONLABELS() {
        return this.resolveName(NT_NS, "versionLabels");
    }
}

