/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.jackrabbit;

import java.rmi.Remote;
import java.rmi.registry.Registry;
import javax.jcr.Repository;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class RmiServerRepositoryFactoryBean
extends AbstractFactoryBean {
    private RemoteRepository remoteRepository;
    private Repository repository;
    private RemoteAdapterFactory remoteAdapterFactory;
    private Registry registry;
    private String rmiName;

    protected Object createInstance() throws Exception {
        if (this.repository == null) {
            throw new IllegalArgumentException("repository property is required");
        }
        if (this.remoteAdapterFactory == null) {
            throw new IllegalArgumentException("remoteAdapterFactory property is required");
        }
        if (this.registry == null) {
            throw new IllegalArgumentException("registry property is required");
        }
        if (this.rmiName == null) {
            throw new IllegalArgumentException("rmiName property is required");
        }
        this.remoteRepository = this.remoteAdapterFactory.getRemoteRepository(this.repository);
        this.registry.rebind(this.rmiName, (Remote)this.remoteRepository);
        return this.remoteRepository;
    }

    public Class getObjectType() {
        return this.remoteRepository == null ? RemoteRepository.class : this.remoteRepository.getClass();
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepository = remoteRepository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setRmiName(String rmiName) {
        this.rmiName = rmiName;
    }

    public void setRemoteAdapterFactory(RemoteAdapterFactory remoteAdapterFactory) {
        this.remoteAdapterFactory = remoteAdapterFactory;
    }
}

