/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.arff;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.pentaho.di.arff.ArffOutputData;
import org.pentaho.di.arff.ArffOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.dm.commons.ArffMeta;

public class ArffOutput
extends BaseStep
implements StepInterface {
    private ArffOutputMeta m_meta;
    private ArffOutputData m_data;
    private final TransMeta m_transMeta;

    public ArffOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.m_transMeta = transMeta;
    }

    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.m_meta = (ArffOutputMeta)smi;
        this.m_data = (ArffOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.m_data.finishOutput(this.m_meta.getRelationName(), this.m_meta.getEncoding());
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)this.m_meta.getFileName(), (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
            if (resultFile != null) {
                this.addResultFile(resultFile);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_data.setOutputRowMeta(this.getInputRowMeta().clone());
            if (this.m_meta.getOutputFields() == null || this.m_meta.getOutputFields().length == 0) {
                this.m_meta.setupArffMeta(this.getInputRowMeta());
            }
            this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            int[] outputFieldIndexes = new int[this.m_meta.getOutputFields().length];
            ArffMeta[] arffMeta = this.m_meta.getOutputFields();
            for (int i = 0; i < arffMeta.length; ++i) {
                if (arffMeta[i] != null) {
                    outputFieldIndexes[i] = this.getInputRowMeta().indexOfValue(arffMeta[i].getFieldName());
                    if (outputFieldIndexes[i] >= 0) continue;
                    throw new KettleException("Field [" + arffMeta[i].getFieldName() + "] couldn't be found in the " + "input stream!");
                }
                outputFieldIndexes[i] = -1;
            }
            if (!Const.isEmpty((String)this.m_meta.getWeightFieldName())) {
                int weightFieldIndex = this.getInputRowMeta().indexOfValue(this.m_meta.getWeightFieldName());
                if (weightFieldIndex < 0) {
                    throw new KettleException("Field for setting instance weights [" + this.m_meta.getWeightFieldName() + "] couldn't be found in the " + "input stream!");
                }
                ValueMetaInterface v = this.getInputRowMeta().getValueMeta(weightFieldIndex);
                if (!v.isNumeric()) {
                    throw new KettleException("Field for setting instance weights must be numeric!");
                }
                this.m_data.setWeightFieldIndex(weightFieldIndex);
            }
            this.m_data.setOutputSparseInstances(this.m_meta.getOutputSparseInstance());
            this.m_data.setOutputFieldIndexes(outputFieldIndexes, arffMeta);
            if (Const.isEmpty((String)this.m_meta.getFileName())) {
                throw new KettleException("No file name given to write to!");
            }
            if (Const.isEmpty((String)this.m_meta.getRelationName())) {
                throw new KettleException("No relation name given!");
            }
            try {
                String fileName = this.m_meta.getFileName();
                if (!fileName.endsWith(".arff") && !fileName.endsWith(".ARFF")) {
                    fileName = fileName + ".arff";
                }
                String modName = this.m_transMeta.environmentSubstitute(fileName);
                this.m_data.openFiles(modName);
            }
            catch (IOException ex) {
                throw new KettleException("Unable to open file(s)...", (Throwable)ex);
            }
        }
        try {
            this.m_data.writeRow(r, this.m_meta.getEncoding());
        }
        catch (IOException ex) {
            throw new KettleException("Problem writing a row to the file...", (Throwable)ex);
        }
        this.putRow(this.m_data.getOutputRowMeta(), r);
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{"Read row #" + this.linesRead + " : " + r});
        }
        if (this.checkFeedback(this.linesRead)) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.m_meta = (ArffOutputMeta)smi;
        this.m_data = (ArffOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.m_data.setHasEncoding(!Const.isEmpty((String)this.m_meta.getEncoding()));
                if (this.m_data.getHasEncoding()) {
                    if (!Const.isEmpty((String)this.m_meta.getNewLine())) {
                        this.m_data.setBinaryNewLine(this.m_meta.getNewLine().getBytes(this.m_meta.getEncoding()));
                    }
                    this.m_data.setBinarySeparator(",".getBytes(this.m_meta.getEncoding()));
                    this.m_data.setBinaryMissing("?".getBytes(this.m_meta.getEncoding()));
                } else {
                    if (!Const.isEmpty((String)this.m_meta.getNewLine())) {
                        this.m_data.setBinaryNewLine(this.m_meta.getNewLine().getBytes());
                    }
                    this.m_data.setBinarySeparator(",".getBytes());
                    this.m_data.setBinaryMissing("?".getBytes());
                }
            }
            catch (UnsupportedEncodingException ex) {
                this.logError("Encoding problem: " + ex.toString());
                this.logError(Const.getStackTracker((Throwable)ex));
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.m_meta = (ArffOutputMeta)smi;
        this.m_data = (ArffOutputData)sdi;
        try {
            this.m_data.closeFiles();
        }
        catch (IOException ex) {
            this.logError("Exception trying to close file: " + ex.toString());
            this.setErrors(1L);
        }
        super.dispose(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.m_meta, this.m_data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.m_meta, this.m_data);
            this.logBasic("Finished, processing " + this.linesRead + " rows");
            this.markStop();
        }
    }
}

