/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.arff;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.dm.commons.ArffMeta;
import weka.core.Utils;

public class ArffOutputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;
    protected int[] m_outputFieldIndexes;
    protected boolean m_outputSparseInstances;
    protected int m_weightFieldIndex = -1;
    protected ArffMeta[] m_arffMeta;
    protected Map<String, String>[] m_nominalVals;
    protected File m_tempFile;
    protected File m_headerFile;
    protected OutputStream m_dataOut;
    protected OutputStream m_headerOut;
    protected byte[] m_separator = ",".getBytes();
    protected byte[] m_newLine = "\n".getBytes();
    protected byte[] m_missing = "?".getBytes();
    protected byte[] m_leftCurly = "{".getBytes();
    protected byte[] m_spaceLeftCurly = " {".getBytes();
    protected byte[] m_rightCurly = "}".getBytes();
    protected boolean m_hasEncoding;
    static final int BUFF_SIZE = 100000;
    static final byte[] m_buffer = new byte[100000];

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public void setHasEncoding(boolean e) {
        this.m_hasEncoding = e;
    }

    public boolean getHasEncoding() {
        return this.m_hasEncoding;
    }

    public void setBinaryNewLine(byte[] nl) {
        this.m_newLine = nl;
    }

    public void setBinarySeparator(byte[] s) {
        this.m_separator = s;
    }

    public void setBinaryMissing(byte[] m) {
        this.m_missing = m;
    }

    public void setOutputFieldIndexes(int[] outputFieldIndexes, ArffMeta[] arffMeta) {
        this.m_outputFieldIndexes = outputFieldIndexes;
        this.m_arffMeta = arffMeta;
        this.m_nominalVals = new Map[this.m_outputFieldIndexes.length];
        for (int i = 0; i < this.m_outputFieldIndexes.length; ++i) {
            if (this.m_outputFieldIndexes[i] < 0 || this.m_arffMeta[i].getArffType() != 1) continue;
            this.m_nominalVals[i] = new TreeMap<String, String>();
            if (Const.isEmpty((String)this.m_arffMeta[i].getNominalVals())) continue;
            List vList = ArffMeta.stringToVals((String)this.m_arffMeta[i].getNominalVals());
            this.m_nominalVals[i] = new LinkedHashMap<String, String>();
            for (String v : vList) {
                this.m_nominalVals[i].put(v, v);
            }
        }
    }

    public void setWeightFieldIndex(int index) {
        this.m_weightFieldIndex = index;
    }

    public void setOutputSparseInstances(boolean s) {
        this.m_outputSparseInstances = s;
    }

    public void openFiles(String filename) throws IOException {
        if (filename.startsWith("file:")) {
            try {
                filename.replace(" ", "%20");
                this.m_headerFile = new File(new URI(filename));
            }
            catch (Exception ex) {
                throw new IOException("Malformed URI for arff file");
            }
        } else {
            this.m_headerFile = new File(filename);
        }
        FileOutputStream os = new FileOutputStream(this.m_headerFile);
        this.m_headerOut = new BufferedOutputStream(os);
        String tempPrefix = "" + Math.random() + "arffOut";
        this.m_tempFile = File.createTempFile(tempPrefix, null);
        FileOutputStream os2 = new FileOutputStream(this.m_tempFile);
        this.m_dataOut = new BufferedOutputStream(os2);
    }

    private byte[] convertStringToBinaryString(String encoding, String string) throws KettleValueException {
        if (!this.getHasEncoding()) {
            return string.getBytes();
        }
        try {
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new KettleValueException("Unable to convert String to Binary with specified string encoding [" + encoding + "]", (Throwable)e);
        }
    }

    public void writeRow(Object[] r, String encoding) throws IOException, KettleStepException {
        if (this.m_outputSparseInstances) {
            byte[] lcurly = null;
            lcurly = !Const.isEmpty((String)encoding) ? "{".getBytes(encoding) : this.m_leftCurly;
            this.m_dataOut.write(lcurly);
        }
        int sparseIndex = 0;
        boolean separatorNeeded = false;
        for (int i = 0; i < this.m_outputFieldIndexes.length; ++i) {
            if (i != 0 && separatorNeeded) {
                this.m_dataOut.write(this.m_separator);
            }
            if (this.m_outputFieldIndexes[i] < 0) continue;
            separatorNeeded = this.writeField(i, sparseIndex, r[this.m_outputFieldIndexes[i]], encoding);
            ++sparseIndex;
        }
        if (this.m_outputSparseInstances) {
            byte[] rcurly = null;
            rcurly = !Const.isEmpty((String)encoding) ? "}".getBytes(encoding) : this.m_rightCurly;
            this.m_dataOut.write(rcurly);
        }
        if (this.m_weightFieldIndex != -1) {
            this.writeWeight(this.m_weightFieldIndex, r[this.m_weightFieldIndex], encoding);
        }
        this.m_dataOut.write(this.m_newLine);
    }

    private void writeWeight(int index, Object value, String encoding) throws KettleStepException {
        try {
            ValueMetaInterface v = this.m_outputRowMeta.getValueMeta(index);
            String temp = v.getString(value);
            if (temp != null && temp.length() > 0) {
                this.m_dataOut.write(this.m_separator);
                this.m_dataOut.write(this.m_leftCurly);
                byte[] str = v.getBinaryString(value);
                this.m_dataOut.write(str);
                this.m_dataOut.write(this.m_rightCurly);
            }
        }
        catch (Exception ex) {
            throw new KettleStepException("Problem writing weight field content to file", (Throwable)ex);
        }
    }

    private boolean writeField(int index, int sparseIndex, Object value, String encoding) throws KettleStepException {
        try {
            ValueMetaInterface v = this.m_outputRowMeta.getValueMeta(this.m_outputFieldIndexes[index]);
            if (this.m_outputSparseInstances) {
                if (this.checkSparseWrite(index, v, value)) {
                    String idx = "" + sparseIndex + " ";
                    byte[] sparseBytes = !Const.isEmpty((String)encoding) ? idx.getBytes(encoding) : idx.getBytes();
                    this.m_dataOut.write(sparseBytes);
                } else {
                    return false;
                }
            }
            byte[] str = this.formatField(index, v, value, encoding);
            this.m_dataOut.write(str);
        }
        catch (Exception ex) {
            throw new KettleStepException("Problem writing field content to file", (Throwable)ex);
        }
        return true;
    }

    private boolean checkSparseWrite(int index, ValueMetaInterface v, Object value) throws KettleValueException {
        double numVal;
        if (this.m_arffMeta[index].getArffType() == 1 || this.m_arffMeta[index].getArffType() == 3) {
            String svalue;
            String string = svalue = value instanceof String ? (String)value : v.getString(value);
            if (this.m_nominalVals[index] != null) {
                if (this.m_nominalVals[index].size() == 0) {
                    throw new KettleValueException("Can't output sparse instance containing nominal attributes without knowing at least what what the zero'th value for each nominal value is apriori!");
                }
                Set<String> s = this.m_nominalVals[index].keySet();
                Iterator<String> i = s.iterator();
                String zeroS = i.next();
                if (!svalue.equals(zeroS)) {
                    return true;
                }
            }
        } else if ((this.m_arffMeta[index].getArffType() == 2 || this.m_arffMeta[index].getArffType() == 0) && (numVal = v.getNumber(value).doubleValue()) != 0.0) {
            return true;
        }
        return false;
    }

    private byte[] formatField(int index, ValueMetaInterface v, Object value, String encoding) throws KettleValueException {
        if (v.isNull(value)) {
            return this.m_missing;
        }
        if (this.m_arffMeta[index].getArffType() == 1 || this.m_arffMeta[index].getArffType() == 3) {
            String svalue;
            String string = svalue = value instanceof String ? (String)value : v.getString(value);
            if (this.m_arffMeta[index].getArffType() == 1 && !this.m_nominalVals[index].containsKey(svalue)) {
                this.m_nominalVals[index].put(svalue, svalue);
            }
            svalue = Utils.quote((String)svalue);
            return this.convertStringToBinaryString(encoding, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        if (this.m_arffMeta[index].getArffType() == 2) {
            String temp = v.getString(value);
            if (temp == null || temp.length() == 0) {
                return this.m_missing;
            }
            temp = Utils.quote((String)temp);
            return this.convertStringToBinaryString(encoding, Const.trimToType((String)temp, (int)v.getTrimType()));
        }
        if (this.m_arffMeta[index].getKettleType() == 4) {
            String temp = v.getString(value);
            if (temp == null || temp.length() == 0) {
                return this.m_missing;
            }
            temp = v.getBoolean(value) != false ? "1" : "0";
            return this.convertStringToBinaryString(encoding, Const.trimToType((String)temp, (int)v.getTrimType()));
        }
        String temp = v.getString(value);
        if (temp == null || temp.length() == 0) {
            return this.m_missing;
        }
        return v.getBinaryString(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void finishOutput(String relationName, String encoding) throws KettleStepException {
        if (this.m_headerOut == null) {
            return;
        }
        relationName = Utils.quote((String)relationName);
        relationName = "@relation " + relationName;
        byte[] rn = null;
        byte[] atAtt = null;
        byte[] atData = null;
        if (this.m_hasEncoding && encoding != null) {
            if (Const.isEmpty((String)encoding)) {
                rn = relationName.getBytes();
                atAtt = "@attribute ".getBytes();
                atData = "@data".getBytes();
            } else {
                try {
                    rn = relationName.getBytes(encoding);
                    atAtt = "@attribute ".getBytes(encoding);
                    atData = "@data".getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new KettleStepException("Unable to write header with specified string encoding [" + encoding + "]", (Throwable)e);
                }
            }
        } else {
            rn = relationName.getBytes();
            atAtt = "@attribute ".getBytes();
            atData = "@data".getBytes();
        }
        try {
            this.m_headerOut.write(rn);
            this.m_headerOut.write(this.m_newLine);
            for (int i = 0; i < this.m_outputFieldIndexes.length; ++i) {
                if (this.m_outputFieldIndexes[i] < 0) continue;
                if (this.m_arffMeta[i].getArffType() == 1) {
                    this.m_headerOut.write(atAtt);
                    this.writeBinaryNominalAttString(i, encoding);
                    continue;
                }
                if (this.m_arffMeta[i].getArffType() == 3) {
                    this.m_headerOut.write(atAtt);
                    this.writeBinaryStringAttString(i, encoding);
                    continue;
                }
                if (this.m_arffMeta[i].getArffType() == 0) {
                    this.m_headerOut.write(atAtt);
                    this.writeBinaryNumericAttString(i, encoding);
                    continue;
                }
                this.m_headerOut.write(atAtt);
                this.writeBinaryDateAttString(i, encoding);
            }
            this.m_headerOut.write(atData);
            this.m_headerOut.write(this.m_newLine);
            this.m_dataOut.flush();
            this.m_dataOut.close();
        }
        catch (IOException ex) {
            throw new KettleStepException("Problem writing values to file.", (Throwable)ex);
        }
        finally {
            try {
                this.closeFiles();
            }
            catch (IOException ex) {
                throw new KettleStepException("Problem closing files...", (Throwable)ex);
            }
        }
        FileInputStream is = null;
        OutputStream os = null;
        try {
            is = new FileInputStream(this.m_tempFile);
            os = new FileOutputStream(this.m_headerFile, true);
            while (true) {
                byte[] ex = m_buffer;
                // MONITORENTER : m_buffer
                int amountRead = ((InputStream)is).read(m_buffer);
                if (amountRead == -1) {
                    // MONITOREXIT : ex
                    return;
                }
                os.write(m_buffer, 0, amountRead);
                // MONITOREXIT : ex
            }
        }
        catch (IOException ex) {
            throw new KettleStepException("Problem copying temp file", (Throwable)ex);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                    this.m_tempFile.delete();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ex) {
                throw new KettleStepException("Problem closing files...", (Throwable)ex);
            }
        }
    }

    private void writeBinaryNumericAttString(int index, String encoding) throws IOException, KettleStepException {
        byte[] attName = null;
        byte[] attType = null;
        if (this.m_hasEncoding && encoding != null) {
            if (Const.isEmpty((String)encoding)) {
                attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
                attType = " numeric".getBytes();
            } else {
                try {
                    attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes(encoding);
                    attType = " numeric".getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new KettleStepException("Unable to write header with specified string encoding [" + encoding + "]", (Throwable)e);
                }
            }
        } else {
            attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
            attType = " numeric".getBytes();
        }
        this.m_headerOut.write(attName);
        this.m_headerOut.write(attType);
        this.m_headerOut.write(this.m_newLine);
    }

    private void writeBinaryStringAttString(int index, String encoding) throws IOException, KettleStepException {
        byte[] attName = null;
        byte[] attType = null;
        if (this.m_hasEncoding && encoding != null) {
            if (Const.isEmpty((String)encoding)) {
                attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
                attType = " string".getBytes();
            } else {
                try {
                    attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes(encoding);
                    attType = " string".getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new KettleStepException("Unable to write header with specified string encoding [" + encoding + "]", (Throwable)e);
                }
            }
        } else {
            attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
            attType = " string".getBytes();
        }
        this.m_headerOut.write(attName);
        this.m_headerOut.write(attType);
        this.m_headerOut.write(this.m_newLine);
    }

    private void writeBinaryDateAttString(int index, String encoding) throws IOException, KettleStepException {
        byte[] attName = null;
        byte[] attType = null;
        byte[] dateFormat = null;
        ValueMetaInterface v = this.m_outputRowMeta.getValueMeta(this.m_outputFieldIndexes[index]);
        String dateF = v.getDateFormat().toPattern();
        dateF = Utils.quote((String)dateF);
        if (this.m_hasEncoding && encoding != null) {
            if (Const.isEmpty((String)encoding)) {
                attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
                attType = " date ".getBytes();
                dateFormat = dateF.getBytes();
            } else {
                try {
                    attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes(encoding);
                    attType = " date ".getBytes(encoding);
                    dateFormat = dateF.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new KettleStepException("Unable to write header with specified string encoding [" + encoding + "]", (Throwable)e);
                }
            }
        } else {
            attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
            attType = " date ".getBytes();
            dateFormat = dateF.getBytes();
        }
        this.m_headerOut.write(attName);
        this.m_headerOut.write(attType);
        this.m_headerOut.write(dateFormat);
        this.m_headerOut.write(this.m_newLine);
    }

    private void writeBinaryNominalAttString(int index, String encoding) throws IOException, KettleStepException {
        byte[] attName = null;
        byte[] lcurly = null;
        byte[] rcurly = null;
        if (this.m_hasEncoding && encoding != null) {
            if (Const.isEmpty((String)encoding)) {
                attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
                lcurly = this.m_spaceLeftCurly;
                rcurly = this.m_rightCurly;
            } else {
                try {
                    attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes(encoding);
                    lcurly = " {".getBytes(encoding);
                    rcurly = "}".getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new KettleStepException("Unable to write header with specified string encoding [" + encoding + "]", (Throwable)e);
                }
            }
        } else {
            attName = Utils.quote((String)this.m_arffMeta[index].getFieldName()).getBytes();
            lcurly = this.m_spaceLeftCurly;
            rcurly = this.m_rightCurly;
        }
        this.m_headerOut.write(attName);
        this.m_headerOut.write(lcurly);
        Set<String> keySet = this.m_nominalVals[index].keySet();
        Iterator<String> ksi = keySet.iterator();
        byte[] nomVal = null;
        while (ksi.hasNext()) {
            String next = ksi.next();
            next = Utils.quote((String)next);
            nomVal = this.m_hasEncoding && encoding != null ? (Const.isEmpty((String)encoding) ? next.getBytes() : next.getBytes(encoding)) : next.getBytes();
            this.m_headerOut.write(nomVal);
            if (!ksi.hasNext()) continue;
            this.m_headerOut.write(this.m_separator);
        }
        this.m_headerOut.write(rcurly);
        this.m_headerOut.write(this.m_newLine);
    }

    public void closeFiles() throws IOException {
        if (this.m_dataOut != null) {
            this.m_dataOut.flush();
            this.m_dataOut.close();
            this.m_dataOut = null;
        }
        if (this.m_headerOut != null) {
            this.m_headerOut.flush();
            this.m_headerOut.close();
            this.m_headerOut = null;
        }
    }
}

