/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.arff;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.arff.ArffOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.dm.commons.ArffMeta;

public class ArffOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private Label m_wlStepname;
    private Text m_wStepname;
    private FormData m_fdlStepname;
    private FormData m_fdStepname;
    private FormData m_fdTabFolder;
    private FormData m_fdFileComp;
    private FormData m_fdContentComp;
    private FormData m_fdFieldsComp;
    private CTabFolder m_wTabFolder;
    private CTabItem m_wFileTab;
    private CTabItem m_wContentTab;
    private CTabItem m_wFieldsTab;
    private Label m_wlFilename;
    private FormData m_fdlFilename;
    private FormData m_fdbFilename;
    private FormData m_fdFilename;
    private Button m_wbFilename;
    private TextVar m_wFilename;
    private Label m_wlRelationName;
    private Text m_wRelationName;
    private FormData m_fdlRelationName;
    private FormData m_fdRelationName;
    private Label m_wlFormat;
    private CCombo m_wFormat;
    private FormData m_fdlFormat;
    private FormData m_fdFormat;
    private Label m_wlEncoding;
    private CCombo m_wEncoding;
    private FormData m_fdlEncoding;
    private FormData m_fdEncoding;
    private Label m_wlFields;
    private TableView m_wFields;
    private FormData m_fdlFields;
    private FormData m_fdFields;
    private ColumnInfo[] m_colinf;
    private Button m_sparseOutputCheckBox;
    private Label m_weightFieldCheckBoxLab;
    private Button m_weightFieldCheckBox;
    private Label m_weightFieldLab;
    private CCombo m_weightFieldComboBox;
    private boolean m_gotEncodings = false;
    private final ArffOutputMeta m_currentMeta;
    private final ArffOutputMeta m_originalMeta;

    public ArffOutputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.m_currentMeta = (ArffOutputMeta)((Object)in);
        this.m_originalMeta = (ArffOutputMeta)((Object)this.m_currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArffOutputDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_wlStepname = new Label((Composite)this.shell, 131072);
        this.m_wlStepname.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlStepname);
        this.m_fdlStepname = new FormData();
        this.m_fdlStepname.left = new FormAttachment(0, 0);
        this.m_fdlStepname.right = new FormAttachment(middle, -margin);
        this.m_fdlStepname.top = new FormAttachment(0, margin);
        this.m_wlStepname.setLayoutData((Object)this.m_fdlStepname);
        this.m_wStepname = new Text((Composite)this.shell, 18436);
        this.m_wStepname.setText(this.stepname);
        this.props.setLook((Control)this.m_wStepname);
        this.m_wStepname.addModifyListener(lsMod);
        this.m_fdStepname = new FormData();
        this.m_fdStepname.left = new FormAttachment(middle, 0);
        this.m_fdStepname.top = new FormAttachment(0, margin);
        this.m_fdStepname.right = new FormAttachment(100, 0);
        this.m_wStepname.setLayoutData((Object)this.m_fdStepname);
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        this.m_wFileTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wFileTab.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        this.m_wlFilename = new Label(wFileComp, 131072);
        this.m_wlFilename.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlFilename);
        this.m_fdlFilename = new FormData();
        this.m_fdlFilename.left = new FormAttachment(0, 0);
        this.m_fdlFilename.top = new FormAttachment(0, margin);
        this.m_fdlFilename.right = new FormAttachment(middle, -margin);
        this.m_wlFilename.setLayoutData((Object)this.m_fdlFilename);
        this.m_wbFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.m_wbFilename);
        this.m_wbFilename.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.m_fdbFilename = new FormData();
        this.m_fdbFilename.right = new FormAttachment(100, 0);
        this.m_fdbFilename.top = new FormAttachment(0, 0);
        this.m_wbFilename.setLayoutData((Object)this.m_fdbFilename);
        this.m_wFilename = new TextVar((VariableSpace)this.transMeta, wFileComp, 18436);
        this.props.setLook((Control)this.m_wFilename);
        this.m_wFilename.addModifyListener(lsMod);
        this.m_fdFilename = new FormData();
        this.m_fdFilename.left = new FormAttachment(middle, 0);
        this.m_fdFilename.top = new FormAttachment(0, margin);
        this.m_fdFilename.right = new FormAttachment((Control)this.m_wbFilename, -margin);
        this.m_wFilename.setLayoutData((Object)this.m_fdFilename);
        this.m_fdFileComp = new FormData();
        this.m_fdFileComp.left = new FormAttachment(0, 0);
        this.m_fdFileComp.top = new FormAttachment(0, 0);
        this.m_fdFileComp.right = new FormAttachment(100, 0);
        this.m_fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)this.m_fdFileComp);
        this.m_wlRelationName = new Label(wFileComp, 131072);
        this.m_wlRelationName.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.RelationName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlRelationName);
        this.m_fdlRelationName = new FormData();
        this.m_fdlRelationName.left = new FormAttachment(0, 0);
        this.m_fdlRelationName.top = new FormAttachment((Control)this.m_wFilename, margin);
        this.m_fdlRelationName.right = new FormAttachment(middle, -margin);
        this.m_wlRelationName.setLayoutData((Object)this.m_fdlRelationName);
        this.m_wRelationName = new Text(wFileComp, 18436);
        this.m_wRelationName.setText("NewRelation");
        this.props.setLook((Control)this.m_wRelationName);
        this.m_wRelationName.addModifyListener(lsMod);
        this.m_fdRelationName = new FormData();
        this.m_fdRelationName.left = new FormAttachment(middle, 0);
        this.m_fdRelationName.top = new FormAttachment((Control)this.m_wFilename, margin);
        this.m_fdRelationName.right = new FormAttachment(100, 0);
        this.m_wRelationName.setLayoutData((Object)this.m_fdRelationName);
        wFileComp.layout();
        this.m_wFileTab.setControl((Control)wFileComp);
        this.m_wContentTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wContentTab.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        this.m_wlFormat = new Label(wContentComp, 131072);
        this.m_wlFormat.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Format.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlFormat);
        this.m_fdlFormat = new FormData();
        this.m_fdlFormat.left = new FormAttachment(0, 0);
        this.m_fdlFormat.top = new FormAttachment(0, margin);
        this.m_fdlFormat.right = new FormAttachment(middle, -margin);
        this.m_wlFormat.setLayoutData((Object)this.m_fdlFormat);
        this.m_wFormat = new CCombo(wContentComp, 2056);
        this.m_wFormat.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Format.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wFormat);
        this.m_wFormat.add("DOS");
        this.m_wFormat.add("Unix");
        this.m_wFormat.select(0);
        this.m_wFormat.addModifyListener(lsMod);
        this.m_fdFormat = new FormData();
        this.m_fdFormat.left = new FormAttachment(middle, 0);
        this.m_fdFormat.top = new FormAttachment(0, margin);
        this.m_fdFormat.right = new FormAttachment(100, 0);
        this.m_wFormat.setLayoutData((Object)this.m_fdFormat);
        this.m_wlEncoding = new Label(wContentComp, 131072);
        this.m_wlEncoding.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlEncoding);
        this.m_fdlEncoding = new FormData();
        this.m_fdlEncoding.left = new FormAttachment(0, 0);
        this.m_fdlEncoding.top = new FormAttachment((Control)this.m_wFormat, margin);
        this.m_fdlEncoding.right = new FormAttachment(middle, -margin);
        this.m_wlEncoding.setLayoutData((Object)this.m_fdlEncoding);
        this.m_wEncoding = new CCombo(wContentComp, 2056);
        this.m_wEncoding.setEditable(true);
        this.props.setLook((Control)this.m_wEncoding);
        this.m_wEncoding.addModifyListener(lsMod);
        this.m_fdEncoding = new FormData();
        this.m_fdEncoding.left = new FormAttachment(middle, 0);
        this.m_fdEncoding.top = new FormAttachment((Control)this.m_wFormat, margin);
        this.m_fdEncoding.right = new FormAttachment(100, 0);
        this.m_wEncoding.setLayoutData((Object)this.m_fdEncoding);
        this.m_wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ArffOutputDialog.this.shell.getDisplay(), 1);
                ArffOutputDialog.this.shell.setCursor(busy);
                ArffOutputDialog.this.setEncodings();
                ArffOutputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.m_fdContentComp = new FormData();
        this.m_fdContentComp.left = new FormAttachment(0, 0);
        this.m_fdContentComp.top = new FormAttachment(0, 0);
        this.m_fdContentComp.right = new FormAttachment(100, 0);
        this.m_fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)this.m_fdContentComp);
        wContentComp.layout();
        this.m_wContentTab.setControl((Control)wContentComp);
        this.m_wFieldsTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wFieldsTab.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        Composite wFieldsComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.m_wlFields = new Label(wFieldsComp, 0);
        this.m_wlFields.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.FieldsTab.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlFields);
        this.m_fdlFields = new FormData();
        this.m_fdlFields.left = new FormAttachment(0, 0);
        this.m_fdlFields.top = new FormAttachment(0, margin);
        this.m_wlFields.setLayoutData((Object)this.m_fdlFields);
        int fieldsRows = 5;
        this.m_colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.OutputFieldsColumn.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.OutputFieldsColumn.KettleType", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.OutputFieldsColumn.ArffType", (String[])new String[0]), 2, false), new ColumnInfo(BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.OutputFieldsColumn.NomValsOrDateFormat", (String[])new String[0]), 1, false)};
        this.m_colinf[0].setReadOnly(true);
        this.m_colinf[1].setReadOnly(true);
        this.m_colinf[2].setReadOnly(false);
        this.m_colinf[3].setReadOnly(false);
        this.m_colinf[2].setComboValues(new String[]{"Numeric", "Nominal", "Date", "String"});
        this.m_wFields = new TableView((VariableSpace)this.transMeta, wFieldsComp, 67586, this.m_colinf, 5, lsMod, this.props);
        this.m_fdFields = new FormData();
        this.m_fdFields.left = new FormAttachment(0, 0);
        this.m_fdFields.top = new FormAttachment((Control)this.m_wlFields, margin);
        this.m_fdFields.right = new FormAttachment(100, 0);
        this.m_fdFields.bottom = new FormAttachment(100, -100);
        this.m_wFields.setLayoutData((Object)this.m_fdFields);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        FormData temp = new FormData();
        temp.left = new FormAttachment(0, 0);
        temp.right = new FormAttachment(middle, -margin);
        temp.top = new FormAttachment((Control)this.m_wFields, margin);
        this.wGet.setLayoutData((Object)temp);
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                ArffOutputDialog.this.getFields();
            }
        };
        this.wGet.addListener(13, this.lsGet);
        Label sparseLab = new Label(wFieldsComp, 131072);
        sparseLab.setText("Output sparse instances");
        this.props.setLook((Control)sparseLab);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.wGet, margin);
        sparseLab.setLayoutData((Object)fd);
        this.m_sparseOutputCheckBox = new Button(wFieldsComp, 32);
        this.props.setLook((Control)this.m_sparseOutputCheckBox);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.wGet, margin);
        this.m_sparseOutputCheckBox.setLayoutData((Object)fd);
        this.m_weightFieldCheckBoxLab = new Label(wFieldsComp, 131072);
        this.m_weightFieldCheckBoxLab.setText("Set instance weights from field");
        this.props.setLook((Control)this.m_weightFieldCheckBoxLab);
        FormData fdlWeightFieldCheckBoxLab = new FormData();
        fdlWeightFieldCheckBoxLab.left = new FormAttachment(0, 0);
        fdlWeightFieldCheckBoxLab.right = new FormAttachment(middle, -margin);
        fdlWeightFieldCheckBoxLab.top = new FormAttachment((Control)this.m_sparseOutputCheckBox, margin);
        this.m_weightFieldCheckBoxLab.setLayoutData((Object)fdlWeightFieldCheckBoxLab);
        this.m_weightFieldCheckBox = new Button(wFieldsComp, 32);
        this.props.setLook((Control)this.m_weightFieldCheckBox);
        FormData fdlWeightFieldCheckBox = new FormData();
        fdlWeightFieldCheckBox.left = new FormAttachment(middle, 0);
        fdlWeightFieldCheckBox.right = new FormAttachment(100, 0);
        fdlWeightFieldCheckBox.top = new FormAttachment((Control)this.m_sparseOutputCheckBox, margin);
        this.m_weightFieldCheckBox.setLayoutData((Object)fdlWeightFieldCheckBox);
        this.m_weightFieldLab = new Label(wFieldsComp, 131072);
        this.m_weightFieldLab.setText("Weight field");
        this.props.setLook((Control)this.m_weightFieldLab);
        FormData fdlWeightFieldLab = new FormData();
        fdlWeightFieldLab.left = new FormAttachment(0, 0);
        fdlWeightFieldLab.right = new FormAttachment(middle, -margin);
        fdlWeightFieldLab.top = new FormAttachment((Control)this.m_weightFieldCheckBox, margin);
        this.m_weightFieldLab.setLayoutData((Object)fdlWeightFieldLab);
        this.m_weightFieldComboBox = new CCombo(wFieldsComp, 2056);
        this.m_weightFieldComboBox.setToolTipText("Set instance-level weights using this incoming field");
        this.props.setLook((Control)this.m_weightFieldComboBox);
        FormData fdlWeightFieldComboBox = new FormData();
        fdlWeightFieldComboBox.left = new FormAttachment(middle, 0);
        fdlWeightFieldComboBox.right = new FormAttachment(100, 0);
        fdlWeightFieldComboBox.top = new FormAttachment((Control)this.m_weightFieldCheckBox, margin);
        this.m_weightFieldComboBox.setLayoutData((Object)fdlWeightFieldComboBox);
        this.m_weightFieldComboBox.setEnabled(false);
        this.m_weightFieldCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ArffOutputDialog.this.m_weightFieldCheckBox.getSelection()) {
                    ArffOutputDialog.this.setupWeightFieldComboBox();
                }
                ArffOutputDialog.this.m_weightFieldComboBox.setEnabled(ArffOutputDialog.this.m_weightFieldCheckBox.getSelection());
            }
        });
        this.m_fdFieldsComp = new FormData();
        this.m_fdFieldsComp.left = new FormAttachment(0, 0);
        this.m_fdFieldsComp.top = new FormAttachment(0, 0);
        this.m_fdFieldsComp.right = new FormAttachment(100, 0);
        this.m_fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)this.m_fdFieldsComp);
        wFieldsComp.layout();
        this.m_wFieldsTab.setControl((Control)wFieldsComp);
        this.m_fdTabFolder = new FormData();
        this.m_fdTabFolder.left = new FormAttachment(0, 0);
        this.m_fdTabFolder.top = new FormAttachment((Control)this.m_wStepname, margin);
        this.m_fdTabFolder.right = new FormAttachment(100, 0);
        this.m_fdTabFolder.bottom = new FormAttachment(100, -50);
        this.m_wTabFolder.setLayoutData((Object)this.m_fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(ArffOutputMeta.PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.m_wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArffOutputDialog.this.m_wFilename.setToolTipText(ArffOutputDialog.this.transMeta.environmentSubstitute(ArffOutputDialog.this.m_wFilename.getText()));
            }
        });
        this.m_wFilename.addSelectionListener(new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ArffOutputDialog.this.m_currentMeta.setFileName(ArffOutputDialog.this.m_wFilename.getText());
            }
        });
        this.m_wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ArffOutputDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.arff", "*"});
                if (ArffOutputDialog.this.m_wFilename.getText() != null) {
                    String fn = ArffOutputDialog.this.m_wFilename.getText();
                    int l = fn.lastIndexOf(System.getProperty("file.separator"));
                    if (l >= 0) {
                        fn = fn.substring(l + 1, fn.length());
                    }
                    dialog.setFileName(ArffOutputDialog.this.transMeta.environmentSubstitute(fn));
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString(ArffOutputMeta.PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String fileName = dialog.getFileName();
                    if (!fileName.endsWith(".arff")) {
                        fileName = fileName + ".arff";
                    }
                    ArffOutputDialog.this.m_wFilename.setText(dialog.getFilterPath() + System.getProperty("file.separator") + fileName);
                    ArffOutputDialog.this.m_currentMeta.setFileName(fileName);
                }
            }
        });
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ArffOutputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ArffOutputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ArffOutputDialog.this.ok();
            }
        };
        this.m_wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ArffOutputDialog.this.cancel();
            }
        });
        this.m_wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.m_currentMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void getData() {
        String encoding;
        String format = this.m_currentMeta.getFileFormat();
        if (format != null && format.length() > 0) {
            this.m_wFormat.setText(format);
        }
        if ((encoding = this.m_currentMeta.getEncoding()) != null && encoding.length() > 0) {
            this.m_wEncoding.setText(encoding);
        }
        String fName = this.m_currentMeta.getFileName();
        this.m_wFilename.setText(fName);
        String rName = this.m_currentMeta.getRelationName();
        this.m_wRelationName.setText(rName);
        ArffMeta[] fields = this.m_currentMeta.getOutputFields();
        if (fields == null || fields.length == 0) {
            fields = this.setupArffMetas();
        }
        if (fields != null) {
            this.m_wFields.clearAll(false);
            Table table = this.m_wFields.table;
            boolean count = false;
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] == null) continue;
                TableItem item = new TableItem(table, 0);
                item.setText(1, Const.NVL((String)fields[i].getFieldName(), (String)""));
                item.setText(2, ValueMeta.getTypeDesc((int)fields[i].getKettleType()));
                item.setText(3, Const.NVL((String)this.getArffTypeString(fields[i].getArffType()), (String)""));
                if (fields[i].getArffType() == 1 && !Const.isEmpty((String)fields[i].getNominalVals())) {
                    item.setText(4, fields[i].getNominalVals());
                    continue;
                }
                if (fields[i].getArffType() != 2 || Const.isEmpty((String)fields[i].getDateFormat())) continue;
                item.setText(4, fields[i].getDateFormat());
            }
            this.m_wFields.removeEmptyRows();
            this.m_wFields.setRowNums();
            this.m_wFields.optWidth(true);
            if (!Const.isEmpty((String)this.m_currentMeta.getWeightFieldName())) {
                this.m_weightFieldCheckBox.setSelection(true);
                this.setupWeightFieldComboBox();
                this.m_weightFieldComboBox.setEnabled(true);
                this.m_weightFieldComboBox.setText(this.m_currentMeta.getWeightFieldName());
            }
            this.m_sparseOutputCheckBox.setSelection(this.m_currentMeta.getOutputSparseInstance());
        }
    }

    private ArffMeta[] setupArffMetas() {
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (stepMeta != null) {
            try {
                RowMetaInterface row = this.transMeta.getPrevStepFields(stepMeta);
                this.m_currentMeta.setupArffMeta(row);
                return this.m_currentMeta.getOutputFields();
            }
            catch (KettleException ex) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Log.UnableToFindInput", (String[])new String[0])});
            }
        }
        return null;
    }

    private void setupWeightFieldComboBox() {
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (stepMeta != null) {
            try {
                RowMetaInterface rmi = this.transMeta.getPrevStepFields(stepMeta);
                this.m_weightFieldComboBox.removeAll();
                for (int i = 0; i < rmi.size(); ++i) {
                    ValueMetaInterface inField = rmi.getValueMeta(i);
                    int fieldType = inField.getType();
                    switch (fieldType) {
                        case 1: 
                        case 5: {
                            this.m_weightFieldComboBox.add(inField.getName());
                        }
                    }
                }
            }
            catch (KettleException ex) {
                this.log.logError(this.toString(), new Object[]{BaseMessages.getString(ArffOutputMeta.PKG, (String)"ArffOutputDialog.Log.UnableToFindInput", (String[])new String[0])});
            }
        }
    }

    private String getKettleTypeString(int kettleType) {
        switch (kettleType) {
            case 1: {
                return "Number";
            }
            case 5: {
                return "Integer";
            }
            case 4: {
                return "Boolean";
            }
            case 2: {
                return "String";
            }
            case 3: {
                return "Date";
            }
        }
        return "Unknown";
    }

    private int getKettleTypeInt(String kettleType) {
        if (kettleType.equalsIgnoreCase("Number")) {
            return 1;
        }
        if (kettleType.equalsIgnoreCase("Integer")) {
            return 5;
        }
        if (kettleType.equalsIgnoreCase("Boolean")) {
            return 4;
        }
        if (kettleType.equalsIgnoreCase("String")) {
            return 2;
        }
        if (kettleType.equalsIgnoreCase("Date")) {
            return 3;
        }
        return -1;
    }

    private String getArffTypeString(int arffType) {
        if (arffType == 0) {
            return "Numeric";
        }
        if (arffType == 1) {
            return "Nominal";
        }
        if (arffType == 3) {
            return "String";
        }
        return "Date";
    }

    private int getArffTypeInt(String arffType) {
        if (arffType.equalsIgnoreCase("Numeric")) {
            return 0;
        }
        if (arffType.equalsIgnoreCase("Nominal")) {
            return 1;
        }
        if (arffType.equalsIgnoreCase("String")) {
            return 3;
        }
        return 2;
    }

    private void setEncodings() {
        if (!this.m_gotEncodings) {
            this.m_gotEncodings = true;
            this.m_wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.m_wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.m_wEncoding.getItems());
            if (idx >= 0) {
                this.m_wEncoding.select(idx);
            }
        }
    }

    private void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.m_currentMeta.setOutputFields(this.m_originalMeta.getOutputFields());
        this.dispose();
    }

    private void getFields() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.m_wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{2}, (int)-1, (int)-1, null);
                int nrNonEmptyFields = this.m_wFields.nrNonEmpty();
                block7: for (int i = 0; i < nrNonEmptyFields; ++i) {
                    TableItem item = this.m_wFields.getNonEmpty(i);
                    int kettleType = this.getKettleTypeInt(item.getText(2));
                    if (!Const.isEmpty((String)item.getText(3))) continue;
                    switch (kettleType) {
                        case 1: 
                        case 4: 
                        case 5: {
                            item.setText(3, "Numeric");
                            continue block7;
                        }
                        case 2: {
                            item.setText(3, "Nominal");
                            int index = r.indexOfValue(item.getText(1));
                            ValueMetaInterface vm = r.getValueMeta(index);
                            if (vm.getStorageType() != 2) continue block7;
                            Object[] legalValues = vm.getIndex();
                            String vals = "";
                            int j = 0;
                            while (i < legalValues.length) {
                                vals = j != 0 ? vals + "," + legalValues[j].toString() : vals + legalValues[j].toString();
                                ++j;
                            }
                            item.setText(4, vals);
                            continue block7;
                        }
                        case 3: {
                            item.setText(3, "Date");
                            int index = r.indexOfValue(item.getText(1));
                            ValueMetaInterface vm = r.getValueMeta(index);
                            item.setText(4, vm.getDateFormat().toPattern());
                        }
                    }
                }
            }
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(ArffOutputMeta.class, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), e);
            new ErrorDialog(this.shell, BaseMessages.getString(ArffOutputMeta.class, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(ArffOutputMeta.class, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void ok() {
        if (Const.isEmpty((String)this.m_wStepname.getText())) {
            return;
        }
        this.stepname = this.m_wStepname.getText();
        this.m_currentMeta.setFileName(this.m_wFilename.getText());
        String relName = this.m_wRelationName.getText();
        this.m_currentMeta.setRelationName(relName);
        String encoding = this.m_wEncoding.getText();
        this.m_currentMeta.setEncoding(encoding);
        String format = this.m_wFormat.getText();
        this.m_currentMeta.setFileFormat(format);
        int nrNonEmptyFields = this.m_wFields.nrNonEmpty();
        this.m_currentMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.m_wFields.getNonEmpty(i);
            String fieldName = item.getText(1);
            int kettleType = this.getKettleTypeInt(item.getText(2));
            int arffType = this.getArffTypeInt(item.getText(3));
            String nomDate = item.getText(4);
            this.m_currentMeta.getOutputFields()[i] = new ArffMeta(fieldName, kettleType, arffType);
            if (Const.isEmpty((String)nomDate)) continue;
            if (arffType == 1) {
                this.m_currentMeta.getOutputFields()[i].setNominalVals(nomDate);
                continue;
            }
            if (arffType != 2) continue;
            this.m_currentMeta.getOutputFields()[i].setDateFormat(nomDate);
        }
        if (this.m_weightFieldCheckBox.getSelection() && !Const.isEmpty((String)this.m_weightFieldComboBox.getText())) {
            this.m_currentMeta.setWeightFieldName(this.m_weightFieldComboBox.getText());
        } else {
            this.m_currentMeta.setWeightFieldName(null);
        }
        this.m_currentMeta.setOutputSparseIntsances(this.m_sparseOutputCheckBox.getSelection());
        if (!this.m_originalMeta.equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }
}

