/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.arff;

import java.util.List;
import java.util.Map;
import org.pentaho.di.arff.ArffOutput;
import org.pentaho.di.arff.ArffOutputData;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.dm.commons.ArffMeta;
import org.w3c.dom.Node;

@Step(id="ArffOutput", image="AO.png", name="Arff Output", description="Writes data in ARFF format to a file", categoryDescription="Data Mining")
public class ArffOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static Class<?> PKG = ArffOutputMeta.class;
    protected ArffMeta[] m_outputFields;
    protected String m_fileName;
    protected String m_encoding;
    protected String m_newLine;
    protected String m_fileFormat;
    protected String m_relationName;
    protected boolean m_outputSparseInstances;
    protected String m_weightField;

    public ArffOutputMeta() {
        this.setDefault();
    }

    public void allocate(int num) {
        this.m_outputFields = new ArffMeta[num];
    }

    public void setWeightFieldName(String wfn) {
        this.m_weightField = wfn;
    }

    public String getWeightFieldName() {
        return this.m_weightField;
    }

    public void setOutputSparseIntsances(boolean o) {
        this.m_outputSparseInstances = o;
    }

    public boolean getOutputSparseInstance() {
        return this.m_outputSparseInstances;
    }

    public void setRelationName(String r) {
        this.m_relationName = r;
    }

    public String getRelationName() {
        return this.m_relationName;
    }

    public void setFileName(String fn) {
        this.m_fileName = fn;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setEncoding(String e) {
        this.m_encoding = e;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public void setFileFormat(String ff) {
        this.m_fileFormat = ff;
    }

    public String getFileFormat() {
        return this.m_fileFormat;
    }

    public void setOutputFields(ArffMeta[] am) {
        this.m_outputFields = am;
    }

    public ArffMeta[] getOutputFields() {
        return this.m_outputFields;
    }

    public void setupArffMeta(RowMetaInterface rmi) {
        if (rmi != null) {
            this.allocate(rmi.size());
            block5: for (int i = 0; i < this.m_outputFields.length; ++i) {
                ValueMetaInterface inField = rmi.getValueMeta(i);
                int fieldType = inField.getType();
                switch (fieldType) {
                    case 1: 
                    case 4: 
                    case 5: {
                        this.m_outputFields[i] = new ArffMeta(inField.getName(), fieldType, 0);
                        continue block5;
                    }
                    case 2: {
                        this.m_outputFields[i] = new ArffMeta(inField.getName(), fieldType, 1);
                        if (inField.getStorageType() != 2) continue block5;
                        Object[] legalVals = inField.getIndex();
                        StringBuffer temp = new StringBuffer();
                        boolean first = true;
                        for (Object l : legalVals) {
                            if (first) {
                                temp.append(l.toString().trim());
                                first = false;
                                continue;
                            }
                            temp.append(",").append(l.toString().trim());
                        }
                        this.m_outputFields[i].setNominalVals(temp.toString());
                        continue block5;
                    }
                    case 3: {
                        this.m_outputFields[i] = new ArffMeta(inField.getName(), fieldType, 2);
                        this.m_outputFields[i].setDateFormat(inField.getDateFormat().toPattern());
                    }
                }
            }
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        if (this.m_fileName != null) {
            retval.append(XMLHandler.addTagValue((String)"arff_file_name", (String)this.m_fileName));
            retval.append(XMLHandler.addTagValue((String)"relation_name", (String)this.m_relationName));
            retval.append(XMLHandler.addTagValue((String)"file_format", (String)this.m_fileFormat));
            retval.append(XMLHandler.addTagValue((String)"encoding", (String)this.m_encoding));
            retval.append(XMLHandler.addTagValue((String)"output_sparse_instances", (boolean)this.m_outputSparseInstances));
            if (!Const.isEmpty((String)this.m_weightField)) {
                retval.append(XMLHandler.addTagValue((String)"weight_field", (String)this.m_weightField));
            }
            retval.append("    <arff>" + Const.CR);
            if (this.m_outputFields != null) {
                for (int i = 0; i < this.m_outputFields.length; ++i) {
                    if (this.m_outputFields[i] == null) continue;
                    retval.append("        ").append(this.m_outputFields[i].getXML()).append(Const.CR);
                }
            }
            retval.append("    </arff>" + Const.CR);
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.m_fileName = XMLHandler.getTagValue((Node)stepnode, (String)"arff_file_name");
        this.m_relationName = XMLHandler.getTagValue((Node)stepnode, (String)"relation_name");
        this.m_fileFormat = XMLHandler.getTagValue((Node)stepnode, (String)"file_format");
        this.m_encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
        this.m_weightField = XMLHandler.getTagValue((Node)stepnode, (String)"weight_field");
        String osi = XMLHandler.getTagValue((Node)stepnode, (String)"output_sparse_instances");
        if (!Const.isEmpty((String)osi)) {
            this.m_outputSparseInstances = osi.equalsIgnoreCase("Y");
        }
        this.m_newLine = this.getNewLine();
        Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"arff");
        int nrfields = XMLHandler.countNodes((Node)fields, (String)"arff_field");
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"arff_field", (int)i);
            this.m_outputFields[i] = new ArffMeta(fnode);
        }
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_fileName = rep.getStepAttributeString(id_step, 0, "arff_file_name");
        this.m_relationName = rep.getStepAttributeString(id_step, 0, "relation_name");
        this.m_fileFormat = rep.getStepAttributeString(id_step, 0, "file_format");
        this.m_encoding = rep.getStepAttributeString(id_step, 0, "encoding");
        this.m_weightField = rep.getStepAttributeString(id_step, 0, "weight_field");
        this.m_outputSparseInstances = rep.getStepAttributeBoolean(id_step, 0, "output_sparse_instances");
        this.m_newLine = this.getNewLine();
        int nrFields = rep.countNrStepAttributes(id_step, "arff_field");
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.m_outputFields[i] = new ArffMeta(rep, id_step, i);
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (this.m_fileName != null) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "arff_file_name", this.m_fileName);
            rep.saveStepAttribute(id_transformation, id_step, 0, "relation_name", this.m_fileName);
            rep.saveStepAttribute(id_transformation, id_step, 0, "file_format", this.m_fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, 0, "encoding", this.m_encoding);
            rep.saveStepAttribute(id_transformation, id_step, 0, "output_sparse_instances", this.m_outputSparseInstances);
            if (!Const.isEmpty((String)this.m_weightField)) {
                rep.saveStepAttribute(id_transformation, id_step, 0, "weight_field", this.m_weightField);
            }
        }
        if (this.m_outputFields != null) {
            for (int i = 0; i < this.m_outputFields.length; ++i) {
                if (this.m_outputFields[i] == null) continue;
                this.m_outputFields[i].saveRep(rep, id_transformation, id_step, i);
            }
        }
    }

    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(((Object)((Object)this)).getClass())) {
            ArffOutputMeta m = (ArffOutputMeta)((Object)obj);
            return this.getXML() == m.getXML();
        }
        return false;
    }

    public Object clone() {
        ArffOutputMeta retval = (ArffOutputMeta)((Object)super.clone());
        if (this.m_outputFields != null) {
            retval.allocate(this.m_outputFields.length);
            for (int i = 0; i < this.m_outputFields.length; ++i) {
                retval.getOutputFields()[i] = (ArffMeta)this.m_outputFields[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    public void setDefault() {
        this.m_fileFormat = "DOS";
        this.m_fileName = "file";
        this.m_relationName = "NewRelation";
        this.m_weightField = null;
        this.m_newLine = this.getNewLine();
    }

    protected String getNewLine() {
        String nl = System.getProperty("line.separator");
        if (this.m_fileFormat != null) {
            if (this.m_fileFormat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (this.m_fileFormat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    public String getDialogClassName() {
        return "org.pentaho.di.arff.ArffOutputDialog";
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new ArffOutput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new ArffOutputData();
    }
}

