/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.dm.commons;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class ArffMeta
implements Cloneable {
    public static final int NUMERIC = 0;
    public static final int NOMINAL = 1;
    public static final int DATE = 2;
    public static final int STRING = 3;
    private final String m_fieldName;
    private int m_kettleType;
    private int m_arffType;
    private String m_dateFormat;
    private String m_nominalVals;
    public static final String XML_TAG = "arff_field";

    public ArffMeta(String string, int n, int n2) {
        this.m_fieldName = string;
        this.m_kettleType = n;
        this.m_arffType = n2;
    }

    public ArffMeta(Repository repository, ObjectId objectId, int n) throws KettleException {
        this.m_fieldName = repository.getStepAttributeString(objectId, n, "field_name");
        this.m_kettleType = (int)repository.getStepAttributeInteger(objectId, n, "kettle_type");
        this.m_arffType = (int)repository.getStepAttributeInteger(objectId, n, "arff_type");
        this.m_dateFormat = repository.getStepAttributeString(objectId, n, "date_format");
        this.m_nominalVals = repository.getStepAttributeString(objectId, n, "nominal_vals");
    }

    public ArffMeta(Node node) {
        this.m_fieldName = XMLHandler.getTagValue((Node)node, (String)"field_name");
        String string = XMLHandler.getTagValue((Node)node, (String)"kettle_type");
        try {
            this.m_kettleType = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string = XMLHandler.getTagValue((Node)node, (String)"arff_type");
        try {
            this.m_arffType = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_dateFormat = XMLHandler.getTagValue((Node)node, (String)"date_format");
        this.m_nominalVals = XMLHandler.getTagValue((Node)node, (String)"nominal_vals");
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public int getKettleType() {
        return this.m_kettleType;
    }

    public int getArffType() {
        return this.m_arffType;
    }

    public void setDateFormat(String string) {
        this.m_dateFormat = string;
    }

    public String getDateFormat() {
        return this.m_dateFormat;
    }

    public void setNominalVals(String string) {
        this.m_nominalVals = string;
    }

    public String getNominalVals() {
        return this.m_nominalVals;
    }

    public Object clone() {
        try {
            ArffMeta arffMeta = (ArffMeta)super.clone();
            return arffMeta;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getXML() {
        String string = "<arff_field>";
        string = string + XMLHandler.addTagValue((String)"field_name", (String)this.m_fieldName);
        string = string + XMLHandler.addTagValue((String)"kettle_type", (int)this.m_kettleType);
        string = string + XMLHandler.addTagValue((String)"arff_type", (int)this.m_arffType);
        string = string + XMLHandler.addTagValue((String)"date_format", (String)this.m_dateFormat);
        string = string + XMLHandler.addTagValue((String)"nominal_vals", (String)this.m_nominalVals);
        string = string + "</arff_field>";
        return string;
    }

    public void saveRep(Repository repository, ObjectId objectId, ObjectId objectId2, int n) throws KettleException {
        repository.saveStepAttribute(objectId, objectId2, n, "field_name", this.m_fieldName);
        repository.saveStepAttribute(objectId, objectId2, n, "kettle_type", (long)this.m_kettleType);
        repository.saveStepAttribute(objectId, objectId2, n, "arff_type", (long)this.m_arffType);
        repository.saveStepAttribute(objectId, objectId2, n, "date_format", this.m_dateFormat);
        repository.saveStepAttribute(objectId, objectId2, n, "nominal_vals", this.m_nominalVals);
    }

    public static List<String> stringToVals(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Const.isEmpty((String)string)) {
            String[] stringArray;
            for (String string2 : stringArray = string.split(",")) {
                arrayList.add(string2.trim());
            }
        }
        return arrayList;
    }
}

