/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.dm.commons;

import java.io.PrintStream;
import java.io.Serializable;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import weka.gui.Logger;

public class LogAdapter
extends PrintStream
implements Serializable,
Logger,
LogChannelInterface {
    private static final long serialVersionUID = 4861213857483800216L;
    private transient LogChannelInterface m_log;

    public LogAdapter(LogChannelInterface logChannelInterface) {
        super(System.out);
        this.m_log = logChannelInterface;
    }

    public void statusMessage(String string) {
        this.m_log.logDetailed(string);
    }

    public void logMessage(String string) {
        this.m_log.logBasic(string);
    }

    @Override
    public void println(String string) {
        System.out.println(string);
        this.statusMessage(string);
    }

    @Override
    public void println(Object object) {
        this.println(object.toString());
    }

    @Override
    public void print(String string) {
        System.out.print(string);
        this.statusMessage(string);
    }

    @Override
    public void print(Object object) {
        this.print(object.toString());
    }

    public String getContainerObjectId() {
        return this.m_log.getContainerObjectId();
    }

    public String getLogChannelId() {
        return this.m_log.getLogChannelId();
    }

    public LogLevel getLogLevel() {
        return this.m_log.getLogLevel();
    }

    public boolean isBasic() {
        return this.m_log.isBasic();
    }

    public boolean isDebug() {
        return this.m_log.isDebug();
    }

    public boolean isDetailed() {
        return this.m_log.isDetailed();
    }

    public boolean isError() {
        return this.m_log.isError();
    }

    public boolean isRowLevel() {
        return this.m_log.isRowLevel();
    }

    public void logBasic(String string) {
        this.m_log.logBasic(string);
    }

    public void logBasic(String string, Object ... objectArray) {
        this.m_log.logBasic(string, objectArray);
    }

    public void logDebug(String string) {
        this.m_log.logDebug(string);
    }

    public void logDebug(String string, Object ... objectArray) {
        this.m_log.logDebug(string, objectArray);
    }

    public void logDetailed(String string) {
        this.m_log.logDetailed(string);
    }

    public void logDetailed(String string, Object ... objectArray) {
        this.m_log.logDetailed(string, objectArray);
    }

    public void logError(String string) {
        this.m_log.logError(string);
    }

    public void logError(String string, Throwable throwable) {
        this.m_log.logError(string, throwable);
    }

    public void logError(String string, Object ... objectArray) {
        this.m_log.logError(string, objectArray);
    }

    public void logMinimal(String string) {
        this.m_log.logMinimal(string);
    }

    public void logMinimal(String string, Object ... objectArray) {
        this.m_log.logMinimal(string, objectArray);
    }

    public void logRowlevel(String string) {
        this.m_log.logRowlevel(string);
    }

    public void logRowlevel(String string, Object ... objectArray) {
        this.m_log.logRowlevel(string, objectArray);
    }

    public void setContainerObjectId(String string) {
        this.m_log.setContainerObjectId(string);
    }

    public void setLogLevel(LogLevel logLevel) {
        this.m_log.setLogLevel(logLevel);
    }
}

