/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.bayes.NaiveBayesUpdateable;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public final class NBTreeNoSplit
extends ClassifierSplitModel {
    private static final long serialVersionUID = 7824804381545259618L;
    private NaiveBayesUpdateable m_nb;
    private Discretize m_disc;
    private double m_errors;

    public NBTreeNoSplit() {
        this.m_numSubsets = 1;
    }

    @Override
    public final void buildClassifier(Instances instances) throws Exception {
        this.m_nb = new NaiveBayesUpdateable();
        this.m_disc = new Discretize();
        this.m_disc.setInputFormat(instances);
        Instances temp = Filter.useFilter(instances, this.m_disc);
        this.m_nb.buildClassifier(temp);
        if (temp.numInstances() >= 5) {
            this.m_errors = NBTreeNoSplit.crossValidate(this.m_nb, temp, new Random(1L));
        }
        this.m_numSubsets = 1;
    }

    public double getErrors() {
        return this.m_errors;
    }

    public Discretize getDiscretizer() {
        return this.m_disc;
    }

    public NaiveBayesUpdateable getNaiveBayesModel() {
        return this.m_nb;
    }

    @Override
    public final int whichSubset(Instance instance) {
        return 0;
    }

    @Override
    public final double[] weights(Instance instance) {
        return null;
    }

    @Override
    public final String leftSide(Instances instances) {
        return "";
    }

    @Override
    public final String rightSide(int index, Instances instances) {
        return "";
    }

    @Override
    public final String sourceExpression(int index, Instances data) {
        return "true";
    }

    @Override
    public double classProb(int classIndex, Instance instance, int theSubset) throws Exception {
        this.m_disc.input(instance);
        Instance temp = this.m_disc.output();
        return this.m_nb.distributionForInstance(temp)[classIndex];
    }

    public String toString() {
        return this.m_nb.toString();
    }

    public static double crossValidate(NaiveBayesUpdateable fullModel, Instances trainingSet, Random r) throws Exception {
        Classifier[] copies = AbstractClassifier.makeCopies(fullModel, 5);
        Evaluation eval = new Evaluation(trainingSet);
        for (int j = 0; j < 5; ++j) {
            Instances test = trainingSet.testCV(5, j);
            for (int k = 0; k < test.numInstances(); ++k) {
                test.instance(k).setWeight(-test.instance(k).weight());
                ((NaiveBayesUpdateable)copies[j]).updateClassifier(test.instance(k));
                test.instance(k).setWeight(-test.instance(k).weight());
            }
            eval.evaluateModel(copies[j], test, new Object[0]);
        }
        return eval.incorrect();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9615 $");
    }
}

