/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class MergeManyValues
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    private static final long serialVersionUID = 4649332102154713625L;
    protected SingleIndex m_AttIndex = new SingleIndex("last");
    protected String m_Label = "merged";
    protected Range m_MergeRange = new Range("1,2");

    public String globalInfo() {
        return "Merges many values of a nominal attribute into one value.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tSets the attribute index\n\t(default: last)", "C", 1, "-C <col>"));
        newVector.addElement(new Option("\tSets the label of the newly merged classes\n\t(default: 'merged')", "L", 1, "-L <label>"));
        newVector.addElement(new Option("\tSets the merge range. 'first and 'last' are accepted as well.'\n\tE.g.: first-5,7,9,20-last\n\t(default: 1,2)", "R", 1, "-R <range>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndex(tmpStr);
        } else {
            this.setAttributeIndex("last");
        }
        tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setLabel(tmpStr);
        } else {
            this.setLabel("merged");
        }
        tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setMergeValueRange(tmpStr);
        } else {
            this.setMergeValueRange("1,2");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add(this.getAttributeIndex());
        result.add("-L");
        result.add(this.getLabel());
        result.add("-R");
        result.add(this.getMergeValueRange());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        this.m_MergeRange.setUpper(instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() - 1);
        if (instanceInfo.classIndex() > -1 && instanceInfo.classIndex() == this.m_AttIndex.getIndex()) {
            throw new Exception("Cannot process class attribute.");
        }
        if (!instanceInfo.attribute(this.m_AttIndex.getIndex()).isNominal()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not nominal.");
        }
        if (instanceInfo.attribute(this.m_AttIndex.getIndex()).numValues() < 2) {
            throw new UnsupportedAttributeTypeException("Chosen attribute has less than two values.");
        }
        this.setOutputFormat();
        return true;
    }

    private void setOutputFormat() {
        FastVector<Attribute> newAtts = new FastVector<Attribute>(this.getInputFormat().numAttributes());
        for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
            Attribute att = this.getInputFormat().attribute(j);
            if (j != this.m_AttIndex.getIndex()) {
                newAtts.addElement((Attribute)att.copy());
                continue;
            }
            FastVector<String> newVals = new FastVector<String>(att.numValues() - 1);
            for (int i = 0; i < att.numValues(); ++i) {
                boolean inMergeList = false;
                inMergeList = att.value(i).equalsIgnoreCase(this.m_Label) ? true : this.m_MergeRange.isInRange(i);
                if (inMergeList) continue;
                newVals.addElement(att.value(i));
            }
            newVals.addElement(this.m_Label);
            Attribute newAtt = new Attribute(att.name(), newVals);
            newAtt.setWeight(this.getInputFormat().attribute(j).weight());
            newAtts.addElement(newAtt);
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Attribute att = this.getInputFormat().attribute(this.m_AttIndex.getIndex());
        FastVector<String> newVals = new FastVector<String>(att.numValues() - 1);
        for (int i = 0; i < att.numValues(); ++i) {
            boolean inMergeList = false;
            inMergeList = att.value(i).equalsIgnoreCase(this.m_Label) ? true : this.m_MergeRange.isInRange(i);
            if (inMergeList) continue;
            newVals.addElement(att.value(i));
        }
        newVals.addElement(this.m_Label);
        Attribute temp = new Attribute(att.name(), newVals);
        Instance newInstance = (Instance)instance.copy();
        if (!newInstance.isMissing(this.m_AttIndex.getIndex())) {
            String currValue = newInstance.stringValue(this.m_AttIndex.getIndex());
            if (temp.indexOfValue(currValue) == -1) {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)temp.indexOfValue(this.m_Label));
            } else {
                newInstance.setValue(this.m_AttIndex.getIndex(), (double)temp.indexOfValue(currValue));
            }
        }
        this.push(newInstance);
        return true;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be nominal (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String attIndex) {
        this.m_AttIndex.setSingleIndex(attIndex);
    }

    public String labelTipText() {
        return "The new label for the merged values.";
    }

    public String getLabel() {
        return this.m_Label;
    }

    public void setLabel(String alabel) {
        this.m_Label = alabel;
    }

    public String getMergeValueRange() {
        return this.m_MergeRange.getRanges();
    }

    public String mergeValueRangeTipText() {
        return "The range of values to merge.";
    }

    public void setMergeValueRange(String range) {
        this.m_MergeRange.setRanges(range);
    }

    @Override
    public String getRevision() {
        return "$Revision: 8287 $";
    }

    public static void main(String[] args) {
        MergeManyValues.runFilter(new MergeManyValues(), args);
    }
}

