/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shapefilereader;

import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.shapefilereader.ShapeFileReaderData;
import org.pentaho.di.shapefilereader.ShapeFileReaderMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeFile;
import org.pentaho.gis.shapefiles.ShapeInterface;
import org.pentaho.gis.shapefiles.ShapePoint;
import org.pentaho.gis.shapefiles.ShapePolyLine;
import org.pentaho.gis.shapefiles.ShapePolyLineM;
import org.pentaho.gis.shapefiles.ShapePolygon;

public class ShapeFileReader
extends BaseStep
implements StepInterface {
    private ShapeFileReaderMeta meta;
    private ShapeFileReaderData data;

    public ShapeFileReader(StepMeta stepMeta, StepDataInterface stepDataInterface, int n, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, n, transMeta, trans);
    }

    public synchronized boolean processRow(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleStepException {
        this.meta = (ShapeFileReaderMeta)stepMetaInterface;
        this.data = (ShapeFileReaderData)stepDataInterface;
        boolean bl = true;
        if (this.data.shapeNr >= this.data.shapeFile.getNrShapes()) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
        }
        Object[] objectArray = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        ShapeInterface shapeInterface = this.data.shapeFile.getShape(this.data.shapeNr);
        switch (shapeInterface.getType()) {
            case 23: {
                ShapePolyLineM shapePolyLineM = (ShapePolyLineM)shapeInterface;
                int n = 0;
                for (int i = 0; i < shapePolyLineM.nrpoints; ++i) {
                    for (int j = 0; j < shapePolyLineM.nrparts; ++j) {
                        if (i != shapePolyLineM.part_starts[j]) continue;
                        ++n;
                    }
                    int n2 = 0;
                    objectArray[n2++] = this.meta.getShapeFilename();
                    objectArray[n2++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                    objectArray[n2++] = new Long(this.data.shapeNr + 1);
                    objectArray[n2++] = new Long(n);
                    objectArray[n2++] = new Long(shapePolyLineM.nrparts);
                    objectArray[n2++] = new Long(i + 1);
                    objectArray[n2++] = new Long(shapePolyLineM.nrpoints);
                    objectArray[n2++] = new Double(shapePolyLineM.point[i].x);
                    objectArray[n2++] = new Double(shapePolyLineM.point[i].y);
                    objectArray[n2++] = new Double(shapePolyLineM.measures[i]);
                    Object[] objectArray2 = shapeInterface.getDbfData();
                    RowMetaInterface rowMetaInterface = shapeInterface.getDbfMeta();
                    for (int j = 0; j < rowMetaInterface.size(); ++j) {
                        objectArray[n2++] = objectArray2[j];
                    }
                    ++this.linesInput;
                    this.putRow(this.data.outputRowMeta, objectArray);
                }
                break;
            }
            case 5: {
                ShapePolygon shapePolygon = (ShapePolygon)shapeInterface;
                int n = 0;
                for (int i = 0; i < shapePolygon.nrpoints; ++i) {
                    for (int j = 0; j < shapePolygon.nrparts; ++j) {
                        if (i != shapePolygon.part_starts[j]) continue;
                        ++n;
                    }
                    int n3 = 0;
                    objectArray[n3++] = this.meta.getShapeFilename();
                    objectArray[n3++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                    objectArray[n3++] = new Long(this.data.shapeNr + 1);
                    objectArray[n3++] = new Long(n);
                    objectArray[n3++] = new Long(shapePolygon.nrparts);
                    objectArray[n3++] = new Long(i + 1);
                    objectArray[n3++] = new Long(shapePolygon.nrpoints);
                    objectArray[n3++] = new Double(shapePolygon.point[i].x);
                    objectArray[n3++] = new Double(shapePolygon.point[i].y);
                    objectArray[n3++] = new Double(0.0);
                    Object[] objectArray3 = shapeInterface.getDbfData();
                    RowMetaInterface rowMetaInterface = shapeInterface.getDbfMeta();
                    for (int j = 0; j < rowMetaInterface.size(); ++j) {
                        objectArray[n3++] = objectArray3[j];
                    }
                    ++this.linesInput;
                    this.putRow(this.data.outputRowMeta, objectArray);
                }
                break;
            }
            case 3: {
                ShapePolyLine shapePolyLine = (ShapePolyLine)shapeInterface;
                int n = 0;
                for (int i = 0; i < shapePolyLine.nrpoints; ++i) {
                    for (int j = 0; j < shapePolyLine.nrparts; ++j) {
                        if (i != shapePolyLine.part_starts[j]) continue;
                        ++n;
                    }
                    int n4 = 0;
                    objectArray[n4++] = this.meta.getShapeFilename();
                    objectArray[n4++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                    objectArray[n4++] = new Long(this.data.shapeNr + 1);
                    objectArray[n4++] = new Long(n);
                    objectArray[n4++] = new Long(shapePolyLine.nrparts);
                    objectArray[n4++] = new Long(i + 1);
                    objectArray[n4++] = new Long(shapePolyLine.nrpoints);
                    objectArray[n4++] = new Double(shapePolyLine.point[i].x);
                    objectArray[n4++] = new Double(shapePolyLine.point[i].y);
                    objectArray[n4++] = new Double(0.0);
                    Object[] objectArray4 = shapeInterface.getDbfData();
                    RowMetaInterface rowMetaInterface = shapeInterface.getDbfMeta();
                    for (int j = 0; j < rowMetaInterface.size(); ++j) {
                        objectArray[n4++] = objectArray4[j];
                    }
                    ++this.linesInput;
                    this.putRow(this.data.outputRowMeta, objectArray);
                }
                break;
            }
            case 1: {
                ShapePoint shapePoint = (ShapePoint)shapeInterface;
                int n = 0;
                objectArray[n++] = this.meta.getShapeFilename();
                objectArray[n++] = this.data.shapeFile.getFileHeader().getShapeTypeDesc();
                objectArray[n++] = new Long(this.data.shapeNr);
                objectArray[n++] = new Long(0L);
                objectArray[n++] = new Long(0L);
                objectArray[n++] = new Long(0L);
                objectArray[n++] = new Long(0L);
                objectArray[n++] = new Double(shapePoint.x);
                objectArray[n++] = new Double(shapePoint.y);
                objectArray[n++] = new Double(0.0);
                Object[] objectArray5 = shapeInterface.getDbfData();
                RowMetaInterface rowMetaInterface = shapeInterface.getDbfMeta();
                for (int i = 0; i < rowMetaInterface.size(); ++i) {
                    objectArray[n++] = objectArray5[i];
                }
                ++this.linesInput;
                this.putRow(this.data.outputRowMeta, objectArray);
                break;
            }
            default: {
                System.out.println("Unable to parse shape type [" + Shape.getEsriTypeDesc(shapeInterface.getType()) + "] : not yet implemented.");
                throw new KettleStepException("Unable to parse shape type [" + Shape.getEsriTypeDesc(shapeInterface.getType()) + "] : not yet implemented.");
            }
        }
        ++this.data.shapeNr;
        if (this.linesInput % 50000L == 0L) {
            this.logBasic("linenr " + this.linesInput);
        }
        return bl;
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        this.meta = (ShapeFileReaderMeta)stepMetaInterface;
        this.data = (ShapeFileReaderData)stepDataInterface;
        if (super.init((StepMetaInterface)this.meta, (StepDataInterface)this.data)) {
            if (this.meta.getShapeFilename() == null || this.meta.getDbfFilename() == null || this.meta.getShapeFilename().length() == 0 || this.meta.getDbfFilename().length() == 0) {
                this.logError("We need both a shapefile and a DBF file.");
                return false;
            }
            this.data.shapeFile = new ShapeFile(this.log, this.meta.getShapeFilename(), this.meta.getDbfFilename());
            try {
                this.data.shapeFile.readFile();
            }
            catch (Exception exception) {
                this.logError("Unable to read shapefile [" + this.meta.getShapeFilename() + "] because of an error: " + exception.toString());
                return false;
            }
            this.data.shapeNr = 0;
        }
        return true;
    }

    public void dispose(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        this.meta = (ShapeFileReaderMeta)stepMetaInterface;
        this.data = (ShapeFileReaderData)stepDataInterface;
        super.dispose(stepMetaInterface, stepDataInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception exception) {
            this.logError("Unexpected error", exception);
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logBasic("Finished, processed " + this.linesInput + " rows, written " + this.linesWritten + " lines.");
            this.markStop();
        }
    }
}

