/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.GisException;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeFileHeader;
import org.pentaho.gis.shapefiles.ShapeInterface;
import org.pentaho.gis.shapefiles.ShapeNull;
import org.pentaho.gis.shapefiles.ShapePoint;
import org.pentaho.gis.shapefiles.ShapePolyLine;
import org.pentaho.gis.shapefiles.ShapePolyLineM;
import org.pentaho.gis.shapefiles.ShapePolygon;
import org.pentaho.gis.shapefiles.ShapeRecordHeader;

public class ShapeFile {
    private List<ShapeInterface> shapes;
    private ShapeFileHeader fileheader;
    private LogChannelInterface log;
    private String dbfFilename;
    private String shapeFilename;

    public ShapeFile(LogChannelInterface logChannelInterface, String string) {
        this.log = logChannelInterface;
        this.dbfFilename = string + ".dbf";
        this.shapeFilename = string + ".shp";
        this.shapes = new ArrayList<ShapeInterface>();
    }

    public ShapeFile(LogChannelInterface logChannelInterface, String string, String string2) {
        this.log = logChannelInterface;
        this.shapeFilename = string;
        this.dbfFilename = string2;
        this.shapes = new ArrayList<ShapeInterface>();
    }

    public String getShapeFilename() {
        return this.shapeFilename;
    }

    public String getDbfFilename() {
        return this.dbfFilename;
    }

    public void readFile() throws GisException, KettleException {
        File file = new File(this.shapeFilename);
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            XBase xBase = new XBase(this.log, this.dbfFilename);
            xBase.open();
            RowMetaInterface rowMetaInterface = xBase.getFields();
            byte[] byArray = new byte[100];
            dataInputStream.read(byArray);
            this.fileheader = new ShapeFileHeader(byArray);
            int n = 0;
            while (dataInputStream.available() > 0) {
                byte[] byArray2 = new byte[8];
                dataInputStream.read(byArray2);
                ShapeRecordHeader shapeRecordHeader = new ShapeRecordHeader(byArray2);
                if (shapeRecordHeader.length > dataInputStream.available()) continue;
                byte[] byArray3 = new byte[shapeRecordHeader.length];
                dataInputStream.read(byArray3);
                int n2 = Converter.getIntegerLittle(byArray3, 0);
                Shape shape = null;
                switch (n2) {
                    case 0: {
                        shape = new ShapeNull(byArray3);
                        break;
                    }
                    case 1: {
                        shape = new ShapePoint(byArray3);
                        break;
                    }
                    case 3: {
                        shape = new ShapePolyLine(byArray3);
                        break;
                    }
                    case 5: {
                        shape = new ShapePolygon(byArray3);
                        break;
                    }
                    case 23: {
                        shape = new ShapePolyLineM(byArray3);
                        break;
                    }
                    default: {
                        throw new GisException("shape type : " + n2 + " not recognized! (" + Shape.getEsriTypeDesc(n2) + ")");
                    }
                }
                Object[] objectArray = xBase.getRow(rowMetaInterface);
                if (objectArray != null) {
                    shape.setDbfData(objectArray);
                    shape.setDbfMeta(xBase.getFields());
                }
                this.shapes.add((ShapeInterface)((Object)shape));
                ++n;
            }
            dataInputStream.close();
            xBase.close();
        }
        catch (IOException iOException) {
            throw new GisException("Error reading shape file", iOException);
        }
    }

    public int getNrShapes() {
        return this.shapes.size();
    }

    public ShapeInterface getShape(int n) {
        return this.shapes.get(n);
    }

    public void addShape(ShapeInterface shapeInterface) {
        this.shapes.add(shapeInterface);
    }

    public ShapeFileHeader getFileHeader() {
        return this.fileheader;
    }

    public String getFilename() {
        return this.shapeFilename;
    }
}

