/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FunctionParameterContext;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.ParameterUpdateListener;
import org.pentaho.openformula.ui.util.SelectFieldAction;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class DefaultFunctionParameterEditor
extends JPanel
implements FunctionParameterEditor {
    private static final JTextField[] EMPTY_FIELDS = new JTextField[0];
    private static final SelectFieldAction[] EMPTY_ACTIONS = new SelectFieldAction[0];
    private static final FieldDefinition[] EMPTY_FIELDDEF = new FieldDefinition[0];
    private static final FocusListenerHandler[] EMPTY_HANDLERS = new FocusListenerHandler[0];
    private FunctionDescription selectedFunction;
    private JPanel parameterPane = new JPanel();
    private FocusListenerHandler[] changeHandlers;
    private JTextField[] textFields;
    private SelectFieldAction[] selectFieldActions;
    private FieldDefinition[] fields;
    private int functionStartIndex;
    private boolean inParameterUpdate;
    private boolean inSetupUpdate;

    public DefaultFunctionParameterEditor() {
        this.parameterPane.setLayout(new GridBagLayout());
        this.textFields = EMPTY_FIELDS;
        this.selectFieldActions = EMPTY_ACTIONS;
        this.fields = EMPTY_FIELDDEF;
        this.changeHandlers = EMPTY_HANDLERS;
        JPanel parameterPaneCarrier = new JPanel();
        parameterPaneCarrier.setLayout(new BorderLayout());
        parameterPaneCarrier.add((Component)this.parameterPane, "North");
        JScrollPane comp = new JScrollPane(parameterPaneCarrier);
        comp.setBorder(new EmptyBorder(0, 0, 0, 0));
        comp.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.setLayout(new CardLayout());
        this.add("2", comp);
        this.add("1", Box.createRigidArea(new Dimension(650, 250)));
    }

    public FunctionDescription getSelectedFunction() {
        return this.selectedFunction;
    }

    public void clearSelectedFunction() {
        this.setSelectedFunction(new FunctionParameterContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFunction(FunctionParameterContext context) {
        if (this.inParameterUpdate) {
            return;
        }
        try {
            this.inSetupUpdate = true;
            int functionStart = context.getFunctionParameterStartPosition();
            FunctionDescription selectedFunction = context.getFunction();
            String[] parameterValues = context.getParameterValues();
            FunctionDescription old = this.selectedFunction;
            if (this.functionStartIndex == functionStart && FunctionParameterContext.isSameFunctionDescription(old, selectedFunction) && parameterValues.length == this.textFields.length) {
                for (int i = 0; i < parameterValues.length; ++i) {
                    String string = parameterValues[i];
                    this.textFields[i].setText(string);
                }
                return;
            }
            this.selectedFunction = selectedFunction;
            this.functionStartIndex = functionStart;
            this.parameterPane.removeAll();
            if (selectedFunction == null) {
                for (int i = 0; i < this.selectFieldActions.length; ++i) {
                    this.selectFieldActions[i].dispose();
                }
                this.selectFieldActions = EMPTY_ACTIONS;
                this.textFields = EMPTY_FIELDS;
                this.changeHandlers = EMPTY_HANDLERS;
                this.invalidate();
                this.revalidate();
                this.repaint();
                return;
            }
            int count = DefaultFunctionParameterEditor.computeFunctionParameterCount(selectedFunction);
            this.selectFieldActions = new SelectFieldAction[count];
            this.textFields = new JTextField[count];
            this.changeHandlers = new FocusListenerHandler[count];
            for (int i = 0; i < count; ++i) {
                this.addTextField(parameterValues[i], i);
            }
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
        finally {
            this.inSetupUpdate = false;
        }
    }

    private void addTextField(String parameterValue, int parameterPosition) {
        int paramPos = Math.max(0, Math.min(this.selectedFunction.getParameterCount() - 1, parameterPosition));
        String displayName = this.selectedFunction.getParameterDisplayName(paramPos, Locale.getDefault());
        String description = this.selectedFunction.getParameterDescription(paramPos, Locale.getDefault());
        JLabel paramNameLabel = new JLabel(displayName);
        JTextField paramTextField = new JTextField();
        paramTextField.setText(parameterValue);
        paramTextField.setFont(new Font("Monospaced", paramTextField.getFont().getStyle(), paramTextField.getFont().getSize()));
        FocusListenerHandler handler = new FocusListenerHandler(paramTextField, parameterPosition);
        paramTextField.addFocusListener(handler);
        paramTextField.getDocument().addDocumentListener(handler);
        SelectFieldAction action = new SelectFieldAction(this, new FieldSelectorUpdateHandler(parameterPosition));
        action.setFields(this.fields);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        this.parameterPane.add((Component)paramNameLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        this.parameterPane.add((Component)paramTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        this.parameterPane.add((Component)new BorderlessButton((Action)action), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = parameterPosition;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 5, 3, 5);
        TooltipLabel label = new TooltipLabel(description);
        label.setToolTipText(description);
        this.parameterPane.add((Component)label, gbc);
        this.changeHandlers[parameterPosition] = handler;
        this.textFields[parameterPosition] = paramTextField;
        this.selectFieldActions[parameterPosition] = action;
    }

    public static int computeFunctionParameterCount(FunctionDescription selectedFunction) {
        int count = selectedFunction.isInfiniteParameterCount() ? Math.max(16, selectedFunction.getParameterCount()) : selectedFunction.getParameterCount();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterValue(int param, String value) {
        if (this.inSetupUpdate) {
            return;
        }
        try {
            this.inParameterUpdate = true;
            this.textFields[param].setText(value);
        }
        finally {
            this.inParameterUpdate = false;
        }
    }

    public String getParameterValue(int param) {
        return this.textFields[param].getText();
    }

    public void addParameterUpdateListener(ParameterUpdateListener listener) {
        this.listenerList.add(ParameterUpdateListener.class, listener);
    }

    public void removeParameterUpdateListener(ParameterUpdateListener listener) {
        this.listenerList.remove(ParameterUpdateListener.class, listener);
    }

    protected void fireParameterUpdate(int param, String text) {
        boolean catchAllParameter = param == this.getParameterCount() - 1;
        ParameterUpdateListener[] updateListeners = (ParameterUpdateListener[])this.listenerList.getListeners(ParameterUpdateListener.class);
        for (int i = 0; i < updateListeners.length; ++i) {
            ParameterUpdateListener listener = updateListeners[i];
            listener.parameterUpdated(new ParameterUpdateEvent(this, param, text, catchAllParameter));
        }
    }

    public void setFields(FieldDefinition[] fields) {
        this.fields = (FieldDefinition[])fields.clone();
    }

    public int getParameterCount() {
        return this.textFields.length;
    }

    public Component getEditorComponent() {
        return this;
    }

    private static class TooltipLabel
    extends JLabel {
        private TooltipLabel(String description) {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("images/InfoIcon.png"));
            this.setIcon(imageIcon);
            this.setToolTipText(description);
        }
    }

    private class FocusListenerHandler
    implements FocusListener,
    Runnable,
    DocumentListener {
        private JTextField paramTextField;
        private int parameterIndex;
        private String oldText;

        private FocusListenerHandler(JTextField paramTextField, int parameterIndex) {
            this.paramTextField = paramTextField;
            this.parameterIndex = parameterIndex;
            this.oldText = this.paramTextField.getText();
        }

        public void insertUpdate(DocumentEvent e) {
            if (DefaultFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        public void removeUpdate(DocumentEvent e) {
            if (DefaultFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        public void changedUpdate(DocumentEvent e) {
            if (DefaultFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        public void focusGained(FocusEvent e) {
            if (DefaultFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        public void focusLost(FocusEvent e) {
            if (DefaultFunctionParameterEditor.this.inSetupUpdate) {
                return;
            }
            SwingUtilities.invokeLater(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean oldParameterUpdate = DefaultFunctionParameterEditor.this.inParameterUpdate;
            try {
                DefaultFunctionParameterEditor.this.inParameterUpdate = true;
                if (this.parameterIndex < DefaultFunctionParameterEditor.this.getParameterCount()) {
                    String s = this.paramTextField.getText();
                    int caretPosition = this.paramTextField.getCaretPosition();
                    if (ObjectUtilities.equal((Object)s, (Object)this.oldText)) {
                        return;
                    }
                    DefaultFunctionParameterEditor.this.fireParameterUpdate(this.parameterIndex, s);
                    this.oldText = s;
                    this.paramTextField.setCaretPosition(caretPosition);
                }
            }
            finally {
                DefaultFunctionParameterEditor.this.inParameterUpdate = oldParameterUpdate;
            }
        }
    }

    private class FieldSelectorUpdateHandler
    implements PropertyChangeListener {
        private int paramIndex;

        private FieldSelectorUpdateHandler(int paramIndex) {
            this.paramIndex = paramIndex;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FieldDefinition value = (FieldDefinition)evt.getNewValue();
            String text = FormulaUtil.quoteReference((String)value.getName());
            DefaultFunctionParameterEditor.this.setParameterValue(this.paramIndex, text);
        }
    }
}

