/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.pentaho.openformula.ui.DefaultFunctionParameterEditor;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.FormulaEditorModel;
import org.pentaho.openformula.ui.FunctionInformationPanel;
import org.pentaho.openformula.ui.FunctionListPanel;
import org.pentaho.openformula.ui.FunctionParameterContext;
import org.pentaho.openformula.ui.FunctionParameterEditor;
import org.pentaho.openformula.ui.Messages;
import org.pentaho.openformula.ui.MultiplexFunctionParameterEditor;
import org.pentaho.openformula.ui.ParameterUpdateEvent;
import org.pentaho.openformula.ui.ParameterUpdateListener;
import org.pentaho.openformula.ui.model2.FunctionInformation;
import org.pentaho.openformula.ui.util.SelectFieldAction;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.HorizontalLayout;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.ToolbarButton;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeUtil;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;

public class FormulaEditorDialog
extends CommonDialog {
    private boolean ignoreTextEvents;
    private FunctionListPanel functionSelectorPanel;
    private MultiplexFunctionParameterEditor functionParameterEditor;
    private FunctionInformationPanel functionInformationPanel;
    private FormulaContext formulaContext;
    private JTextArea functionTextArea;
    private JLabel errorTextHolder;
    private JLabel errorIconHolder;
    private FieldDefinition[] fields;
    private FormulaEditorModel editorModel;
    private ImageIcon errorIcon;
    private SelectFieldAction selectFieldsAction;

    public FormulaEditorDialog() {
        this.init();
    }

    public FormulaEditorDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public FormulaEditorDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    protected void insertText(String text) {
        int start = this.functionTextArea.getCaretPosition();
        StringBuilder formulaText = new StringBuilder(this.editorModel.getFormulaText());
        int textLength = text.length();
        if (formulaText.charAt(0) == '=' && formulaText.length() == 1 && text.startsWith("=")) {
            formulaText.append(text.substring(1));
            --textLength;
        } else {
            formulaText.insert(start, text);
        }
        this.ignoreTextEvents = true;
        this.editorModel.setFormulaText(formulaText.toString());
        this.functionTextArea.setText(formulaText.toString());
        this.ignoreTextEvents = false;
        this.functionTextArea.setCaretPosition(textLength + start);
        this.functionTextArea.requestFocus();
        this.revalidateParameters();
        this.revalidateFormulaSyntax();
    }

    public void setEditor(String function, FunctionParameterEditor editor) {
        this.functionParameterEditor.setEditor(function, editor);
    }

    public FunctionParameterEditor getEditor(String function) {
        return this.functionParameterEditor.getEditor(function);
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.editorModel = new FormulaEditorModel();
        this.functionInformationPanel = new FunctionInformationPanel();
        this.functionParameterEditor = new MultiplexFunctionParameterEditor();
        this.functionParameterEditor.addParameterUpdateListener(new ParameterUpdateHandler());
        this.functionTextArea = new JTextArea();
        this.functionTextArea.getDocument().addDocumentListener(new DocumentSyncHandler());
        this.functionTextArea.setRows(6);
        this.functionTextArea.addCaretListener(new CaretHandler());
        this.functionTextArea.setFont(new Font("Monospaced", this.functionTextArea.getFont().getStyle(), this.functionTextArea.getFont().getSize()));
        this.formulaContext = new DefaultFormulaContext();
        this.functionSelectorPanel = new FunctionListPanel();
        this.functionSelectorPanel.addPropertyChangeListener("selectedValue", new FunctionDescriptionUpdateHandler());
        this.functionSelectorPanel.addActionListener(new FunctionDescriptionUpdateHandler());
        this.functionSelectorPanel.setFormulaContext(this.formulaContext);
        this.errorIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/pentaho/openformula/ui/images/error.gif"));
        this.errorIconHolder = new JLabel();
        this.errorTextHolder = new JLabel();
        this.selectFieldsAction = new SelectFieldAction((Component)((Object)this), new FieldSelectorListener());
        this.setTitle(Messages.getInstance().getString("FormulaEditorDialog.Title"));
        this.setModal(true);
        this.setResizable(true);
        super.init();
        LibSwingUtil.positionDialogRelativeToParent((Dialog)((Object)this), (double)0.5, (double)0.5);
    }

    private JComponent buildFormulaTextPanel() {
        JToolBar operatorButtonPanel = this.createOperatorPanel();
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 0, 5, 0);
        textPanel.add((Component)operatorButtonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        textPanel.add((Component)new JLabel(Messages.getInstance().getString("FormulaEditorDialog.Formula")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        textPanel.add((Component)this.errorIconHolder, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 1;
        textPanel.add((Component)this.errorTextHolder, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        textPanel.add((Component)new JScrollPane(this.functionTextArea), gbc);
        return textPanel;
    }

    protected JToolBar createOperatorPanel() {
        JToolBar operatorButtonPanel = new JToolBar();
        operatorButtonPanel.setFloatable(false);
        operatorButtonPanel.setOpaque(false);
        operatorButtonPanel.setLayout((LayoutManager)new HorizontalLayout(2));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("+", Messages.getInstance().getString("FormulaEditorDialog.Operator.Add"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("-", Messages.getInstance().getString("FormulaEditorDialog.Operator.Subtract"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("*", Messages.getInstance().getString("FormulaEditorDialog.Operator.Multiply"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("/", Messages.getInstance().getString("FormulaEditorDialog.Operator.Divide"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("^", Messages.getInstance().getString("FormulaEditorDialog.Operator.Power"))));
        operatorButtonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("=", Messages.getInstance().getString("FormulaEditorDialog.Operator.Equal"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("<>", Messages.getInstance().getString("FormulaEditorDialog.Operator.NotEqual"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("<", Messages.getInstance().getString("FormulaEditorDialog.Operator.Lesser"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction(">", Messages.getInstance().getString("FormulaEditorDialog.Operator.Greater"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("<=", Messages.getInstance().getString("FormulaEditorDialog.Operator.LesserEqual"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction(">=", Messages.getInstance().getString("FormulaEditorDialog.Operator.GreaterEqual"))));
        operatorButtonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("%", Messages.getInstance().getString("FormulaEditorDialog.Operator.Percentage"))));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)new InsertOperatorAction("&", Messages.getInstance().getString("FormulaEditorDialog.Operator.Concatenation"))));
        operatorButtonPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        operatorButtonPanel.add((Component)new ToolbarButton((Action)this.selectFieldsAction));
        return operatorButtonPanel;
    }

    protected JPanel createContentPane() {
        JPanel functionPanel = new JPanel(new BorderLayout());
        functionPanel.add(this.functionParameterEditor.getEditorComponent(), "Center");
        functionPanel.add((Component)this.buildFormulaTextPanel(), "South");
        JPanel formulaPanel = new JPanel(new BorderLayout());
        formulaPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        formulaPanel.add((Component)this.functionSelectorPanel, "West");
        formulaPanel.add((Component)this.functionInformationPanel, "South");
        formulaPanel.add((Component)functionPanel, "Center");
        return formulaPanel;
    }

    public String editFormula(String formula, FieldDefinition[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        if (StringUtils.isEmpty((String)formula, (boolean)true)) {
            this.setFormulaText("=");
        } else {
            this.setFormulaText(formula);
        }
        this.setFields(fields);
        if (!super.performEdit()) {
            return null;
        }
        String formulaText = this.getFormulaText();
        if (formulaText.trim().equals("=")) {
            return null;
        }
        return formulaText;
    }

    public String editFormulaFragment(String formula, FieldDefinition[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        if (StringUtils.isEmpty((String)formula, (boolean)true)) {
            this.setFormulaText("=");
        } else {
            this.setFormulaText("=" + formula);
        }
        this.setFields(fields);
        this.setVisible(true);
        if (!this.performEdit()) {
            return null;
        }
        String formulaText = this.getFormulaText();
        if (formulaText.trim().equals("=")) {
            return null;
        }
        return FormulaUtil.extractFormula((String)formulaText);
    }

    public String getFormulaText() {
        return this.functionTextArea.getText();
    }

    public void setFormulaText(String formulaText) {
        this.functionTextArea.setText(formulaText);
        this.functionTextArea.setCaretPosition(formulaText.length());
    }

    public void setFields(FieldDefinition[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.fields = (FieldDefinition[])fields.clone();
        this.functionParameterEditor.setFields(fields);
        this.selectFieldsAction.setFields(fields);
    }

    public FieldDefinition[] getFields() {
        return (FieldDefinition[])this.fields.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revalidateParameters() {
        if (this.ignoreTextEvents) {
            return;
        }
        this.editorModel.revalidateStructure();
        if (this.formulaContext == null) {
            this.functionParameterEditor.clearSelectedFunction();
            return;
        }
        FunctionInformation fn = this.editorModel.getCurrentFunction();
        if (fn == null) {
            this.functionParameterEditor.clearSelectedFunction();
            return;
        }
        FunctionDescription function = this.formulaContext.getFunctionRegistry().getMetaData(fn.getCanonicalName());
        if (function == null) {
            this.functionParameterEditor.clearSelectedFunction();
            return;
        }
        this.functionInformationPanel.setSelectedFunction(function);
        try {
            this.ignoreTextEvents = true;
            int paramCount = DefaultFunctionParameterEditor.computeFunctionParameterCount(function);
            String[] parameterValues = new String[paramCount];
            int definedParameterCount = Math.min(fn.getParameterCount(), paramCount);
            for (int i = 0; i < definedParameterCount; ++i) {
                String text;
                parameterValues[i] = text = fn.getParameterText(i);
            }
            if (definedParameterCount > 0 && fn.getParameterCount() > paramCount) {
                int lastParamIdx;
                StringBuilder lastParamEatsAllBuffer = new StringBuilder(100);
                for (int i = lastParamIdx = definedParameterCount - 1; i < fn.getParameterCount(); ++i) {
                    if (i > lastParamIdx) {
                        lastParamEatsAllBuffer.append(';');
                    }
                    lastParamEatsAllBuffer.append(fn.getParameterText(i));
                }
                parameterValues[lastParamIdx] = lastParamEatsAllBuffer.toString();
            }
            this.functionParameterEditor.setSelectedFunction(new FunctionParameterContext(function, parameterValues, fn));
        }
        finally {
            this.ignoreTextEvents = false;
        }
    }

    private void refreshInformationPanel() {
        FunctionInformation currentFunction = this.editorModel.getCurrentFunction();
        FunctionDescription description = currentFunction != null ? this.formulaContext.getFunctionRegistry().getMetaData(currentFunction.getCanonicalName()) : this.functionSelectorPanel.getSelectedValue();
        this.functionInformationPanel.setSelectedFunction(description);
    }

    protected void revalidateFormulaSyntax() {
        try {
            String rawFormula = this.editorModel.getFormulaText();
            if (StringUtils.isEmpty((String)rawFormula)) {
                this.errorTextHolder.setText("");
                this.errorTextHolder.setToolTipText(null);
                this.errorIconHolder.setIcon(null);
                return;
            }
            String formulaText = FormulaUtil.extractFormula((String)rawFormula);
            if (StringUtils.isEmpty((String)formulaText)) {
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortErrorNoFormulaContext"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.ErrorNoFormulaContext"));
                return;
            }
            Formula formula = new Formula(formulaText);
            formula.initialize(this.formulaContext);
            TypeValuePair pair = formula.evaluateTyped();
            if (pair.getValue() instanceof LibFormulaErrorValue) {
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortEvaluationError"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.EvaluationError"));
            } else {
                this.errorTextHolder.setToolTipText(null);
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.EvaluationResult", String.valueOf(pair.getValue())));
            }
            this.errorIconHolder.setIcon(null);
        }
        catch (ParseException pe) {
            this.errorIconHolder.setIcon(this.errorIcon);
            if (pe.currentToken == null) {
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortParseError"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.GenericParseError", pe.getLocalizedMessage()));
            } else {
                String token = pe.currentToken.toString();
                int line = pe.currentToken.beginLine;
                int column = pe.currentToken.beginColumn;
                this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortParseError"));
                this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.ParseError", new Object[]{token, line, column}));
            }
        }
        catch (Exception e) {
            this.errorIconHolder.setIcon(this.errorIcon);
            this.errorTextHolder.setText(Messages.getInstance().getString("FormulaEditorDialog.ShortParseError"));
            this.errorTextHolder.setToolTipText(Messages.getInstance().getString("FormulaEditorDialog.GenericParseError", e.getLocalizedMessage()));
        }
    }

    private class InsertOperatorAction
    extends AbstractAction {
        private String symbol;
        private static final int IMAGE_SIZE = 16;

        private InsertOperatorAction(String symbol, String description) {
            this.symbol = symbol;
            this.putValue("SmallIcon", this.createImage(symbol));
            this.putValue("ShortDescription", description);
        }

        public void actionPerformed(ActionEvent e) {
            FormulaEditorDialog.this.insertText(this.symbol);
        }

        private ImageIcon createImage(String symbol) {
            BufferedImage bi = new BufferedImage(16, 16, 2);
            Graphics graphics = bi.getGraphics();
            Rectangle2D stringBounds = graphics.getFontMetrics().getStringBounds(symbol, graphics);
            int xspace = (int)Math.max(16.0 - stringBounds.getWidth(), 0.0);
            int yspace = (int)Math.max(16.0 - stringBounds.getHeight(), 0.0);
            graphics.setColor(Color.BLACK);
            double y2 = stringBounds.getY();
            int y1 = (int)((double)(yspace / 2) - y2);
            graphics.drawString(symbol, xspace / 2, y1);
            graphics.dispose();
            return new ImageIcon(bi);
        }
    }

    private class FieldSelectorListener
    implements PropertyChangeListener {
        private FieldSelectorListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FieldDefinition value = (FieldDefinition)evt.getNewValue();
            String text = FormulaUtil.quoteReference((String)value.getName());
            FormulaEditorDialog.this.insertText(text);
        }
    }

    private class ParameterUpdateHandler
    implements ParameterUpdateListener {
        private ParameterUpdateHandler() {
        }

        public void parameterUpdated(ParameterUpdateEvent event) {
            int end;
            int start;
            int parameterIndex = event.getParameter();
            String text = event.getText();
            boolean catchAllParameter = event.isCatchAllParameter();
            if (FormulaEditorDialog.this.ignoreTextEvents) {
                return;
            }
            FunctionInformation fn = FormulaEditorDialog.this.editorModel.getCurrentFunction();
            if (fn == null) {
                return;
            }
            if (fn.getParameterCount() == 0) {
                return;
            }
            if (parameterIndex == -1) {
                start = fn.getFunctionOffset();
                end = fn.getFunctionParameterEnd();
            } else if (parameterIndex >= fn.getParameterCount()) {
                text = ";" + text;
                end = start = fn.getParamEnd(fn.getParameterCount() - 1);
            } else if (catchAllParameter) {
                start = fn.getParamStart(parameterIndex);
                end = fn.getParamEnd(fn.getParameterCount() - 1);
            } else {
                start = fn.getParamStart(parameterIndex);
                end = fn.getParamEnd(parameterIndex);
            }
            StringBuilder formulaText = new StringBuilder(FormulaEditorDialog.this.editorModel.getFormulaText());
            formulaText.delete(start, end);
            formulaText.insert(start, text);
            FormulaEditorDialog.this.ignoreTextEvents = true;
            FormulaEditorDialog.this.editorModel.updateParameterText(start, end, text, parameterIndex != -1);
            FormulaEditorDialog.this.functionTextArea.setText(formulaText.toString());
            FormulaEditorDialog.this.functionTextArea.setCaretPosition(text.length() + start);
            FormulaEditorDialog.this.editorModel.setCarretPosition(FormulaEditorDialog.this.functionTextArea.getCaretPosition());
            FormulaEditorDialog.this.ignoreTextEvents = false;
            FormulaEditorDialog.this.revalidateParameters();
            FormulaEditorDialog.this.revalidateFormulaSyntax();
        }
    }

    private class DocumentSyncHandler
    implements DocumentListener,
    Runnable {
        private DocumentSyncHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            if (FormulaEditorDialog.this.ignoreTextEvents) {
                return;
            }
            FormulaEditorDialog.this.ignoreTextEvents = true;
            SwingUtilities.invokeLater(this);
        }

        public void removeUpdate(DocumentEvent e) {
            if (FormulaEditorDialog.this.ignoreTextEvents) {
                return;
            }
            FormulaEditorDialog.this.ignoreTextEvents = true;
            SwingUtilities.invokeLater(this);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void run() {
            FormulaEditorDialog.this.editorModel.setFormulaText(FormulaEditorDialog.this.functionTextArea.getText());
            FormulaEditorDialog.this.editorModel.setCarretPosition(FormulaEditorDialog.this.functionTextArea.getCaretPosition());
            FormulaEditorDialog.this.ignoreTextEvents = false;
            FormulaEditorDialog.this.revalidateParameters();
            FormulaEditorDialog.this.revalidateFormulaSyntax();
        }
    }

    private class FunctionDescriptionUpdateHandler
    implements PropertyChangeListener,
    ActionListener {
        private FunctionDescriptionUpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FormulaEditorDialog.this.refreshInformationPanel();
        }

        public void actionPerformed(ActionEvent e) {
            FunctionDescription selectedFunction = FormulaEditorDialog.this.functionSelectorPanel.getSelectedValue();
            StringBuilder b = new StringBuilder(100);
            b.append(selectedFunction.getCanonicalName());
            b.append('(');
            int count = selectedFunction.isInfiniteParameterCount() ? Math.min(1, selectedFunction.getParameterCount()) : selectedFunction.getParameterCount();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    b.append("; ");
                }
                Type type = selectedFunction.getParameterType(i);
                b.append(TypeUtil.getParameterType((Type)type, (Locale)FormulaEditorDialog.this.getLocale()));
            }
            b.append(')');
            try {
                Document document = FormulaEditorDialog.this.functionTextArea.getDocument();
                int selectionStart = FormulaEditorDialog.this.functionTextArea.getSelectionStart();
                document.remove(selectionStart, FormulaEditorDialog.this.functionTextArea.getSelectionEnd() - selectionStart);
                document.insertString(FormulaEditorDialog.this.functionTextArea.getCaretPosition(), b.toString(), null);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        public void caretUpdate(CaretEvent e) {
            if (FormulaEditorDialog.this.ignoreTextEvents) {
                return;
            }
            FormulaEditorDialog.this.editorModel.setCarretPosition(FormulaEditorDialog.this.functionTextArea.getCaretPosition());
            FormulaEditorDialog.this.refreshInformationPanel();
            FormulaEditorDialog.this.revalidateParameters();
        }
    }
}

