/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui;

import java.util.Arrays;
import org.pentaho.openformula.ui.model2.FunctionInformation;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;

public class FunctionParameterContext {
    private FunctionDescription function;
    private String[] parameterValues;
    private FunctionInformation functionInformation;

    public FunctionParameterContext() {
    }

    public FunctionParameterContext(FunctionDescription function, String[] parameterValues, FunctionInformation fn) {
        this.function = function;
        this.parameterValues = parameterValues;
        this.functionInformation = fn;
    }

    public FunctionInformation getFunctionInformation() {
        return this.functionInformation;
    }

    public FunctionDescription getFunction() {
        return this.function;
    }

    public int getFunctionParameterStartPosition() {
        if (this.functionInformation == null) {
            return -1;
        }
        return this.functionInformation.getFunctionParameterStart();
    }

    public String[] getParameterValues() {
        return this.parameterValues;
    }

    public static boolean isSameFunctionDescription(FunctionDescription d1, FunctionDescription d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.getClass().equals(d2.getClass());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FunctionParameterContext");
        sb.append("{function=").append(this.function);
        sb.append(", parameterValues=").append(this.parameterValues == null ? "null" : Arrays.asList(this.parameterValues).toString());
        sb.append(", functionInformation=").append(this.functionInformation);
        sb.append('}');
        return sb.toString();
    }
}

