/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.model2;

import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.pentaho.openformula.ui.model2.FormulaClosingParenthesisElement;
import org.pentaho.openformula.ui.model2.FormulaDocumentPosition;
import org.pentaho.openformula.ui.model2.FormulaElement;
import org.pentaho.openformula.ui.model2.FormulaFunctionElement;
import org.pentaho.openformula.ui.model2.FormulaOpenParenthesisElement;
import org.pentaho.openformula.ui.model2.FormulaParser;
import org.pentaho.openformula.ui.model2.FormulaRootElement;
import org.pentaho.openformula.ui.model2.FormulaSemicolonElement;
import org.pentaho.openformula.ui.model2.FormulaTextElement;
import org.pentaho.openformula.ui.model2.FunctionInformation;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class FormulaDocument
implements Document {
    private FormulaRootElement rootElement = new FormulaRootElement(this);
    private EventListenerList listenerList;
    private HashMap properties = new HashMap();
    private boolean needRevalidateStructure;

    public FormulaDocument() {
        this.listenerList = new EventListenerList();
    }

    public int getLength() {
        return this.rootElement.getEndOffset();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.listenerList.add(DocumentListener.class, listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.listenerList.remove(DocumentListener.class, listener);
    }

    protected void fireInsertEvent(DocumentEvent event) {
        DocumentListener[] listeners = (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            DocumentListener documentListener = listeners[i];
            documentListener.insertUpdate(event);
        }
    }

    protected void fireRemoveEvent(DocumentEvent event) {
        DocumentListener[] listeners = (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            DocumentListener documentListener = listeners[i];
            documentListener.removeUpdate(event);
        }
    }

    protected void fireChangeEvent(DocumentEvent event) {
        DocumentListener[] listeners = (DocumentListener[])this.listenerList.getListeners(DocumentListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            DocumentListener documentListener = listeners[i];
            documentListener.changedUpdate(event);
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.add(UndoableEditListener.class, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.listenerList.remove(UndoableEditListener.class, listener);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public void putProperty(Object key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public Position getStartPosition() {
        try {
            return new FormulaDocumentPosition(this.rootElement, 0, true);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("Should never happen");
        }
    }

    public Position getEndPosition() {
        try {
            return new FormulaDocumentPosition(this.rootElement, 0, false);
        }
        catch (BadLocationException e) {
            throw new IllegalStateException("Should never happen");
        }
    }

    public Position createPosition(int offs) throws BadLocationException {
        int elementIndex = this.rootElement.getElementIndex(offs);
        FormulaElement element = (FormulaElement)this.rootElement.getElement(elementIndex);
        return new FormulaDocumentPosition(element, offs - element.getStartOffset(), true);
    }

    public Element[] getRootElements() {
        return new Element[]{this.rootElement};
    }

    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    public FormulaRootElement getRootElement() {
        return this.rootElement;
    }

    public synchronized void render(Runnable r) {
        r.run();
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (len == 0) {
            return;
        }
        int endPos = offs + len;
        if (endPos > this.getLength()) {
            throw new BadLocationException("Document Size invalid", endPos);
        }
        String orgText = this.getText(0, this.getLength());
        StringBuilder str = new StringBuilder(orgText);
        str.delete(offs, offs + len);
        this.rootElement.clear();
        FormulaElement[] formulaElements = FormulaParser.parseText(this, str.toString());
        for (int i = 0; i < formulaElements.length; ++i) {
            FormulaElement element = formulaElements[i];
            this.rootElement.insertElement(i, element);
        }
        this.rootElement.revalidateStructure();
        this.fireRemoveEvent(new FormulaDocumentEvent(this, DocumentEvent.EventType.REMOVE, offs, len));
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        String orgText = this.getText(0, this.getLength());
        StringBuilder str2 = new StringBuilder(orgText);
        str2.insert(offset, str);
        this.rootElement.clear();
        FormulaElement[] formulaElements = FormulaParser.parseText(this, str2.toString());
        for (int i = 0; i < formulaElements.length; ++i) {
            FormulaElement element = formulaElements[i];
            this.rootElement.insertElement(i, element);
        }
        this.rootElement.revalidateStructure();
        this.fireInsertEvent(new FormulaDocumentEvent(this, DocumentEvent.EventType.INSERT, offset, str.length()));
    }

    public String getText(int offset, int length) throws BadLocationException {
        if (offset + length > this.getLength()) {
            throw new BadLocationException("Document Size invalid", offset + length);
        }
        if (this.rootElement.getElementCount() == 0) {
            return "";
        }
        String s = this.rootElement.getText();
        return s.substring(offset, offset + length);
    }

    public String getText() {
        return this.rootElement.getText();
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        String text = this.getText(offset, length);
        txt.array = text.toCharArray();
        txt.offset = 0;
        txt.count = text.length();
    }

    public FunctionInformation getFunctionForPosition(int offset) {
        FormulaFunctionElement fn = this.getFunction(offset);
        if (fn == null) {
            return null;
        }
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Integer> paramsStart = new ArrayList<Integer>();
        ArrayList<Integer> paramsEnd = new ArrayList<Integer>();
        int parenCount = 0;
        int paramStart = 0;
        int paramEnd = 0;
        int globalStart = -1;
        int globalEnd = -1;
        int count = this.rootElement.getElementCount();
        boolean found = false;
        StringBuilder b = new StringBuilder(this.rootElement.getEndOffset() - fn.getStartOffset());
        for (int i = 0; i < count; ++i) {
            FormulaElement node = (FormulaElement)this.rootElement.getElement(i);
            if (!found) {
                if (node != fn) continue;
                found = true;
                continue;
            }
            if (node instanceof FormulaOpenParenthesisElement) {
                if (parenCount > 0) {
                    b.append('(');
                } else {
                    globalStart = node.getEndOffset();
                    paramStart = node.getEndOffset();
                }
                ++parenCount;
                continue;
            }
            if (node instanceof FormulaClosingParenthesisElement) {
                if (--parenCount > 0) {
                    b.append(')');
                    continue;
                }
                paramEnd = node.getStartOffset();
                globalEnd = node.getEndOffset();
                break;
            }
            if (node instanceof FormulaSemicolonElement) {
                if (parenCount == 1) {
                    paramEnd = node.getStartOffset();
                    params.add(b.toString());
                    if (paramEnd < paramStart) {
                        throw new IllegalStateException();
                    }
                    paramsStart.add(paramStart);
                    paramsEnd.add(paramEnd);
                    b.delete(0, b.length());
                    paramStart = node.getEndOffset();
                    continue;
                }
                b.append(';');
                continue;
            }
            b.append(node.getText());
        }
        if (paramEnd < paramStart) {
            paramEnd = this.rootElement.getEndOffset();
            globalEnd = this.rootElement.getEndOffset();
        }
        if (globalEnd < offset) {
            return null;
        }
        paramsStart.add(paramStart);
        paramsEnd.add(paramEnd);
        int[] starts = new int[paramsStart.size()];
        int[] ends = new int[paramsEnd.size()];
        for (int i = 0; i < ends.length; ++i) {
            Integer endVal = (Integer)paramsEnd.get(i);
            ends[i] = endVal;
            Integer startVal = (Integer)paramsStart.get(i);
            starts[i] = startVal;
        }
        params.add(b.toString());
        String functionImage = null;
        try {
            functionImage = this.getText(fn.getStartOffset(), globalEnd - fn.getStartOffset());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return new FunctionInformation(fn.getNormalizedFunctionName(), fn.getStartOffset(), globalStart, globalEnd, functionImage, params.toArray(new String[params.size()]), starts, ends);
    }

    private FormulaFunctionElement getFunction(int offset) {
        FormulaFunctionElement function = null;
        FastStack functionsStack = new FastStack();
        int count = this.rootElement.getElementCount();
        boolean haveCloseParentheses = false;
        for (int i = 0; i < count; ++i) {
            FormulaElement node = (FormulaElement)this.rootElement.getElement(i);
            if (node.getStartOffset() > offset) {
                if (function == null) {
                    return null;
                }
                return function;
            }
            if (haveCloseParentheses) {
                if (!functionsStack.isEmpty()) {
                    functionsStack.pop();
                }
                function = functionsStack.isEmpty() ? null : (FormulaFunctionElement)functionsStack.peek();
                haveCloseParentheses = false;
            }
            if (node instanceof FormulaFunctionElement) {
                function = (FormulaFunctionElement)node;
            }
            if (node instanceof FormulaOpenParenthesisElement) {
                functionsStack.push((Object)function);
            }
            if (!(node instanceof FormulaClosingParenthesisElement)) continue;
            haveCloseParentheses = true;
        }
        if (!functionsStack.isEmpty()) {
            return (FormulaFunctionElement)functionsStack.peek();
        }
        return function;
    }

    public void setText(String text) {
        this.rootElement.clear();
        FormulaElement[] formulaElements = FormulaParser.parseText(this, text);
        for (int i = 0; i < formulaElements.length; ++i) {
            FormulaElement element = formulaElements[i];
            this.rootElement.insertElement(i, element);
        }
        this.rootElement.revalidateStructure();
        this.needRevalidateStructure = false;
        this.fireInsertEvent(new FormulaDocumentEvent(this, DocumentEvent.EventType.INSERT, 0, text.length()));
    }

    public void updateParameterText(int start, int end, String newText, boolean hasDummyParams) {
        int startIndex = start == 0 ? this.rootElement.getElementIndex(start) : this.rootElement.getElementIndex(start - 1);
        int endIndex = this.rootElement.getElementIndex(end);
        FormulaElement startElement = (FormulaElement)this.rootElement.getElement(startIndex);
        FormulaElement endElement = (FormulaElement)this.rootElement.getElement(endIndex);
        if (startElement instanceof FormulaOpenParenthesisElement && endElement instanceof FormulaClosingParenthesisElement) {
            this.rootElement.insert(endElement, new FormulaTextElement(this, this.rootElement, newText));
        } else {
            this.rootElement.replace(startElement, new FormulaTextElement(this, this.rootElement, newText), hasDummyParams);
        }
        if (!hasDummyParams) {
            for (int i = startIndex + 1; i <= endIndex; ++i) {
                this.rootElement.removeElement(startIndex + 1);
            }
        }
        this.rootElement.revalidateNodePositions();
        this.needRevalidateStructure = true;
    }

    public void revalidateStructure() {
        if (this.needRevalidateStructure) {
            this.setText(this.getText());
        }
    }

    private static class FormulaDocumentEvent
    implements DocumentEvent {
        private Document document;
        private DocumentEvent.EventType type;
        private int offset;
        private int length;
        private HashMap<Element, DocumentEvent.ElementChange> changes;

        private FormulaDocumentEvent(Document document, DocumentEvent.EventType type, int offset, int length) {
            this.document = document;
            this.type = type;
            this.offset = offset;
            this.length = length;
        }

        public void addChange(Element element, DocumentEvent.ElementChange change) {
            if (this.changes == null) {
                this.changes = new HashMap();
            }
            this.changes.put(element, change);
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public Document getDocument() {
            return this.document;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            if (this.changes == null) {
                return null;
            }
            return this.changes.get(elem);
        }
    }
}

