/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.model2;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.pentaho.openformula.ui.model2.FormulaElement;

public class FormulaDocumentPosition
implements Position {
    private FormulaElement node;
    private boolean fromStart;
    private int offset;

    public FormulaDocumentPosition(FormulaElement node, int offset, boolean fromStart) throws BadLocationException {
        if (node == null) {
            throw new NullPointerException();
        }
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (offset < 0 || offset > node.getEndOffset()) {
            throw new BadLocationException("Offset not valid", offset);
        }
        this.node = node;
        this.fromStart = fromStart;
        this.offset = offset;
    }

    public int getOffset() {
        if (this.fromStart) {
            return this.node.getStartOffset() + this.offset;
        }
        return this.node.getEndOffset() - this.offset;
    }
}

