/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.model2;

import java.util.ArrayList;
import javax.swing.text.Element;
import org.pentaho.openformula.ui.model2.FormulaDocument;
import org.pentaho.openformula.ui.model2.FormulaElement;
import org.pentaho.openformula.ui.model2.FormulaParser;
import org.pentaho.openformula.ui.model2.FormulaTextElement;

public class FormulaRootElement
extends FormulaElement {
    private ArrayList<FormulaElement> elements = new ArrayList();

    public FormulaRootElement(FormulaDocument document) {
        super(document, null);
        this.elements.add(new FormulaTextElement(document, this, ""));
    }

    protected String getText() {
        StringBuilder b = new StringBuilder(this.getEndOffset());
        for (int i = 0; i < this.elements.size(); ++i) {
            FormulaElement element = this.elements.get(i);
            b.append(element.getText());
        }
        return b.toString();
    }

    public int getElementIndex(int offset) {
        for (int i = 0; i < this.elements.size(); ++i) {
            FormulaElement node = this.elements.get(i);
            if (offset < node.getStartOffset() || offset >= node.getEndOffset() && node.getStartOffset() != node.getEndOffset()) continue;
            return i;
        }
        return this.elements.size() - 1;
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public Element getElement(int index) {
        return this.elements.get(index);
    }

    public boolean isLeaf() {
        return false;
    }

    public String getName() {
        return "<root>";
    }

    public void setElements(FormulaElement[] elements) {
        this.elements.clear();
        for (int i = 0; i < elements.length; ++i) {
            FormulaElement element = elements[i];
            if (element.getParentElement() != this) {
                throw new IllegalArgumentException();
            }
            this.elements.add(element);
        }
        if (this.elements.isEmpty()) {
            this.elements.add(new FormulaTextElement((FormulaDocument)this.getDocument(), this, ""));
        }
        this.revalidateNodePositions();
    }

    public void setElement(int index, FormulaElement element) {
        if (element.getParentElement() != this) {
            throw new IllegalArgumentException();
        }
        this.elements.set(index, element);
    }

    public void insertElement(int index, FormulaElement element) {
        if (element.getParentElement() != this) {
            throw new IllegalArgumentException();
        }
        this.elements.add(index, element);
    }

    public void removeElement(int index) {
        this.elements.remove(index);
        if (this.elements.isEmpty()) {
            this.elements.add(new FormulaTextElement((FormulaDocument)this.getDocument(), this, ""));
        }
    }

    public void revalidateStructure() {
        FormulaElement[] formulaElements = this.elements.toArray(new FormulaElement[this.elements.size()]);
        FormulaElement[] normalized = FormulaParser.normalizeDocument((FormulaDocument)this.getDocument(), formulaElements);
        this.setElements(normalized);
    }

    public void revalidateNodePositions() {
        this.setStartOffset(0);
        int cursor = 0;
        int count = this.getElementCount();
        for (int i = 0; i < count; ++i) {
            FormulaElement node = (FormulaElement)this.getElement(i);
            node.setStartOffset(cursor);
            node.setEndOffset(cursor += node.getText().length());
        }
        this.setEndOffset(cursor);
    }

    public void print() {
        FormulaElement[] formulaElements = this.elements.toArray(new FormulaElement[this.elements.size()]);
        for (int i = 0; i < formulaElements.length; ++i) {
            FormulaElement element = formulaElements[i];
            System.out.println(i + " Name=" + element.getName() + "; Text='" + element.getText() + '\'');
        }
    }

    public void clear() {
        this.elements.clear();
    }

    public void replace(FormulaElement oldElement, FormulaTextElement formulaTextElement, boolean hasDummyParams) {
        FormulaTextElement replacementElement;
        int idx = this.elements.indexOf(oldElement);
        if (idx == -1) {
            throw new IllegalStateException();
        }
        Element origElement = this.getElement(idx);
        if (hasDummyParams && origElement instanceof FormulaTextElement) {
            String updatedText = ((FormulaTextElement)origElement).getText();
            replacementElement = new FormulaTextElement((FormulaDocument)formulaTextElement.getDocument(), (FormulaRootElement)origElement.getParentElement(), updatedText + formulaTextElement.getText());
        } else {
            replacementElement = formulaTextElement;
        }
        this.setElement(idx, replacementElement);
    }

    public void insert(FormulaElement oldElement, FormulaTextElement formulaTextElement) {
        int idx = this.elements.indexOf(oldElement);
        if (idx == -1) {
            throw new IllegalStateException();
        }
        this.insertElement(idx, formulaTextElement);
    }
}

