/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.pentaho.openformula.ui.FieldDefinition;
import org.pentaho.openformula.ui.Messages;
import org.pentaho.openformula.ui.util.FieldDefinitionCellRenderer;
import org.pentaho.openformula.ui.util.FieldListModel;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class FieldSelectorDialog
extends CommonDialog {
    public static final String SELECTED_DEFINITION_PROPERTY = "selectedDefinition";
    private JList fieldList;
    private FieldDefinition selectedDefinition;

    public FieldSelectorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public FieldSelectorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public FieldSelectorDialog() throws HeadlessException {
        this.init();
    }

    protected void init() {
        this.setDefaultCloseOperation(2);
        this.fieldList = new JList(new FieldListModel());
        this.fieldList.setSelectionMode(0);
        this.fieldList.setCellRenderer(new FieldDefinitionCellRenderer());
        this.fieldList.addMouseListener(new MouseHandler());
        this.setTitle(Messages.getInstance().getString("FieldSelectorDialog.Title"));
        super.init();
        this.pack();
        LibSwingUtil.centerDialogInParent((Dialog)((Object)this));
    }

    protected Component createContentPane() {
        return new JScrollPane(this.fieldList);
    }

    public void setFields(FieldDefinition[] fields) {
        this.fieldList.setModel(new FieldListModel(fields));
    }

    public FieldDefinition getSelectedDefinition() {
        return this.selectedDefinition;
    }

    public void setSelectedDefinition(FieldDefinition definition) {
        FieldDefinition old = this.selectedDefinition;
        this.selectedDefinition = definition;
        this.firePropertyChange(SELECTED_DEFINITION_PROPERTY, old, definition);
    }

    public FieldDefinition performEdit(FieldDefinition[] fields, FieldDefinition selectedDefinition) {
        this.setFields(fields);
        this.fieldList.setSelectedValue(selectedDefinition, true);
        this.selectedDefinition = selectedDefinition;
        if (this.performEdit()) {
            return this.getSelectedDefinition();
        }
        return null;
    }

    protected boolean validateInputs(boolean onConfirm) {
        if (onConfirm) {
            this.setSelectedDefinition((FieldDefinition)this.fieldList.getSelectedValue());
        }
        return this.selectedDefinition != null;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                FieldSelectorDialog.this.setSelectedDefinition((FieldDefinition)FieldSelectorDialog.this.fieldList.getSelectedValue());
                FieldSelectorDialog.this.getConfirmAction().actionPerformed(new ActionEvent(this, 1001, null));
                FieldSelectorDialog.this.dispose();
            }
        }
    }
}

