/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.lib.LargeObjectLoader;
import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.AutoProgressMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.sqoop.mapreduce.AvroJob;

public class AvroImportMapper
extends AutoProgressMapper<LongWritable, SqoopRecord, AvroWrapper<GenericRecord>, NullWritable> {
    private final AvroWrapper<GenericRecord> wrapper = new AvroWrapper();
    private Schema schema;
    private LargeObjectLoader lobLoader;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.schema = AvroJob.getMapOutputSchema(context.getConfiguration());
        this.lobLoader = new LargeObjectLoader(context.getConfiguration(), FileOutputFormat.getWorkOutputPath((TaskInputOutputContext)context));
    }

    protected void map(LongWritable key, SqoopRecord val, Mapper.Context context) throws IOException, InterruptedException {
        try {
            val.loadLargeObjects(this.lobLoader);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE);
        }
        this.wrapper.datum((Object)this.toGenericRecord(val));
        context.write(this.wrapper, (Object)NullWritable.get());
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        if (null != this.lobLoader) {
            this.lobLoader.close();
        }
    }

    private GenericRecord toGenericRecord(SqoopRecord val) {
        Map<String, Object> fieldMap = val.getFieldMap();
        GenericData.Record record = new GenericData.Record(this.schema);
        for (Map.Entry<String, Object> entry : fieldMap.entrySet()) {
            record.put(entry.getKey(), this.toAvro(entry.getValue()));
        }
        return record;
    }

    private Object toAvro(Object o) {
        if (o instanceof BigDecimal) {
            return o.toString();
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof Time) {
            return ((Time)o).getTime();
        }
        if (o instanceof Timestamp) {
            return ((Timestamp)o).getTime();
        }
        if (o instanceof BytesWritable) {
            BytesWritable bw = (BytesWritable)o;
            return ByteBuffer.wrap(bw.getBytes(), 0, bw.getLength());
        }
        if (o instanceof BlobRef) {
            BlobRef br = (BlobRef)o;
            return br.isExternal() ? br.toString().getBytes() : (byte[])br.getData();
        }
        if (o instanceof ClobRef) {
            throw new UnsupportedOperationException("ClobRef not suported");
        }
        return o;
    }
}

