/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.io.CodecMap;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.JobBase;
import com.cloudera.sqoop.orm.TableClassName;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.sqoop.util.PerfCounters;

public class ImportJobBase
extends JobBase {
    private ImportJobContext context;
    public static final Log LOG = LogFactory.getLog((String)ImportJobBase.class.getName());

    public ImportJobBase() {
        this(null);
    }

    public ImportJobBase(SqoopOptions opts) {
        this(opts, null, null, null, null);
    }

    public ImportJobBase(SqoopOptions opts, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass, ImportJobContext context) {
        super(opts, mapperClass, inputFormatClass, outputFormatClass);
        this.context = context;
    }

    @Override
    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setOutputFormatClass(this.getOutputFormatClass());
        if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
            job.getConfiguration().set("mapred.output.value.class", tableClassName);
        }
        if (this.options.shouldUseCompression()) {
            Class codecClass;
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            String codecName = this.options.getCompressionCodec();
            if (codecName == null) {
                codecClass = GzipCodec.class;
            } else {
                Configuration conf = job.getConfiguration();
                codecClass = CodecMap.getCodec(codecName, conf).getClass();
            }
            FileOutputFormat.setOutputCompressorClass((Job)job, codecClass);
            if (this.options.getFileLayout() == SqoopOptions.FileLayout.SequenceFile) {
                SequenceFileOutputFormat.setOutputCompressionType((Job)job, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK);
            }
            if (this.options.getFileLayout() == SqoopOptions.FileLayout.AvroDataFile) {
                if (codecName != null) {
                    String shortName = CodecMap.getCodecShortNameByName(codecName, job.getConfiguration());
                    if (shortName.equalsIgnoreCase("default")) {
                        shortName = "deflate";
                    }
                    job.getConfiguration().set("avro.output.codec", shortName);
                } else {
                    job.getConfiguration().set("avro.output.codec", "deflate");
                }
            }
        }
        Path outputPath = this.context.getDestination();
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
    }

    @Override
    protected boolean runJob(Job job) throws ClassNotFoundException, IOException, InterruptedException {
        PerfCounters perfCounters = new PerfCounters();
        perfCounters.startClock();
        boolean success = job.waitForCompletion(true);
        perfCounters.stopClock();
        Counters jobCounters = job.getCounters();
        if (null == jobCounters) {
            this.displayRetiredJobNotice(LOG);
        } else {
            perfCounters.addBytes(((CounterGroup)jobCounters.getGroup("FileSystemCounters")).findCounter("HDFS_BYTES_WRITTEN").getValue());
            LOG.info((Object)("Transferred " + perfCounters.toString()));
            long numRecords = ConfigurationHelper.getNumMapOutputRecords(job);
            LOG.info((Object)("Retrieved " + numRecords + " records."));
        }
        return success;
    }

    public void runImport(String tableName, String ormJarFile, String splitByCol, Configuration conf) throws IOException, ImportException {
        if (null != tableName) {
            LOG.info((Object)("Beginning import of " + tableName));
        } else {
            LOG.info((Object)"Beginning query import.");
        }
        String tableClassName = new TableClassName(this.options).getClassForTable(tableName);
        this.loadJars(conf, ormJarFile, tableClassName);
        try {
            Job job = new Job(conf);
            job.getConfiguration().set("mapred.jar", ormJarFile);
            this.configureInputFormat(job, tableName, tableClassName, splitByCol);
            this.configureOutputFormat(job, tableName, tableClassName);
            this.configureMapper(job, tableName, tableClassName);
            this.configureNumTasks(job);
            this.cacheJars(job, this.getContext().getConnManager());
            this.jobSetup(job);
            this.setJob(job);
            boolean success = this.runJob(job);
            if (!success) {
                throw new ImportException("Import job failed!");
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            this.unloadJars();
        }
    }

    protected void jobSetup(Job job) throws IOException, ImportException {
    }

    protected ImportJobContext getContext() {
        return this.context;
    }
}

