/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.lib.DelimiterSet;
import com.cloudera.sqoop.lib.FieldFormatter;
import com.cloudera.sqoop.lib.RecordParser;
import com.cloudera.sqoop.manager.MySQLUtils;
import com.cloudera.sqoop.util.ErrorableAsyncSink;
import com.cloudera.sqoop.util.ErrorableThread;
import com.cloudera.sqoop.util.LoggingAsyncSink;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.sqoop.util.AsyncSink;
import org.apache.sqoop.util.JdbcUrl;
import org.apache.sqoop.util.PerfCounters;

public class MySQLDumpMapper
extends Mapper<String, NullWritable, String, NullWritable> {
    public static final Log LOG = LogFactory.getLog((String)MySQLDumpMapper.class.getName());
    private Configuration conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void map(String splitConditions, NullWritable val, Mapper.Context context) throws IOException, InterruptedException {
        LOG.info((Object)"Beginning mysqldump fast path import");
        ArrayList<String> args = new ArrayList<String>();
        String tableName = this.conf.get(MySQLUtils.TABLE_NAME_KEY);
        String connectString = this.conf.get(MySQLUtils.CONNECT_STRING_KEY);
        String databaseName = JdbcUrl.getDatabaseName(connectString);
        String hostname = JdbcUrl.getHostName(connectString);
        int port = JdbcUrl.getPort(connectString);
        if (null == databaseName) {
            throw new IOException("Could not determine database name");
        }
        LOG.info((Object)("Performing import of table " + tableName + " from database " + databaseName));
        args.add("mysqldump");
        String password = this.conf.get(MySQLUtils.PASSWORD_KEY);
        String passwordFile = null;
        Process p = null;
        AsyncSink sink = null;
        AsyncSink errSink = null;
        PerfCounters counters = new PerfCounters();
        try {
            String[] extra;
            if (null != password && password.length() > 0) {
                passwordFile = MySQLUtils.writePasswordFile(this.conf);
                args.add("--defaults-file=" + passwordFile);
            }
            String whereClause = this.conf.get(MySQLUtils.WHERE_CLAUSE_KEY, "(1=1)") + " AND (" + splitConditions + ")";
            args.add("-w");
            args.add(whereClause);
            args.add("--host=" + hostname);
            if (-1 != port) {
                args.add("--port=" + Integer.toString(port));
            }
            args.add("--skip-opt");
            args.add("--compact");
            args.add("--no-create-db");
            args.add("--no-create-info");
            args.add("--quick");
            args.add("--single-transaction");
            String username = this.conf.get(MySQLUtils.USERNAME_KEY);
            if (null != username) {
                args.add("--user=" + username);
            }
            if (null != (extra = this.conf.getStrings("sqoop.mysql.extra.args"))) {
                for (String arg : extra) {
                    args.add(arg);
                }
            }
            args.add(databaseName);
            args.add(tableName);
            LOG.debug((Object)"Starting mysqldump with arguments:");
            for (String arg : args) {
                LOG.debug((Object)("  " + arg));
            }
            p = Runtime.getRuntime().exec(args.toArray(new String[0]));
            InputStream is = p.getInputStream();
            if (MySQLUtils.outputDelimsAreMySQL(this.conf)) {
                LOG.debug((Object)"Output delimiters conform to mysqldump; using straight copy");
                sink = new CopyingAsyncSink(context, counters);
            } else {
                LOG.debug((Object)"User-specified delimiters; using reparsing import");
                LOG.info((Object)"Converting data to use specified delimiters.");
                LOG.info((Object)"(For the fastest possible import, use");
                LOG.info((Object)"--mysql-delimiters to specify the same field");
                LOG.info((Object)"delimiters as are used by mysqldump.)");
                sink = new ReparsingAsyncSink(context, this.conf, counters);
            }
            counters.startClock();
            sink.processStream(is);
            errSink = new LoggingAsyncSink(LOG);
            errSink.processStream(p.getErrorStream());
        }
        finally {
            int result = 0;
            if (null != p) {
                while (true) {
                    try {
                        result = p.waitFor();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            if (null != passwordFile && !new File(passwordFile).delete()) {
                LOG.error((Object)("Could not remove mysql password file " + passwordFile));
                LOG.error((Object)"You should remove this file to protect your credentials.");
            }
            int streamResult = 0;
            if (null != sink) {
                while (true) {
                    try {
                        streamResult = sink.join();
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            if (null != errSink) {
                try {
                    if (0 != errSink.join()) {
                        LOG.info((Object)"Encountered exception reading stderr stream");
                    }
                }
                catch (InterruptedException ie) {
                    LOG.info((Object)("Thread interrupted waiting for stderr to complete: " + ie.toString()));
                }
            }
            LOG.info((Object)"Transfer loop complete.");
            if (0 != result) {
                throw new IOException("mysqldump terminated with status " + Integer.toString(result));
            }
            if (0 != streamResult) {
                throw new IOException("Encountered exception in stream sink");
            }
            counters.stopClock();
            LOG.info((Object)("Transferred " + counters.toString()));
        }
    }

    protected void setup(Mapper.Context context) {
        this.conf = context.getConfiguration();
    }

    public static class ReparsingAsyncSink
    extends ErrorableAsyncSink {
        private final Mapper.Context context;
        private final Configuration conf;
        private final PerfCounters counters;

        protected ReparsingAsyncSink(Mapper.Context c, Configuration conf, PerfCounters ctrs) {
            this.context = c;
            this.conf = conf;
            this.counters = ctrs;
        }

        @Override
        public void processStream(InputStream is) {
            this.child = new ReparsingStreamThread(is, this.context, this.conf, this.counters);
            this.child.start();
        }

        private static class ReparsingStreamThread
        extends ErrorableThread {
            public static final Log LOG = LogFactory.getLog((String)ReparsingStreamThread.class.getName());
            private final Mapper.Context context;
            private final Configuration conf;
            private final InputStream stream;
            private final PerfCounters counters;
            private static final char MYSQL_FIELD_DELIM = ',';
            private static final char MYSQL_RECORD_DELIM = '\n';
            private static final char MYSQL_ENCLOSE_CHAR = '\'';
            private static final char MYSQL_ESCAPE_CHAR = '\\';
            private static final boolean MYSQL_ENCLOSE_REQUIRED = false;
            private static final RecordParser MYSQLDUMP_PARSER = new RecordParser(DelimiterSet.MYSQL_DELIMITERS);

            ReparsingStreamThread(InputStream is, Mapper.Context c, Configuration conf, PerfCounters ctrs) {
                this.context = c;
                this.conf = conf;
                this.stream = is;
                this.counters = ctrs;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader r = null;
                try {
                    String inLine;
                    r = new BufferedReader(new InputStreamReader(this.stream));
                    char outputFieldDelim = (char)this.conf.getInt("sqoop.output.field.delim", 0);
                    String outputFieldDelimStr = "" + outputFieldDelim;
                    char outputRecordDelim = (char)this.conf.getInt("sqoop.output.record.delim", 0);
                    String outputRecordDelimStr = "" + outputRecordDelim;
                    char outputEnclose = (char)this.conf.getInt("sqoop.output.enclosed.by", 0);
                    char outputEscape = (char)this.conf.getInt("sqoop.output.escaped.by", 0);
                    boolean outputEncloseRequired = this.conf.getBoolean("sqoop.output.enclose.required", false);
                    DelimiterSet delimiters = new DelimiterSet(outputFieldDelim, outputRecordDelim, outputEnclose, outputEscape, outputEncloseRequired);
                    int preambleLen = -1;
                    while (null != (inLine = r.readLine())) {
                        if (inLine.trim().length() == 0 || inLine.startsWith("--")) continue;
                        if (preambleLen == -1) {
                            String recordStartMark = "VALUES (";
                            preambleLen = inLine.indexOf(recordStartMark) + recordStartMark.length();
                        }
                        CharBuffer charbuf = CharBuffer.wrap(inLine, preambleLen, inLine.length() - 2);
                        List<String> fields = null;
                        try {
                            fields = MYSQLDUMP_PARSER.parseRecord(charbuf);
                        }
                        catch (RecordParser.ParseError pe) {
                            LOG.warn((Object)("ParseError reading from mysqldump: " + pe.toString() + "; record skipped"));
                            continue;
                        }
                        boolean first = true;
                        StringBuilder sb = new StringBuilder();
                        int recordLen = 1;
                        for (String field : fields) {
                            if (!first) {
                                sb.append(outputFieldDelimStr);
                            } else {
                                first = false;
                            }
                            String fieldStr = FieldFormatter.escapeAndEnclose(field, delimiters);
                            sb.append(fieldStr);
                            recordLen += fieldStr.length();
                        }
                        sb.append(outputRecordDelimStr);
                        this.context.write((Object)sb.toString(), null);
                        this.counters.addBytes(recordLen);
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IOException reading from mysqldump: " + ioe.toString()));
                    this.setError();
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)("InterruptedException reading from mysqldump: " + ie.toString()));
                    this.setError();
                }
                finally {
                    if (null != r) {
                        try {
                            r.close();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Error closing FIFO stream: " + ioe.toString()));
                        }
                    }
                }
            }
        }
    }

    public static class CopyingAsyncSink
    extends ErrorableAsyncSink {
        private final Mapper.Context context;
        private final PerfCounters counters;

        protected CopyingAsyncSink(Mapper.Context context, PerfCounters ctrs) {
            this.context = context;
            this.counters = ctrs;
        }

        @Override
        public void processStream(InputStream is) {
            this.child = new CopyingStreamThread(is, this.context, this.counters);
            this.child.start();
        }

        private static class CopyingStreamThread
        extends ErrorableThread {
            public static final Log LOG = LogFactory.getLog((String)CopyingStreamThread.class.getName());
            private final Mapper.Context context;
            private final InputStream stream;
            private final PerfCounters counters;

            CopyingStreamThread(InputStream is, Mapper.Context c, PerfCounters ctrs) {
                this.context = c;
                this.stream = is;
                this.counters = ctrs;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader r = null;
                try {
                    String inLine;
                    r = new BufferedReader(new InputStreamReader(this.stream));
                    int preambleLen = -1;
                    while (null != (inLine = r.readLine())) {
                        if (inLine.trim().length() == 0 || inLine.startsWith("--")) continue;
                        if (preambleLen == -1) {
                            String recordStartMark = "VALUES (";
                            preambleLen = inLine.indexOf(recordStartMark) + recordStartMark.length();
                        }
                        int len = inLine.length() - 2 - preambleLen;
                        this.context.write((Object)(inLine.substring(preambleLen, inLine.length() - 2) + "\n"), null);
                        this.counters.addBytes(1 + len);
                    }
                }
                catch (IOException ioe) {
                    LOG.error((Object)("IOException reading from mysqldump: " + ioe.toString()));
                    this.setError();
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)("InterruptedException reading from mysqldump: " + ie.toString()));
                    this.setError();
                }
                finally {
                    if (null != r) {
                        try {
                            r.close();
                        }
                        catch (IOException ioe) {
                            LOG.info((Object)("Error closing FIFO stream: " + ioe.toString()));
                        }
                    }
                }
            }
        }
    }
}

