/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner;

import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.DataSetsReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.datasets.ReportFunctionsReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.BandTopLevelElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.SubReportParametersReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.model.Guideline;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report.LinealModelReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report.ReportGroupsReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertiesReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportDesignerSubReportRootHandler
extends PropertiesReadHandler {
    private SubReport report;
    private LinealModelReadHandler horizontalLinealReadHandler;
    private DataSetsReadHandler dataSetReadHandler;
    private SubReportParametersReadHandler parametersReadHandler;
    private BandTopLevelElementReadHandler watermarkHandler;
    private BandTopLevelElementReadHandler pageHeaderHandler;
    private BandTopLevelElementReadHandler pageFooterHandler;
    private BandTopLevelElementReadHandler reportHeaderHandler;
    private BandTopLevelElementReadHandler reportFooterHandler;
    private BandTopLevelElementReadHandler itemBandHandler;
    private BandTopLevelElementReadHandler noDataBandHandler;

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.FALSE);
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        SubReport report;
        super.startParsing(attrs);
        Object maybeReport = this.getRootHandler().getHelperObject("::Report");
        if (!(maybeReport instanceof SubReport)) {
            report = new SubReport();
            report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", (Object)this.getRootHandler().getSource());
        } else {
            report = (SubReport)maybeReport;
        }
        this.getRootHandler().setHelperObject("::Report", (Object)report);
        this.report = report;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("parameters".equals(tagName)) {
            this.parametersReadHandler = new SubReportParametersReadHandler();
            return this.parametersReadHandler;
        }
        if ("reportConfiguration".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("padding".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("horizontalLinealModel".equals(tagName)) {
            this.horizontalLinealReadHandler = new LinealModelReadHandler();
            return this.horizontalLinealReadHandler;
        }
        if ("pageDefinition".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("child".equals(tagName)) {
            String type = atts.getValue(uri, "type");
            if ("org.pentaho.reportdesigner.crm.report.model.dataset.DataSetsReportElement".equals(type)) {
                this.dataSetReadHandler = new DataSetsReadHandler();
                return this.dataSetReadHandler;
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ReportFunctionsElement".equals(type)) {
                return new ReportFunctionsReadHandler();
            }
            if ("org.pentaho.reportdesigner.crm.report.model.BandToplevelPageReportElement".equals(type) || "org.pentaho.reportdesigner.crm.report.model.BandToplevelReportElement".equals(type) || "org.pentaho.reportdesigner.crm.report.model.BandToplevelItemReportElement".equals(type)) {
                String bandtype = atts.getValue(uri, "bandToplevelType");
                if ("PAGE_HEADER".equals(bandtype)) {
                    this.pageHeaderHandler = new BandTopLevelElementReadHandler((Band)new PageHeader(), bandtype);
                    return this.pageHeaderHandler;
                }
                if ("PAGE_FOOTER".equals(bandtype)) {
                    this.pageFooterHandler = new BandTopLevelElementReadHandler((Band)new PageFooter(), bandtype);
                    return this.pageFooterHandler;
                }
                if ("WATERMARK".equals(bandtype)) {
                    this.watermarkHandler = new BandTopLevelElementReadHandler((Band)new Watermark(), bandtype);
                    return this.watermarkHandler;
                }
                if ("NO_DATA_BAND".equals(bandtype)) {
                    this.noDataBandHandler = new BandTopLevelElementReadHandler((Band)new NoDataBand(), bandtype);
                    return this.noDataBandHandler;
                }
                if ("ITEM_BAND".equals(bandtype)) {
                    this.itemBandHandler = new BandTopLevelElementReadHandler((Band)new ItemBand(), bandtype);
                    return this.itemBandHandler;
                }
                if ("REPORT_FOOTER".equals(bandtype)) {
                    this.reportFooterHandler = new BandTopLevelElementReadHandler((Band)new ReportFooter(), bandtype);
                    return this.reportFooterHandler;
                }
                if ("REPORT_HEADER".equals(bandtype)) {
                    this.reportHeaderHandler = new BandTopLevelElementReadHandler((Band)new ReportHeader(), bandtype);
                    return this.reportHeaderHandler;
                }
            }
            if ("org.pentaho.reportdesigner.crm.report.model.ReportGroups".equals(type)) {
                return new ReportGroupsReadHandler();
            }
            if ("org.pentaho.reportdesigner.crm.report.model.SubReportDataElement".equals(type)) {
                return new IgnoreAnyChildReadHandler();
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        Guideline[] guidelines;
        super.doneParsing();
        Properties p = this.getResult();
        String name = p.getProperty("name");
        if (name != null) {
            this.report.setName(name);
        }
        if (this.dataSetReadHandler != null) {
            this.report.setDataFactory((DataFactory)this.dataSetReadHandler.getObject());
        }
        if (this.horizontalLinealReadHandler != null && (guidelines = this.horizontalLinealReadHandler.getGuidelineValues()) != null && guidelines.length > 0) {
            StringBuilder b = new StringBuilder(100);
            for (int i = 0; i < guidelines.length; ++i) {
                Guideline guideline = guidelines[i];
                if (i != 0) {
                    b.append(' ');
                }
                b.append(guideline.externalize());
            }
            this.report.setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "HorizontalGuideLines", (Object)b.toString());
        }
        if (this.parametersReadHandler != null) {
            if (this.parametersReadHandler.isGlobalImport()) {
                this.report.addInputParameter("*", "*");
            } else {
                ParameterMapping[] importMapping = this.parametersReadHandler.getImportParameterMappings();
                for (int i = 0; i < importMapping.length; ++i) {
                    ParameterMapping mapping = importMapping[i];
                    this.report.addInputParameter(mapping.getName(), mapping.getAlias());
                }
            }
            if (this.parametersReadHandler.isGlobalExport()) {
                this.report.addExportParameter("*", "*");
            } else {
                ParameterMapping[] exportMapping = this.parametersReadHandler.getImportParameterMappings();
                for (int i = 0; i < exportMapping.length; ++i) {
                    ParameterMapping mapping = exportMapping[i];
                    this.report.addExportParameter(mapping.getName(), mapping.getAlias());
                }
            }
        }
        if (this.reportFooterHandler != null) {
            this.report.setReportFooter((ReportFooter)this.reportFooterHandler.getBand());
        }
        if (this.reportHeaderHandler != null) {
            this.report.setReportHeader((ReportHeader)this.reportHeaderHandler.getBand());
        }
        if (this.itemBandHandler != null) {
            this.report.setItemBand((ItemBand)this.itemBandHandler.getBand());
        }
        if (this.noDataBandHandler != null) {
            this.report.setNoDataBand((NoDataBand)this.noDataBandHandler.getBand());
        }
        if (this.pageFooterHandler != null) {
            this.report.setPageFooter((PageFooter)this.pageFooterHandler.getBand());
        }
        if (this.pageHeaderHandler != null) {
            this.report.setPageHeader((PageHeader)this.pageHeaderHandler.getBand());
        }
        if (this.watermarkHandler != null) {
            this.report.setWatermark((Watermark)this.watermarkHandler.getBand());
        }
        this.report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "file-format", (Object)"legacy-report-designer");
    }

    public Object getObject() throws SAXException {
        return this.report;
    }
}

