/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.BooleanConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.DateConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.DoubleConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.DoubleDimensionConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.FloatConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.IntegerConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.LocaleConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.LongConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ObjectConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.Point2DConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.Rectangle2DConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.StringConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.TimezoneConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.URLConverter;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Locator;

public class ObjectConverterFactory {
    private static ObjectConverterFactory instance;
    private HashMap converters = new HashMap();

    private ObjectConverterFactory() {
        this.converters.put(Double.class, new DoubleConverter());
        this.converters.put(Double.TYPE, new DoubleConverter());
        this.converters.put(Number.class, new DoubleConverter());
        this.converters.put(Integer.class, new IntegerConverter());
        this.converters.put(Integer.TYPE, new IntegerConverter());
        this.converters.put(Float.class, new FloatConverter());
        this.converters.put(Float.TYPE, new FloatConverter());
        this.converters.put(Boolean.class, new BooleanConverter());
        this.converters.put(Boolean.TYPE, new BooleanConverter());
        this.converters.put(String.class, new StringConverter());
        this.converters.put(Long.class, new LongConverter());
        this.converters.put(Long.TYPE, new LongConverter());
        this.converters.put(TimeZone.class, new TimezoneConverter());
        this.converters.put(Date.class, new DateConverter());
        this.converters.put(Dimension2D.class, new DoubleDimensionConverter());
        this.converters.put(Point2D.Double.class, new Point2DConverter());
        this.converters.put(Rectangle2D.Double.class, new Rectangle2DConverter());
        this.converters.put(Locale.class, new LocaleConverter());
        this.converters.put(Color.class, new ColorConverter());
        this.converters.put(URL.class, new URLConverter());
    }

    public static Object convert(Class c, String s, Locator locator) throws ParseException {
        ObjectConverter o;
        if (instance == null) {
            instance = new ObjectConverterFactory();
        }
        if ((o = (ObjectConverter)ObjectConverterFactory.instance.converters.get(c)) == null) {
            throw new ParseException("Invalid type: " + c);
        }
        return o.convertFromString(s, locator);
    }
}

