/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.awt.Font;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.FontConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.AbstractReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.report.FormulaReadHandler;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractTextElementReadHandler
extends AbstractReportElementReadHandler {
    private Element element;
    private FormulaReadHandler formulaReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && "formula".equals(tagName)) {
            this.formulaReadHandler = new FormulaReadHandler();
            return this.formulaReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        String encoding;
        String wrapTextInExcel;
        String trimTextContent;
        String reservedLiteral;
        String horizontalAlignment;
        String verticalAlignment;
        String lineHeight;
        String embedFont;
        String underline;
        String strikethough;
        String foreGround;
        Expression expression;
        super.doneParsing();
        if (this.formulaReadHandler != null && (expression = this.formulaReadHandler.getFormula()) != null) {
            this.element.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", expression);
        }
        Properties result = this.getResult();
        String fieldName = result.getProperty("fieldName");
        this.element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", (Object)fieldName);
        String nullString = result.getProperty("nullString");
        this.element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", (Object)nullString);
        String fontString = result.getProperty("font");
        if (fontString != null) {
            Font font = (Font)new FontConverter().convertFromString(fontString, this.getLocator());
            this.element.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)(font.isBold() ? Boolean.TRUE : Boolean.FALSE));
            this.element.getStyle().setStyleProperty(TextStyleKeys.ITALIC, (Object)(font.isItalic() ? Boolean.TRUE : Boolean.FALSE));
            this.element.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)font.getName());
            this.element.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)IntegerCache.getInteger((int)font.getSize()));
        }
        if ((foreGround = result.getProperty("foreground")) != null) {
            this.element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)ColorConverter.getObject(foreGround));
        }
        if ((strikethough = result.getProperty("strikethough")) != null) {
            if ("true".equals(strikethough)) {
                this.element.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, (Object)Boolean.TRUE);
            } else {
                this.element.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, (Object)Boolean.FALSE);
            }
        }
        if ((underline = result.getProperty("underline")) != null) {
            if ("true".equals(underline)) {
                this.element.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, (Object)Boolean.TRUE);
            } else {
                this.element.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, (Object)Boolean.FALSE);
            }
        }
        if ((embedFont = result.getProperty("embedFont")) != null) {
            if ("true".equals(embedFont)) {
                this.element.getStyle().setStyleProperty(TextStyleKeys.EMBEDDED_FONT, (Object)Boolean.TRUE);
            } else {
                this.element.getStyle().setStyleProperty(TextStyleKeys.EMBEDDED_FONT, (Object)Boolean.FALSE);
            }
        }
        if ((lineHeight = result.getProperty("lineHeight")) != null) {
            float f = ParserUtil.parseFloat((String)lineHeight, (String)"Failed to parse float-value", (Locator)this.getLocator());
            this.element.getStyle().setStyleProperty(TextStyleKeys.LINEHEIGHT, (Object)new Float(f));
        }
        if ((verticalAlignment = result.getProperty("verticalAlignment")) != null) {
            if ("TOP".equals(verticalAlignment)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)ElementAlignment.TOP);
            } else if ("MIDDLE".equals(verticalAlignment)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)ElementAlignment.MIDDLE);
            } else if ("BOTTOM".equals(verticalAlignment)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)ElementAlignment.BOTTOM);
            }
        }
        if ((horizontalAlignment = result.getProperty("horizontalAlignment")) != null) {
            if ("LEFT".equals(horizontalAlignment)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)ElementAlignment.LEFT);
            } else if ("CENTER".equals(horizontalAlignment)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)ElementAlignment.CENTER);
            } else if ("RIGHT".equals(horizontalAlignment)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)ElementAlignment.RIGHT);
            }
        }
        if ((reservedLiteral = result.getProperty("reservedLiteral")) != null) {
            this.element.getStyle().setStyleProperty(TextStyleKeys.RESERVED_LITERAL, (Object)reservedLiteral);
        }
        if ((trimTextContent = result.getProperty("timeTextContent")) != null) {
            this.element.getStyle().setStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT, (Object)trimTextContent);
        }
        if ((wrapTextInExcel = result.getProperty("wrapTextInExcel")) != null) {
            if ("true".equals(wrapTextInExcel)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.EXCEL_WRAP_TEXT, (Object)Boolean.TRUE);
            } else {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.EXCEL_WRAP_TEXT, (Object)Boolean.FALSE);
            }
        }
        if ((encoding = result.getProperty("encoding")) != null) {
            this.element.getStyle().setStyleProperty(TextStyleKeys.FONTENCODING, (Object)encoding);
        }
    }

    protected void setElement(Element element) {
        this.element = element;
    }

    protected Element getElement() {
        return this.element;
    }
}

