/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.awt.Color;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.types.EllipseType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.AbstractReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.StrokeStyleDefinitionReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EllipseElementReadHandler
extends AbstractReportElementReadHandler {
    private Element element = new Element();
    private StrokeStyleDefinitionReadHandler strokeStyleDefinitionReadHandler;

    public EllipseElementReadHandler() {
        this.element.setElementType((ElementType)new EllipseType());
        this.element.getStyle().setStyleProperty(ElementStyleKeys.SCALE, (Object)Boolean.TRUE);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && "borderDefinition".equals(tagName)) {
            this.strokeStyleDefinitionReadHandler = new StrokeStyleDefinitionReadHandler();
            return this.strokeStyleDefinitionReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        String drawBorder;
        String fill;
        Properties result1;
        String color;
        super.doneParsing();
        if (this.strokeStyleDefinitionReadHandler != null) {
            this.element.getStyle().setStyleProperty(ElementStyleKeys.STROKE, (Object)this.strokeStyleDefinitionReadHandler.getStroke());
            this.element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)this.strokeStyleDefinitionReadHandler.getColor());
        }
        if ((color = (result1 = this.getResult()).getProperty("color")) != null) {
            Color c = ColorConverter.getObject(color);
            this.element.getStyle().setStyleProperty(ElementStyleKeys.FILL_COLOR, (Object)c);
        }
        if ((fill = result1.getProperty("fill")) != null) {
            if ("true".equals(fill)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.FILL_SHAPE, (Object)Boolean.TRUE);
            } else {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.FILL_SHAPE, (Object)Boolean.FALSE);
            }
        }
        if ((drawBorder = result1.getProperty("drawBorder")) != null) {
            if ("true".equals(drawBorder)) {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.DRAW_SHAPE, (Object)Boolean.TRUE);
            } else {
                this.element.getStyle().setStyleProperty(ElementStyleKeys.DRAW_SHAPE, (Object)Boolean.FALSE);
            }
        }
    }

    protected Element getElement() {
        return this.element;
    }
}

