/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.types.HorizontalLineType;
import org.pentaho.reporting.engine.classic.core.filter.types.VerticalLineType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.converter.ColorConverter;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.AbstractReportElementReadHandler;
import org.pentaho.reporting.engine.classic.extensions.parsers.reportdesigner.elements.StrokeStyleDefinitionReadHandler;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LineReportElementReadHandler
extends AbstractReportElementReadHandler {
    private Element element = new Element();
    private StrokeStyleDefinitionReadHandler strokeStyleDefinitionReadHandler;

    public LineReportElementReadHandler() {
        this.element.setElementType((ElementType)new HorizontalLineType());
        this.element.getStyle().setStyleProperty(ElementStyleKeys.SCALE, (Object)Boolean.TRUE);
        this.element.getStyle().setStyleProperty(ElementStyleKeys.DRAW_SHAPE, (Object)Boolean.TRUE);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (this.isSameNamespace(uri) && "lineDefinition".equals(tagName)) {
            this.strokeStyleDefinitionReadHandler = new StrokeStyleDefinitionReadHandler();
            return this.strokeStyleDefinitionReadHandler;
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        String drawBorder;
        String lineWidth;
        Properties result1;
        String color;
        super.doneParsing();
        if (this.strokeStyleDefinitionReadHandler != null) {
            this.element.getStyle().setStyleProperty(ElementStyleKeys.STROKE, (Object)this.strokeStyleDefinitionReadHandler.getStroke());
            this.element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)this.strokeStyleDefinitionReadHandler.getColor());
        }
        if ((color = (result1 = this.getResult()).getProperty("color")) != null) {
            Color c = ColorConverter.getObject(color);
            this.element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)c);
        }
        if ((lineWidth = result1.getProperty("lineWidth")) != null) {
            float lineWidthf = ParserUtil.parseFloat((String)lineWidth, (String)"Failed to parse lineWidth", (Locator)this.getLocator());
            this.element.getStyle().setStyleProperty(ElementStyleKeys.STROKE, (Object)new BasicStroke(lineWidthf));
        }
        if ((drawBorder = result1.getProperty("direction")) != null && "VERTICAL".equals(drawBorder)) {
            this.element.setElementType((ElementType)new VerticalLineType());
        }
    }

    protected Element getElement() {
        return this.element;
    }
}

