/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.migration.HRegionInfo090x;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.JenkinsHash;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.WritableComparable;

public class HRegionInfo
extends VersionedWritable
implements WritableComparable<HRegionInfo> {
    public static final byte VERSION_PRE_092 = 0;
    public static final byte VERSION = 1;
    private static final Log LOG = LogFactory.getLog(HRegionInfo.class);
    private static final int ENC_SEPARATOR = 46;
    public static final int MD5_HEX_LENGTH = 32;
    public static final int DELIMITER = 44;
    public static final HRegionInfo ROOT_REGIONINFO = new HRegionInfo(0L, Bytes.toBytes("-ROOT-"));
    public static final HRegionInfo FIRST_META_REGIONINFO = new HRegionInfo(1L, Bytes.toBytes(".META."));
    private byte[] endKey = HConstants.EMPTY_BYTE_ARRAY;
    private boolean offLine = false;
    private long regionId = -1L;
    private transient byte[] regionName = HConstants.EMPTY_BYTE_ARRAY;
    private String regionNameStr = "";
    private boolean split = false;
    private byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
    private int hashCode = -1;
    public static final String NO_HASH = null;
    private volatile String encodedName = NO_HASH;
    private byte[] encodedNameAsBytes = null;
    private byte[] tableName = null;

    private static boolean hasEncodedName(byte[] regionName) {
        return regionName.length >= 1 && regionName[regionName.length - 1] == 46;
    }

    public static String encodeRegionName(byte[] regionName) {
        String encodedName;
        if (HRegionInfo.hasEncodedName(regionName)) {
            encodedName = Bytes.toString(regionName, regionName.length - 32 - 1, 32);
        } else {
            int hashVal = Math.abs(JenkinsHash.getInstance().hash(regionName, regionName.length, 0));
            encodedName = String.valueOf(hashVal);
        }
        return encodedName;
    }

    public static String prettyPrint(String encodedRegionName) {
        if (encodedRegionName.equals("70236052")) {
            return encodedRegionName + "/-ROOT-";
        }
        if (encodedRegionName.equals("1028785192")) {
            return encodedRegionName + "/.META.";
        }
        return encodedRegionName;
    }

    private void setHashCode() {
        int result = Arrays.hashCode(this.regionName);
        result = (int)((long)result ^ this.regionId);
        result ^= Arrays.hashCode(this.startKey);
        result ^= Arrays.hashCode(this.endKey);
        result ^= Boolean.valueOf(this.offLine).hashCode();
        this.hashCode = result ^= Arrays.hashCode(this.tableName);
    }

    private HRegionInfo(long regionId, byte[] tableName) {
        this.regionId = regionId;
        this.tableName = (byte[])tableName.clone();
        this.regionName = HRegionInfo.createRegionName(tableName, null, regionId, false);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.setHashCode();
    }

    public HRegionInfo() {
    }

    public HRegionInfo(HRegionInfo090x other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
        this.tableName = other.getTableDesc().getName();
    }

    public HRegionInfo(byte[] tableName) {
        this(tableName, null, null);
    }

    public HRegionInfo(byte[] tableName, byte[] startKey, byte[] endKey) throws IllegalArgumentException {
        this(tableName, startKey, endKey, false);
    }

    public HRegionInfo(byte[] tableName, byte[] startKey, byte[] endKey, boolean split) throws IllegalArgumentException {
        this(tableName, startKey, endKey, split, System.currentTimeMillis());
    }

    public HRegionInfo(byte[] tableName, byte[] startKey, byte[] endKey, boolean split, long regionid) throws IllegalArgumentException {
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        this.tableName = (byte[])tableName.clone();
        this.offLine = false;
        this.regionId = regionid;
        this.regionName = HRegionInfo.createRegionName(this.tableName, startKey, this.regionId, true);
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = split;
        this.endKey = endKey == null ? HConstants.EMPTY_END_ROW : (byte[])endKey.clone();
        this.startKey = startKey == null ? HConstants.EMPTY_START_ROW : (byte[])startKey.clone();
        this.tableName = (byte[])tableName.clone();
        this.setHashCode();
    }

    public HRegionInfo(HRegionInfo other) {
        this.endKey = other.getEndKey();
        this.offLine = other.isOffline();
        this.regionId = other.getRegionId();
        this.regionName = other.getRegionName();
        this.regionNameStr = Bytes.toStringBinary(this.regionName);
        this.split = other.isSplit();
        this.startKey = other.getStartKey();
        this.hashCode = other.hashCode();
        this.encodedName = other.getEncodedName();
        this.tableName = other.tableName;
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, long regionid, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Long.toString(regionid), newFormat);
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, String id, boolean newFormat) {
        return HRegionInfo.createRegionName(tableName, startKey, Bytes.toBytes(id), newFormat);
    }

    public static byte[] createRegionName(byte[] tableName, byte[] startKey, byte[] id, boolean newFormat) {
        byte[] b = new byte[tableName.length + 2 + id.length + (startKey == null ? 0 : startKey.length) + (newFormat ? 34 : 0)];
        int offset = tableName.length;
        System.arraycopy(tableName, 0, b, 0, offset);
        b[offset++] = 44;
        if (startKey != null && startKey.length > 0) {
            System.arraycopy(startKey, 0, b, offset, startKey.length);
            offset += startKey.length;
        }
        b[offset++] = 44;
        System.arraycopy(id, 0, b, offset, id.length);
        offset += id.length;
        if (newFormat) {
            String md5Hash = MD5Hash.getMD5AsHex(b, 0, offset);
            byte[] md5HashBytes = Bytes.toBytes(md5Hash);
            if (md5HashBytes.length != 32) {
                LOG.error((Object)("MD5-hash length mismatch: Expected=32; Got=" + md5HashBytes.length));
            }
            b[offset++] = 46;
            System.arraycopy(md5HashBytes, 0, b, offset, 32);
            offset += 32;
            b[offset++] = 46;
        }
        return b;
    }

    public static byte[] getTableName(byte[] regionName) {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        return tableName;
    }

    public static byte[][] parseRegionName(byte[] regionName) throws IOException {
        int offset = -1;
        for (int i = 0; i < regionName.length; ++i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] tableName = new byte[offset];
        System.arraycopy(regionName, 0, tableName, 0, offset);
        offset = -1;
        for (int i = regionName.length - 1; i > 0; --i) {
            if (regionName[i] != 44) continue;
            offset = i;
            break;
        }
        if (offset == -1) {
            throw new IOException("Invalid regionName format");
        }
        byte[] startKey = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != tableName.length + 1) {
            startKey = new byte[offset - tableName.length - 1];
            System.arraycopy(regionName, tableName.length + 1, startKey, 0, offset - tableName.length - 1);
        }
        byte[] id = new byte[regionName.length - offset - 1];
        System.arraycopy(regionName, offset + 1, id, 0, regionName.length - offset - 1);
        byte[][] elements = new byte[][]{tableName, startKey, id};
        return elements;
    }

    public long getRegionId() {
        return this.regionId;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public String getRegionNameAsString() {
        if (HRegionInfo.hasEncodedName(this.regionName)) {
            return this.regionNameStr;
        }
        return this.regionNameStr + "." + this.getEncodedName();
    }

    public synchronized String getEncodedName() {
        if (this.encodedName == NO_HASH) {
            this.encodedName = HRegionInfo.encodeRegionName(this.regionName);
        }
        return this.encodedName;
    }

    public synchronized byte[] getEncodedNameAsBytes() {
        if (this.encodedNameAsBytes == null) {
            this.encodedNameAsBytes = Bytes.toBytes(this.getEncodedName());
        }
        return this.encodedNameAsBytes;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public byte[] getTableName() {
        if (this.tableName == null || this.tableName.length == 0) {
            this.tableName = HRegionInfo.getTableName(this.getRegionName());
        }
        return this.tableName;
    }

    public String getTableNameAsString() {
        return Bytes.toString(this.tableName);
    }

    public boolean containsRange(byte[] rangeStartKey, byte[] rangeEndKey) {
        if (Bytes.compareTo(rangeStartKey, rangeEndKey) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(rangeStartKey) + " > " + Bytes.toStringBinary(rangeEndKey));
        }
        boolean firstKeyInRange = Bytes.compareTo(rangeStartKey, this.startKey) >= 0;
        boolean lastKeyInRange = Bytes.compareTo(rangeEndKey, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY);
        return firstKeyInRange && lastKeyInRange;
    }

    public boolean containsRow(byte[] row) {
        return Bytes.compareTo(row, this.startKey) >= 0 && (Bytes.compareTo(row, this.endKey) < 0 || Bytes.equals(this.endKey, HConstants.EMPTY_BYTE_ARRAY));
    }

    @Deprecated
    public HTableDescriptor getTableDesc() {
        FileSystem fs;
        Configuration c = HBaseConfiguration.create();
        try {
            fs = FileSystem.get((Configuration)c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FSTableDescriptors fstd = new FSTableDescriptors(fs, new Path(c.get("hbase.rootdir")));
        try {
            return fstd.get(this.tableName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setTableDesc(HTableDescriptor newDesc) {
        FileSystem fs;
        Configuration c = HBaseConfiguration.create();
        try {
            fs = FileSystem.get((Configuration)c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        FSTableDescriptors fstd = new FSTableDescriptors(fs, new Path(c.get("hbase.rootdir")));
        try {
            fstd.add(newDesc);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRootRegion() {
        return Bytes.equals(this.tableName, ROOT_REGIONINFO.getTableName());
    }

    public boolean isMetaTable() {
        return this.isRootRegion() || this.isMetaRegion();
    }

    public boolean isMetaRegion() {
        return Bytes.equals(this.tableName, FIRST_META_REGIONINFO.getTableName());
    }

    public boolean isSplit() {
        return this.split;
    }

    public void setSplit(boolean split) {
        this.split = split;
    }

    public boolean isOffline() {
        return this.offLine;
    }

    public void setOffline(boolean offLine) {
        this.offLine = offLine;
    }

    public boolean isSplitParent() {
        if (!this.isSplit()) {
            return false;
        }
        if (!this.isOffline()) {
            LOG.warn((Object)("Region is split but NOT offline: " + this.getRegionNameAsString()));
        }
        return true;
    }

    public String toString() {
        return "{NAME => '" + this.regionNameStr + "', STARTKEY => '" + Bytes.toStringBinary(this.startKey) + "', ENDKEY => '" + Bytes.toStringBinary(this.endKey) + "', ENCODED => " + this.getEncodedName() + "," + (this.isOffline() ? " OFFLINE => true," : "") + (this.isSplit() ? " SPLIT => true," : "") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionInfo)) {
            return false;
        }
        return this.compareTo((HRegionInfo)((Object)o)) == 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte getVersion() {
        return 1;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.endKey);
        out.writeBoolean(this.offLine);
        out.writeLong(this.regionId);
        Bytes.writeByteArray(out, this.regionName);
        out.writeBoolean(this.split);
        Bytes.writeByteArray(out, this.startKey);
        Bytes.writeByteArray(out, this.tableName);
        out.writeInt(this.hashCode);
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version == 0) {
            this.endKey = Bytes.readByteArray(in);
            this.offLine = in.readBoolean();
            this.regionId = in.readLong();
            this.regionName = Bytes.readByteArray(in);
            this.regionNameStr = Bytes.toStringBinary(this.regionName);
            this.split = in.readBoolean();
            this.startKey = Bytes.readByteArray(in);
            try {
                HTableDescriptor htd = new HTableDescriptor();
                htd.readFields(in);
                this.tableName = htd.getName();
            }
            catch (EOFException eofe) {
                throw new IOException("HTD not found in input buffer", eofe);
            }
            this.hashCode = in.readInt();
        } else if (this.getVersion() == version) {
            this.endKey = Bytes.readByteArray(in);
            this.offLine = in.readBoolean();
            this.regionId = in.readLong();
            this.regionName = Bytes.readByteArray(in);
            this.regionNameStr = Bytes.toStringBinary(this.regionName);
            this.split = in.readBoolean();
            this.startKey = Bytes.readByteArray(in);
            this.tableName = Bytes.readByteArray(in);
            this.hashCode = in.readInt();
        } else {
            throw new IOException("Non-migratable/unknown version=" + this.getVersion());
        }
    }

    public int compareTo(HRegionInfo o) {
        if (o == null) {
            return 1;
        }
        int result = Bytes.compareTo(this.tableName, o.tableName);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.startKey, o.startKey);
        if (result != 0) {
            return result;
        }
        result = Bytes.compareTo(this.endKey, o.endKey);
        if (result != 0) {
            if (this.getStartKey().length != 0 && this.getEndKey().length == 0) {
                return 1;
            }
            if (o.getStartKey().length != 0 && o.getEndKey().length == 0) {
                return -1;
            }
            return result;
        }
        if (this.regionId > o.regionId) {
            return 1;
        }
        if (this.regionId < o.regionId) {
            return -1;
        }
        if (this.offLine == o.offLine) {
            return 0;
        }
        if (this.offLine) {
            return -1;
        }
        return 1;
    }

    public KeyValue.KVComparator getComparator() {
        return this.isRootRegion() ? KeyValue.ROOT_COMPARATOR : (this.isMetaRegion() ? KeyValue.META_COMPARATOR : KeyValue.COMPARATOR);
    }
}

