/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;

public class LocalHBaseCluster {
    static final Log LOG = LogFactory.getLog(LocalHBaseCluster.class);
    private final List<JVMClusterUtil.MasterThread> masterThreads = new CopyOnWriteArrayList<JVMClusterUtil.MasterThread>();
    private final List<JVMClusterUtil.RegionServerThread> regionThreads = new CopyOnWriteArrayList<JVMClusterUtil.RegionServerThread>();
    private static final int DEFAULT_NO = 1;
    public static final String LOCAL = "local";
    public static final String LOCAL_COLON = "local:";
    private final Configuration conf;
    private final Class<? extends HMaster> masterClass;
    private final Class<? extends HRegionServer> regionServerClass;

    public LocalHBaseCluster(Configuration conf) throws IOException {
        this(conf, 1);
    }

    public LocalHBaseCluster(Configuration conf, int noRegionServers) throws IOException {
        this(conf, 1, noRegionServers, LocalHBaseCluster.getMasterImplementation(conf), LocalHBaseCluster.getRegionServerImplementation(conf));
    }

    public LocalHBaseCluster(Configuration conf, int noMasters, int noRegionServers) throws IOException {
        this(conf, noMasters, noRegionServers, LocalHBaseCluster.getMasterImplementation(conf), LocalHBaseCluster.getRegionServerImplementation(conf));
    }

    private static Class<? extends HRegionServer> getRegionServerImplementation(Configuration conf) {
        return conf.getClass("hbase.regionserver.impl", HRegionServer.class);
    }

    private static Class<? extends HMaster> getMasterImplementation(Configuration conf) {
        return conf.getClass("hbase.master.impl", HMaster.class);
    }

    public LocalHBaseCluster(Configuration conf, int noMasters, int noRegionServers, Class<? extends HMaster> masterClass, Class<? extends HRegionServer> regionServerClass) throws IOException {
        int i;
        this.conf = conf;
        conf.set("hbase.master.port", "0");
        conf.set("hbase.regionserver.port", "0");
        this.masterClass = conf.getClass("hbase.master.impl", masterClass);
        for (i = 0; i < noMasters; ++i) {
            this.addMaster(new Configuration(conf), i);
        }
        this.regionServerClass = conf.getClass("hbase.regionserver.impl", regionServerClass);
        for (i = 0; i < noRegionServers; ++i) {
            this.addRegionServer(new Configuration(conf), i);
        }
    }

    public JVMClusterUtil.RegionServerThread addRegionServer() throws IOException {
        return this.addRegionServer(new Configuration(this.conf), this.regionThreads.size());
    }

    public JVMClusterUtil.RegionServerThread addRegionServer(Configuration config, int index) throws IOException {
        JVMClusterUtil.RegionServerThread rst = JVMClusterUtil.createRegionServerThread(config, this.regionServerClass, index);
        this.regionThreads.add(rst);
        return rst;
    }

    public JVMClusterUtil.RegionServerThread addRegionServer(final Configuration config, final int index, User user) throws IOException, InterruptedException {
        return user.runAs(new PrivilegedExceptionAction<JVMClusterUtil.RegionServerThread>(){

            @Override
            public JVMClusterUtil.RegionServerThread run() throws Exception {
                return LocalHBaseCluster.this.addRegionServer(config, index);
            }
        });
    }

    public JVMClusterUtil.MasterThread addMaster() throws IOException {
        return this.addMaster(new Configuration(this.conf), this.masterThreads.size());
    }

    public JVMClusterUtil.MasterThread addMaster(Configuration c, int index) throws IOException {
        JVMClusterUtil.MasterThread mt = JVMClusterUtil.createMasterThread(c, this.masterClass, index);
        this.masterThreads.add(mt);
        return mt;
    }

    public JVMClusterUtil.MasterThread addMaster(final Configuration c, final int index, User user) throws IOException, InterruptedException {
        return user.runAs(new PrivilegedExceptionAction<JVMClusterUtil.MasterThread>(){

            @Override
            public JVMClusterUtil.MasterThread run() throws Exception {
                return LocalHBaseCluster.this.addMaster(c, index);
            }
        });
    }

    public HRegionServer getRegionServer(int serverNumber) {
        return this.regionThreads.get(serverNumber).getRegionServer();
    }

    public List<JVMClusterUtil.RegionServerThread> getRegionServers() {
        return Collections.unmodifiableList(this.regionThreads);
    }

    public List<JVMClusterUtil.RegionServerThread> getLiveRegionServers() {
        ArrayList<JVMClusterUtil.RegionServerThread> liveServers = new ArrayList<JVMClusterUtil.RegionServerThread>();
        List<JVMClusterUtil.RegionServerThread> list = this.getRegionServers();
        for (JVMClusterUtil.RegionServerThread rst : list) {
            if (rst.isAlive()) {
                liveServers.add(rst);
                continue;
            }
            LOG.info((Object)("Not alive " + rst.getName()));
        }
        return liveServers;
    }

    public String waitOnRegionServer(int serverNumber) {
        JVMClusterUtil.RegionServerThread regionServerThread = this.regionThreads.remove(serverNumber);
        while (regionServerThread.isAlive()) {
            try {
                LOG.info((Object)("Waiting on " + regionServerThread.getRegionServer().toString()));
                regionServerThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return regionServerThread.getName();
    }

    public String waitOnRegionServer(JVMClusterUtil.RegionServerThread rst) {
        while (rst.isAlive()) {
            try {
                LOG.info((Object)("Waiting on " + rst.getRegionServer().toString()));
                rst.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.regionThreads.size(); ++i) {
            if (this.regionThreads.get(i) != rst) continue;
            this.regionThreads.remove(i);
            break;
        }
        return rst.getName();
    }

    public HMaster getMaster(int serverNumber) {
        return this.masterThreads.get(serverNumber).getMaster();
    }

    public HMaster getActiveMaster() {
        for (JVMClusterUtil.MasterThread mt : this.masterThreads) {
            if (!mt.getMaster().isActiveMaster()) continue;
            return mt.getMaster();
        }
        return null;
    }

    public List<JVMClusterUtil.MasterThread> getMasters() {
        return Collections.unmodifiableList(this.masterThreads);
    }

    public List<JVMClusterUtil.MasterThread> getLiveMasters() {
        ArrayList<JVMClusterUtil.MasterThread> liveServers = new ArrayList<JVMClusterUtil.MasterThread>();
        List<JVMClusterUtil.MasterThread> list = this.getMasters();
        for (JVMClusterUtil.MasterThread mt : list) {
            if (!mt.isAlive()) continue;
            liveServers.add(mt);
        }
        return liveServers;
    }

    public String waitOnMaster(int serverNumber) {
        JVMClusterUtil.MasterThread masterThread = this.masterThreads.remove(serverNumber);
        while (masterThread.isAlive()) {
            try {
                LOG.info((Object)("Waiting on " + masterThread.getMaster().getServerName().toString()));
                masterThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return masterThread.getName();
    }

    public String waitOnMaster(JVMClusterUtil.MasterThread masterThread) {
        while (masterThread.isAlive()) {
            try {
                LOG.info((Object)("Waiting on " + masterThread.getMaster().getServerName().toString()));
                masterThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < this.masterThreads.size(); ++i) {
            if (this.masterThreads.get(i) != masterThread) continue;
            this.masterThreads.remove(i);
            break;
        }
        return masterThread.getName();
    }

    public void join() {
        if (this.regionThreads != null) {
            for (JVMClusterUtil.RegionServerThread regionServerThread : this.regionThreads) {
                if (!regionServerThread.isAlive()) continue;
                try {
                    Threads.threadDumpingIsAlive(regionServerThread);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Interrupted", (Throwable)e);
                }
            }
        }
        if (this.masterThreads != null) {
            for (JVMClusterUtil.MasterThread masterThread : this.masterThreads) {
                if (!masterThread.isAlive()) continue;
                try {
                    Threads.threadDumpingIsAlive(masterThread);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)"Interrupted", (Throwable)e);
                }
            }
        }
    }

    public void startup() throws IOException {
        JVMClusterUtil.startup(this.masterThreads, this.regionThreads);
    }

    public void shutdown() {
        JVMClusterUtil.shutdown(this.masterThreads, this.regionThreads);
    }

    public static boolean isLocal(Configuration c) {
        boolean mode = c.getBoolean("hbase.cluster.distributed", false);
        return !mode;
    }

    public static void main(String[] args) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        LocalHBaseCluster cluster = new LocalHBaseCluster(conf);
        cluster.startup();
        HBaseAdmin admin = new HBaseAdmin(conf);
        HTableDescriptor htd = new HTableDescriptor(Bytes.toBytes(cluster.getClass().getName()));
        admin.createTable(htd);
        cluster.shutdown();
    }
}

