/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerTimeoutException;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHRegionInfo;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.ExecRPCInvoker;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Writables;

public class HTable
implements HTableInterface,
Closeable {
    private static final Log LOG = LogFactory.getLog(HTable.class);
    private HConnection connection;
    private final byte[] tableName;
    protected int scannerTimeout;
    private volatile Configuration configuration;
    private final ArrayList<Put> writeBuffer = new ArrayList();
    private long writeBufferSize;
    private boolean clearBufferOnFail;
    private boolean autoFlush;
    private long currentWriteBufferSize;
    protected int scannerCaching;
    private int maxKeyValueSize;
    private ExecutorService pool;
    private long maxScannerResultSize;
    private boolean closed;
    private int operationTimeout;
    private static final int DOPUT_WB_CHECK = 10;
    private final boolean cleanupOnClose;

    public HTable(String tableName) throws IOException {
        this(HBaseConfiguration.create(), Bytes.toBytes(tableName));
    }

    public HTable(byte[] tableName) throws IOException {
        this(HBaseConfiguration.create(), tableName);
    }

    public HTable(Configuration conf, String tableName) throws IOException {
        this(conf, Bytes.toBytes(tableName));
    }

    public HTable(Configuration conf, byte[] tableName) throws IOException {
        this.tableName = tableName;
        this.cleanupOnClose = true;
        if (conf == null) {
            this.scannerTimeout = 0;
            this.connection = null;
            return;
        }
        this.connection = HConnectionManager.getConnection(conf);
        this.configuration = conf;
        int maxThreads = conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        long keepAliveTime = conf.getLong("hbase.htable.threads.keepalivetime", 60L);
        this.pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DaemonThreadFactory());
        ((ThreadPoolExecutor)this.pool).allowCoreThreadTimeOut(true);
        this.finishSetup();
    }

    public HTable(byte[] tableName, HConnection connection, ExecutorService pool) throws IOException {
        if (pool == null || pool.isShutdown()) {
            throw new IllegalArgumentException("Pool is null or shut down.");
        }
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = tableName;
        this.cleanupOnClose = false;
        this.connection = connection;
        this.configuration = connection.getConfiguration();
        this.pool = pool;
        this.finishSetup();
    }

    private void finishSetup() throws IOException {
        this.connection.locateRegion(this.tableName, HConstants.EMPTY_START_ROW);
        this.scannerTimeout = (int)this.configuration.getLong(HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, HConstants.DEFAULT_HBASE_REGIONSERVER_LEASE_PERIOD);
        this.operationTimeout = HTableDescriptor.isMetaTable(this.tableName) ? Integer.MAX_VALUE : this.configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.writeBufferSize = this.configuration.getLong("hbase.client.write.buffer", 0x200000L);
        this.clearBufferOnFail = true;
        this.autoFlush = true;
        this.currentWriteBufferSize = 0L;
        this.scannerCaching = this.configuration.getInt("hbase.client.scanner.caching", 1);
        this.maxScannerResultSize = this.configuration.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.maxKeyValueSize = this.configuration.getInt("hbase.client.keyvalue.maxsize", -1);
        this.closed = false;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public static boolean isTableEnabled(String tableName) throws IOException {
        return HTable.isTableEnabled(Bytes.toBytes(tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(byte[] tableName) throws IOException {
        return HTable.isTableEnabled(HBaseConfiguration.create(), tableName);
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, String tableName) throws IOException {
        return HTable.isTableEnabled(conf, Bytes.toBytes(tableName));
    }

    public static boolean isTableEnabled(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectionManager.HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.isTableEnabled(tableName);
            }
        });
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, Bytes.toBytes(row), false);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, reload);
    }

    @Override
    public byte[] getTableName() {
        return this.tableName;
    }

    public HConnection getConnection() {
        return this.connection;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public void setScannerCaching(int scannerCaching) {
        this.scannerCaching = scannerCaching;
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        return new UnmodifyableHTableDescriptor(this.connection.getHTableDescriptor(this.tableName));
    }

    public byte[][] getStartKeys() throws IOException {
        return this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        final ArrayList startKeyList = new ArrayList();
        final ArrayList endKeyList = new ArrayList();
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result rowResult) throws IOException {
                byte[] bytes = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                if (bytes == null) {
                    LOG.warn((Object)("Null regioninfo cell in " + rowResult));
                    return true;
                }
                HRegionInfo info = Writables.getHRegionInfo(bytes);
                if (Bytes.equals(info.getTableName(), HTable.this.getTableName()) && !info.isOffline() && !info.isSplit()) {
                    startKeyList.add(info.getStartKey());
                    endKeyList.add(info.getEndKey());
                }
                return true;
            }
        };
        MetaScanner.metaScan(this.configuration, visitor, this.tableName);
        return new Pair<T[], T[]>(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
    }

    public Map<HRegionInfo, HServerAddress> getRegionsInfo() throws IOException {
        final TreeMap<HRegionInfo, HServerAddress> regionMap = new TreeMap<HRegionInfo, HServerAddress>();
        MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

            @Override
            public boolean processRow(Result rowResult) throws IOException {
                HRegionInfo info = Writables.getHRegionInfo(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                if (!Bytes.equals(info.getTableName(), HTable.this.getTableName())) {
                    return false;
                }
                HServerAddress server = new HServerAddress();
                byte[] value = rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                if (value != null && value.length > 0) {
                    String hostAndPort = Bytes.toString(value);
                    server = new HServerAddress(Addressing.createInetSocketAddressFromHostAndPortStr(hostAndPort));
                }
                if (!info.isOffline() && !info.isSplit()) {
                    regionMap.put(new UnmodifyableHRegionInfo(info), server);
                }
                return true;
            }
        };
        MetaScanner.metaScan(this.configuration, visitor, this.tableName);
        return regionMap;
    }

    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        return MetaScanner.allTableRegions(this.getConfiguration(), this.getTableName(), false);
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals(endKey, HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo(startKey, endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary(startKey) + " > " + Bytes.toStringBinary(endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocation(currentKey, false);
            regionList.add(regionLocation);
        } while (!Bytes.equals(currentKey = regionLocation.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo(currentKey, endKey) < 0));
        return regionList;
    }

    public void prewarmRegionCache(Map<HRegionInfo, HServerAddress> regionMap) {
        this.connection.prewarmRegionCache(this.getTableName(), regionMap);
    }

    public void serializeRegionInfo(DataOutput out) throws IOException {
        Map<HRegionInfo, HServerAddress> allRegions = this.getRegionsInfo();
        out.writeInt(allRegions.size());
        for (Map.Entry<HRegionInfo, HServerAddress> es : allRegions.entrySet()) {
            es.getKey().write(out);
            es.getValue().write(out);
        }
    }

    public Map<HRegionInfo, HServerAddress> deserializeRegionInfo(DataInput in) throws IOException {
        TreeMap<HRegionInfo, HServerAddress> allRegions = new TreeMap<HRegionInfo, HServerAddress>();
        int regionsCount = in.readInt();
        for (int i = 0; i < regionsCount; ++i) {
            HRegionInfo hri = new HRegionInfo();
            hri.readFields(in);
            HServerAddress hsa = new HServerAddress();
            hsa.readFields(in);
            allRegions.put(hri, hsa);
        }
        return allRegions;
    }

    @Override
    public Result getRowOrBefore(byte[] row, final byte[] family) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Result>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Result call() throws IOException {
                return this.server.getClosestRowBefore(this.location.getRegionInfo().getRegionName(), this.row, family);
            }
        });
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        ClientScanner s = new ClientScanner(scan);
        s.initialize();
        return s;
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    @Override
    public Result get(final Get get2) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Result>(this.connection, this.tableName, get2.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                return this.server.get(this.location.getRegionInfo().getRegionName(), get2);
            }
        });
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        try {
            Object[] r1 = this.batch(gets);
            Result[] results = new Result[r1.length];
            int i = 0;
            for (Object o : r1) {
                results[i++] = (Result)o;
            }
            return results;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void batch(List<Row> actions, Object[] results) throws InterruptedException, IOException {
        this.connection.processBatch(actions, this.tableName, this.pool, results);
    }

    @Override
    public synchronized Object[] batch(List<Row> actions) throws InterruptedException, IOException {
        Object[] results = new Object[actions.size()];
        this.connection.processBatch(actions, this.tableName, this.pool, results);
        return results;
    }

    @Override
    public void delete(final Delete delete) throws IOException {
        this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, delete.getRow(), this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                this.server.delete(this.location.getRegionInfo().getRegionName(), delete);
                return null;
            }
        });
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        Object[] results = new Object[deletes.size()];
        try {
            this.connection.processBatch(deletes, this.tableName, this.pool, results);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            for (int i = results.length - 1; i >= 0; --i) {
                if (!(results[i] instanceof Result)) continue;
                deletes.remove(i);
            }
        }
    }

    @Override
    public void put(Put put) throws IOException {
        this.doPut(Arrays.asList(put));
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        this.doPut(puts);
    }

    private void doPut(List<Put> puts) throws IOException {
        int n = 0;
        for (Put put : puts) {
            this.validatePut(put);
            this.writeBuffer.add(put);
            this.currentWriteBufferSize += put.heapSize();
            if (++n % 10 != 0 || this.currentWriteBufferSize <= this.writeBufferSize) continue;
            this.flushCommits();
        }
        if (this.autoFlush || this.currentWriteBufferSize > this.writeBufferSize) {
            this.flushCommits();
        }
    }

    @Override
    public Result increment(final Increment increment) throws IOException {
        if (!increment.hasFamilies()) {
            throw new IOException("Invalid arguments to increment, no columns specified");
        }
        return this.connection.getRegionServerWithRetries(new ServerCallable<Result>(this.connection, this.tableName, increment.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                return this.server.increment(this.location.getRegionInfo().getRegionName(), increment);
            }
        });
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, true);
    }

    @Override
    public long incrementColumnValue(byte[] row, final byte[] family, final byte[] qualifier, final long amount, final boolean writeToWAL) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("column is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        return this.connection.getRegionServerWithRetries(new ServerCallable<Long>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Long call() throws IOException {
                return this.server.incrementColumnValue(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, amount, writeToWAL);
            }
        });
    }

    @Override
    public boolean checkAndPut(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Put put) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                return this.server.checkAndPut(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, value, put) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    @Override
    public boolean checkAndDelete(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Delete delete) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                return this.server.checkAndDelete(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, value, delete) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    @Override
    public boolean exists(final Get get2) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, get2.getRow(), this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                return this.server.exists(this.location.getRegionInfo().getRegionName(), get2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCommits() throws IOException {
        try {
            Object[] results = new Object[this.writeBuffer.size()];
            try {
                this.connection.processBatch(this.writeBuffer, this.tableName, this.pool, results);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            finally {
                for (int i = results.length - 1; i >= 0; --i) {
                    if (!(results[i] instanceof Result)) continue;
                    this.writeBuffer.remove(i);
                }
            }
        }
        finally {
            if (this.clearBufferOnFail) {
                this.writeBuffer.clear();
                this.currentWriteBufferSize = 0L;
            } else {
                this.currentWriteBufferSize = 0L;
                for (Put aPut : this.writeBuffer) {
                    this.currentWriteBufferSize += aPut.heapSize();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flushCommits();
        if (this.cleanupOnClose) {
            this.pool.shutdown();
            if (this.connection != null) {
                this.connection.close();
            }
        }
        this.closed = true;
    }

    private void validatePut(Put put) throws IllegalArgumentException {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (this.maxKeyValueSize > 0) {
            for (List<KeyValue> list : put.getFamilyMap().values()) {
                for (KeyValue kv : list) {
                    if (kv.getLength() <= this.maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    @Override
    public RowLock lockRow(byte[] row) throws IOException {
        return this.connection.getRegionServerWithRetries(new ServerCallable<RowLock>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public RowLock call() throws IOException {
                long lockId = this.server.lockRow(this.location.getRegionInfo().getRegionName(), this.row);
                return new RowLock(this.row, lockId);
            }
        });
    }

    @Override
    public void unlockRow(final RowLock rl) throws IOException {
        this.connection.getRegionServerWithRetries(new ServerCallable<Boolean>(this.connection, this.tableName, rl.getRow(), this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                this.server.unlockRow(this.location.getRegionInfo().getRegionName(), rl.getLockId());
                return null;
            }
        });
    }

    @Override
    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.setAutoFlush(autoFlush, autoFlush);
    }

    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.autoFlush = autoFlush;
        this.clearBufferOnFail = autoFlush || clearBufferOnFail;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flushCommits();
        }
    }

    public ArrayList<Put> getWriteBuffer() {
        return this.writeBuffer;
    }

    ExecutorService getPool() {
        return this.pool;
    }

    public static void setRegionCachePrefetch(final byte[] tableName, final boolean enable) throws IOException {
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(HBaseConfiguration.create()){

            @Override
            public Void connect(HConnection connection) throws IOException {
                connection.setRegionCachePrefetch(tableName, enable);
                return null;
            }
        });
    }

    public static void setRegionCachePrefetch(Configuration conf, final byte[] tableName, final boolean enable) throws IOException {
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(conf){

            @Override
            public Void connect(HConnection connection) throws IOException {
                connection.setRegionCachePrefetch(tableName, enable);
                return null;
            }
        });
    }

    public static boolean getRegionCachePrefetch(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectionManager.HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.getRegionCachePrefetch(tableName);
            }
        });
    }

    public static boolean getRegionCachePrefetch(final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectionManager.HConnectable<Boolean>(HBaseConfiguration.create()){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.getRegionCachePrefetch(tableName);
            }
        });
    }

    public void clearRegionCache() {
        this.connection.clearRegionCache();
    }

    @Override
    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
        return (T)((CoprocessorProtocol)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{protocol}, (InvocationHandler)new ExecRPCInvoker(this.configuration, this.connection, protocol, this.tableName, row)));
    }

    @Override
    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
        final TreeMap results = new TreeMap(Bytes.BYTES_COMPARATOR);
        this.coprocessorExec(protocol, startKey, endKey, callable, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R value) {
                results.put(region, value);
            }
        });
        return results;
    }

    @Override
    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
        List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
        this.connection.processExecs(protocol, keys, this.tableName, this.pool, callable, callback);
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        Pair<byte[][], byte[][]> startEndKeys = this.getStartEndKeys();
        byte[][] startKeys = startEndKeys.getFirst();
        byte[][] endKeys = startEndKeys.getSecond();
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        ArrayList<byte[]> rangeKeys = new ArrayList<byte[]>();
        for (int i = 0; i < startKeys.length; ++i) {
            if (Bytes.compareTo(start, startKeys[i]) >= 0) {
                if (!Bytes.equals(endKeys[i], HConstants.EMPTY_END_ROW) && Bytes.compareTo(start, endKeys[i]) >= 0) continue;
                rangeKeys.add(start);
                continue;
            }
            if (!Bytes.equals(end, HConstants.EMPTY_END_ROW) && Bytes.compareTo(startKeys[i], end) > 0) break;
            rangeKeys.add(startKeys[i]);
        }
        return rangeKeys;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "htable-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    protected class ClientScanner
    implements ResultScanner {
        private final Log CLIENT_LOG = LogFactory.getLog(this.getClass());
        private Scan scan;
        private boolean closed = false;
        private HRegionInfo currentRegion = null;
        private ScannerCallable callable = null;
        private final LinkedList<Result> cache = new LinkedList();
        private final int caching;
        private long lastNext;
        private Result lastResult = null;

        protected ClientScanner(Scan scan) {
            if (this.CLIENT_LOG.isDebugEnabled()) {
                this.CLIENT_LOG.debug((Object)("Creating scanner over " + Bytes.toString(HTable.this.getTableName()) + " starting at key '" + Bytes.toStringBinary(scan.getStartRow()) + "'"));
            }
            this.scan = scan;
            this.lastNext = System.currentTimeMillis();
            this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : HTable.this.scannerCaching;
        }

        public void initialize() throws IOException {
            this.nextScanner(this.caching, false);
        }

        protected Scan getScan() {
            return this.scan;
        }

        protected long getTimestamp() {
            return this.lastNext;
        }

        private boolean checkScanStopRow(byte[] endKey) {
            byte[] stopRow;
            int cmp;
            return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo(stopRow = this.scan.getStopRow(), 0, stopRow.length, endKey, 0, endKey.length)) <= 0;
        }

        private boolean nextScanner(int nbRows, boolean done) throws IOException {
            byte[] localStartKey;
            if (this.callable != null) {
                this.callable.setClose();
                HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                this.callable = null;
            }
            if (this.currentRegion != null) {
                byte[] endKey = this.currentRegion.getEndKey();
                if (endKey == null || Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                    this.close();
                    if (this.CLIENT_LOG.isDebugEnabled()) {
                        this.CLIENT_LOG.debug((Object)("Finished with scanning at " + (Object)((Object)this.currentRegion)));
                    }
                    return false;
                }
                localStartKey = endKey;
                if (this.CLIENT_LOG.isDebugEnabled()) {
                    this.CLIENT_LOG.debug((Object)("Finished with region " + (Object)((Object)this.currentRegion)));
                }
            } else {
                localStartKey = this.scan.getStartRow();
            }
            if (this.CLIENT_LOG.isDebugEnabled()) {
                this.CLIENT_LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
            }
            try {
                this.callable = this.getScannerCallable(localStartKey, nbRows);
                HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                this.currentRegion = this.callable.getHRegionInfo();
            }
            catch (IOException e) {
                this.close();
                throw e;
            }
            return true;
        }

        protected ScannerCallable getScannerCallable(byte[] localStartKey, int nbRows) {
            this.scan.setStartRow(localStartKey);
            ScannerCallable s = new ScannerCallable(HTable.this.getConnection(), HTable.this.getTableName(), this.scan);
            s.setCaching(nbRows);
            return s;
        }

        @Override
        public Result next() throws IOException {
            if (this.cache.size() == 0 && this.closed) {
                return null;
            }
            if (this.cache.size() == 0) {
                Result[] values = null;
                long remainingResultSize = HTable.this.maxScannerResultSize;
                int countdown = this.caching;
                this.callable.setCaching(this.caching);
                boolean skipFirst = false;
                do {
                    try {
                        if (skipFirst) {
                            this.callable.setCaching(1);
                            values = HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                            this.callable.setCaching(this.caching);
                            skipFirst = false;
                        }
                        values = HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                    }
                    catch (DoNotRetryIOException e) {
                        if (e instanceof UnknownScannerException) {
                            long timeout = this.lastNext + (long)HTable.this.scannerTimeout;
                            if (timeout < System.currentTimeMillis()) {
                                long elapsed = System.currentTimeMillis() - this.lastNext;
                                ScannerTimeoutException ex = new ScannerTimeoutException(elapsed + "ms passed since the last invocation, " + "timeout is currently set to " + HTable.this.scannerTimeout);
                                ex.initCause(e);
                                throw ex;
                            }
                        } else {
                            Throwable cause = e.getCause();
                            if (cause == null || !(cause instanceof NotServingRegionException) && !(cause instanceof RegionServerStoppedException)) {
                                throw e;
                            }
                        }
                        if (this.lastResult != null) {
                            this.scan.setStartRow(this.lastResult.getRow());
                            skipFirst = true;
                        }
                        this.currentRegion = null;
                        continue;
                    }
                    this.lastNext = System.currentTimeMillis();
                    if (values == null || values.length <= 0) continue;
                    for (Result rs : values) {
                        this.cache.add(rs);
                        for (KeyValue kv : rs.raw()) {
                            remainingResultSize -= kv.heapSize();
                        }
                        --countdown;
                        this.lastResult = rs;
                    }
                } while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null));
            }
            if (this.cache.size() > 0) {
                return this.cache.poll();
            }
            return null;
        }

        @Override
        public Result[] next(int nbRows) throws IOException {
            Result next;
            ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                resultSets.add(next);
            }
            return resultSets.toArray(new Result[resultSets.size()]);
        }

        @Override
        public void close() {
            if (this.callable != null) {
                this.callable.setClose();
                try {
                    HTable.this.getConnection().getRegionServerWithRetries(this.callable);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.callable = null;
            }
            this.closed = true;
        }

        @Override
        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                Result next = null;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        try {
                            this.next = ClientScanner.this.next();
                            return this.next != null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return true;
                }

                @Override
                public Result next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    Result temp = this.next;
                    this.next = null;
                    return temp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

