/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.WritableWithSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Result
implements Writable,
WritableWithSize {
    private static final byte RESULT_VERSION = 1;
    private KeyValue[] kvs = null;
    private NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> familyMap = null;
    private transient byte[] row = null;
    private ImmutableBytesWritable bytes = null;

    public Result() {
    }

    public Result(KeyValue[] kvs) {
        if (kvs != null && kvs.length > 0) {
            this.kvs = kvs;
        }
    }

    public Result(List<KeyValue> kvs) {
        this(kvs.toArray(new KeyValue[0]));
    }

    public Result(ImmutableBytesWritable bytes) {
        this.bytes = bytes;
    }

    public byte[] getRow() {
        if (this.row == null) {
            if (this.kvs == null) {
                this.readFields();
            }
            this.row = this.kvs.length == 0 ? null : this.kvs[0].getRow();
        }
        return this.row;
    }

    public KeyValue[] raw() {
        if (this.kvs == null) {
            this.readFields();
        }
        return this.kvs;
    }

    public List<KeyValue> list() {
        if (this.kvs == null) {
            this.readFields();
        }
        return this.isEmpty() ? null : Arrays.asList(this.raw());
    }

    public List<KeyValue> getColumn(byte[] family, byte[] qualifier) {
        KeyValue kv;
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        KeyValue[] kvs = this.raw();
        if (kvs == null || kvs.length == 0) {
            return result;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return result;
        }
        for (int i = pos; i < kvs.length && (kv = kvs[i]).matchingColumn(family, qualifier); ++i) {
            result.add(kv);
        }
        return result;
    }

    protected int binarySearch(KeyValue[] kvs, byte[] family, byte[] qualifier) {
        KeyValue searchTerm = KeyValue.createFirstOnRow(kvs[0].getRow(), family, qualifier);
        int pos = Arrays.binarySearch(kvs, searchTerm, KeyValue.COMPARATOR);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    public KeyValue getColumnLatest(byte[] family, byte[] qualifier) {
        KeyValue[] kvs = this.raw();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return null;
        }
        KeyValue kv = kvs[pos];
        if (kv.matchingColumn(family, qualifier)) {
            return kv;
        }
        return null;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        KeyValue kv = this.getColumnLatest(family, qualifier);
        if (kv == null) {
            return null;
        }
        return kv.getValue();
    }

    public boolean containsColumn(byte[] family, byte[] qualifier) {
        KeyValue kv = this.getColumnLatest(family, qualifier);
        return kv != null;
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
        if (this.familyMap != null) {
            return this.familyMap;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (KeyValue kv : this.kvs) {
            byte[] qualifier;
            TreeMap<Long, byte[]> versionMap;
            KeyValue.SplitKeyValue splitKV = kv.split();
            byte[] family = splitKV.getFamily();
            TreeMap columnMap = (TreeMap)this.familyMap.get(family);
            if (columnMap == null) {
                columnMap = new TreeMap(Bytes.BYTES_COMPARATOR);
                this.familyMap.put(family, columnMap);
            }
            if ((versionMap = (TreeMap<Long, byte[]>)columnMap.get(qualifier = splitKV.getQualifier())) == null) {
                versionMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

                    @Override
                    public int compare(Long l1, Long l2) {
                        return l2.compareTo(l1);
                    }
                });
                columnMap.put(qualifier, versionMap);
            }
            Long timestamp = Bytes.toLong(splitKV.getTimestamp());
            byte[] value = splitKV.getValue();
            versionMap.put(timestamp, value);
        }
        return this.familyMap;
    }

    public NavigableMap<byte[], NavigableMap<byte[], byte[]>> getNoVersionMap() {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], NavigableMap<byte[], byte[]>> returnMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyEntry : this.familyMap.entrySet()) {
            TreeMap<byte[], byte[]> qualifierMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
            for (Map.Entry qualifierEntry : ((NavigableMap)familyEntry.getValue()).entrySet()) {
                byte[] value = (byte[])((NavigableMap)qualifierEntry.getValue()).get(((NavigableMap)qualifierEntry.getValue()).firstKey());
                qualifierMap.put((byte[])qualifierEntry.getKey(), value);
            }
            returnMap.put((byte[])familyEntry.getKey(), (NavigableMap<byte[], byte[]>)qualifierMap);
        }
        return returnMap;
    }

    public NavigableMap<byte[], byte[]> getFamilyMap(byte[] family) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], byte[]> returnMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return returnMap;
        }
        for (Map.Entry entry : qualifierMap.entrySet()) {
            byte[] value = (byte[])((NavigableMap)entry.getValue()).get(((NavigableMap)entry.getValue()).firstKey());
            returnMap.put((byte[])entry.getKey(), value);
        }
        return returnMap;
    }

    public byte[] value() {
        if (this.isEmpty()) {
            return null;
        }
        return this.kvs[0].getValue();
    }

    public ImmutableBytesWritable getBytes() {
        return this.bytes;
    }

    public boolean isEmpty() {
        if (this.kvs == null) {
            this.readFields();
        }
        return this.kvs == null || this.kvs.length == 0;
    }

    public int size() {
        if (this.kvs == null) {
            this.readFields();
        }
        return this.kvs == null ? 0 : this.kvs.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (KeyValue kv : this.kvs) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.familyMap = null;
        this.row = null;
        this.kvs = null;
        int totalBuffer = in.readInt();
        if (totalBuffer == 0) {
            this.bytes = null;
            return;
        }
        byte[] raw = new byte[totalBuffer];
        in.readFully(raw, 0, totalBuffer);
        this.bytes = new ImmutableBytesWritable(raw, 0, totalBuffer);
    }

    private void readFields() {
        int keyLength;
        int offset;
        if (this.bytes == null) {
            this.kvs = new KeyValue[0];
            return;
        }
        byte[] buf = this.bytes.get();
        int finalOffset = this.bytes.getSize() + offset;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (offset = this.bytes.getOffset(); offset < finalOffset; offset += keyLength) {
            keyLength = Bytes.toInt(buf, offset);
            kvs.add(new KeyValue(buf, offset += 4, keyLength));
        }
        this.kvs = kvs.toArray(new KeyValue[kvs.size()]);
    }

    @Override
    public long getWritableSize() {
        if (this.isEmpty()) {
            return 4L;
        }
        long size = 4L;
        for (KeyValue kv : this.kvs) {
            size += (long)kv.getLength();
            size += 4L;
        }
        return size;
    }

    public void write(DataOutput out) throws IOException {
        if (this.isEmpty()) {
            out.writeInt(0);
        } else {
            int totalLen = 0;
            for (KeyValue kv : this.kvs) {
                totalLen += kv.getLength() + 4;
            }
            out.writeInt(totalLen);
            for (KeyValue kv : this.kvs) {
                out.writeInt(kv.getLength());
                out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
        }
    }

    public static long getWriteArraySize(Result[] results) {
        long size = 1L;
        if (results == null || results.length == 0) {
            return size += 4L;
        }
        size += 4L;
        size += 4L;
        for (Result result : results) {
            size += 4L;
            if (result == null || result.isEmpty()) continue;
            for (KeyValue kv : result.raw()) {
                size += 4L;
                size += (long)kv.getLength();
            }
        }
        return size;
    }

    public static void writeArray(DataOutput out, Result[] results) throws IOException {
        out.writeByte(1);
        if (results == null || results.length == 0) {
            out.writeInt(0);
            return;
        }
        out.writeInt(results.length);
        int bufLen = 0;
        for (Result result : results) {
            bufLen += 4;
            if (result == null || result.isEmpty()) continue;
            for (KeyValue key : result.raw()) {
                bufLen += key.getLength() + 4;
            }
        }
        out.writeInt(bufLen);
        for (Result result : results) {
            if (result == null || result.isEmpty()) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(result.size());
            for (KeyValue kv : result.raw()) {
                out.writeInt(kv.getLength());
                out.write(kv.getBuffer(), kv.getOffset(), kv.getLength());
            }
        }
    }

    public static Result[] readArray(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new IOException("version not supported");
        }
        int numResults = in.readInt();
        if (numResults == 0) {
            return new Result[0];
        }
        Result[] results = new Result[numResults];
        int bufSize = in.readInt();
        byte[] buf = new byte[bufSize];
        int offset = 0;
        for (int i = 0; i < numResults; ++i) {
            int numKeys = in.readInt();
            offset += 4;
            if (numKeys == 0) {
                results[i] = new Result((ImmutableBytesWritable)null);
                continue;
            }
            int initialOffset = offset;
            for (int j = 0; j < numKeys; ++j) {
                int keyLen = in.readInt();
                Bytes.putInt(buf, offset, keyLen);
                in.readFully(buf, offset += 4, keyLen);
                offset += keyLen;
            }
            int totalLength = offset - initialOffset;
            results[i] = new Result(new ImmutableBytesWritable(buf, initialOffset, totalLength));
        }
        return results;
    }

    public static void compareResults(Result res1, Result res2) throws Exception {
        if (res2 == null) {
            throw new Exception("There wasn't enough rows, we stopped at " + Bytes.toStringBinary(res1.getRow()));
        }
        if (res1.size() != res2.size()) {
            throw new Exception("This row doesn't have the same number of KVs: " + res1.toString() + " compared to " + res2.toString());
        }
        KeyValue[] ourKVs = res1.raw();
        KeyValue[] replicatedKVs = res2.raw();
        for (int i = 0; i < res1.size(); ++i) {
            if (ourKVs[i].equals(replicatedKVs[i]) && Bytes.equals(ourKVs[i].getValue(), replicatedKVs[i].getValue())) continue;
            throw new Exception("This result was different: " + res1.toString() + " compared to " + res2.toString());
        }
    }
}

