/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Addressing;

public class RetriesExhaustedWithDetailsException
extends RetriesExhaustedException {
    List<Throwable> exceptions;
    List<Row> actions;
    List<String> hostnameAndPort;

    public RetriesExhaustedWithDetailsException(List<Throwable> exceptions, List<Row> actions, List<String> hostnameAndPort) {
        super("Failed " + exceptions.size() + " action" + RetriesExhaustedWithDetailsException.pluralize(exceptions) + ": " + RetriesExhaustedWithDetailsException.getDesc(exceptions, actions, hostnameAndPort));
        this.exceptions = exceptions;
        this.actions = actions;
        this.hostnameAndPort = hostnameAndPort;
    }

    public List<Throwable> getCauses() {
        return this.exceptions;
    }

    public int getNumExceptions() {
        return this.exceptions.size();
    }

    public Throwable getCause(int i) {
        return this.exceptions.get(i);
    }

    public Row getRow(int i) {
        return this.actions.get(i);
    }

    public HServerAddress getAddress(int i) {
        return new HServerAddress(Addressing.createInetSocketAddressFromHostAndPortStr(this.getHostnamePort(i)));
    }

    public String getHostnamePort(int i) {
        return this.hostnameAndPort.get(i);
    }

    public boolean mayHaveClusterIssues() {
        boolean res = false;
        for (Throwable t : this.exceptions) {
            if (t instanceof DoNotRetryIOException) continue;
            res = true;
        }
        return res;
    }

    public static String pluralize(Collection<?> c) {
        return RetriesExhaustedWithDetailsException.pluralize(c.size());
    }

    public static String pluralize(int c) {
        return c > 1 ? "s" : "";
    }

    public static String getDesc(List<Throwable> exceptions, List<Row> actions, List<String> hostnamePort) {
        String s = RetriesExhaustedWithDetailsException.getDesc(RetriesExhaustedWithDetailsException.classifyExs(exceptions));
        s = s + "servers with issues: ";
        HashSet<String> uniqAddr = new HashSet<String>();
        uniqAddr.addAll(hostnamePort);
        for (String addr : uniqAddr) {
            s = s + addr + ", ";
        }
        return s;
    }

    public static Map<String, Integer> classifyExs(List<Throwable> ths) {
        HashMap<String, Integer> cls = new HashMap<String, Integer>();
        for (Throwable t : ths) {
            if (t == null) continue;
            String name = "";
            name = t instanceof NoSuchColumnFamilyException ? t.getMessage() : t.getClass().getSimpleName();
            Integer i = (Integer)cls.get(name);
            if (i == null) {
                i = 0;
            }
            i = i + 1;
            cls.put(name, i);
        }
        return cls;
    }

    public static String getDesc(Map<String, Integer> classificaton) {
        String s = "";
        for (Map.Entry<String, Integer> e : classificaton.entrySet()) {
            s = s + e.getKey() + ": " + e.getValue() + " time" + RetriesExhaustedWithDetailsException.pluralize(e.getValue()) + ", ";
        }
        return s;
    }
}

