/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;

public abstract class ServerCallable<T>
implements Callable<T> {
    protected final HConnection connection;
    protected final byte[] tableName;
    protected final byte[] row;
    protected HRegionLocation location;
    protected HRegionInterface server;
    protected int callTimeout;
    protected long startTime;
    protected long endTime;

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row) {
        this(connection, tableName, row, Integer.MAX_VALUE);
    }

    public ServerCallable(HConnection connection, byte[] tableName, byte[] row, int callTimeout) {
        this.connection = connection;
        this.tableName = tableName;
        this.row = row;
        this.callTimeout = callTimeout;
    }

    public void connect(boolean reload) throws IOException {
        this.location = this.connection.getRegionLocation(this.tableName, this.row, reload);
        this.server = this.connection.getHRegionConnection(this.location.getHostname(), this.location.getPort());
    }

    public String getServerName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getHostnamePort();
    }

    public byte[] getRegionName() {
        if (this.location == null) {
            return null;
        }
        return this.location.getRegionInfo().getRegionName();
    }

    public byte[] getRow() {
        return this.row;
    }

    public void beforeCall() {
        HBaseRPC.setRpcTimeout(this.callTimeout);
        this.startTime = System.currentTimeMillis();
    }

    public void afterCall() {
        HBaseRPC.resetRpcTimeout();
        this.endTime = System.currentTimeMillis();
    }

    public void shouldRetry(Throwable throwable) throws IOException {
        if (this.callTimeout != Integer.MAX_VALUE) {
            if (throwable instanceof SocketTimeoutException || this.endTime - this.startTime > (long)this.callTimeout) {
                throw (SocketTimeoutException)new SocketTimeoutException("Call to access row '" + Bytes.toString(this.row) + "' on table '" + Bytes.toString(this.tableName) + "' failed on socket timeout exception: " + throwable).initCause(throwable);
            }
            this.callTimeout = (int)(this.endTime - this.startTime);
        }
    }
}

