/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.AggregateProtocol;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AggregationClient {
    private static final Log log = LogFactory.getLog(AggregationClient.class);
    Configuration conf;

    public AggregationClient(Configuration cfg) {
        this.conf = cfg;
    }

    public <R, S> R max(byte[] tableName, final ColumnInterpreter<R, S> ci, final Scan scan) throws Throwable {
        this.validateParameters(scan);
        HTable table = new HTable(this.conf, tableName);
        class MaxCallBack
        implements Batch.Callback<R> {
            R max = null;

            MaxCallBack() {
            }

            R getMax() {
                return this.max;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, R result) {
                this.max = this.max == null || result != null && ci.compare(this.max, result) < 0 ? result : this.max;
            }
        }
        MaxCallBack aMaxCallBack = new MaxCallBack();
        table.coprocessorExec(AggregateProtocol.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtocol, R>(){

            @Override
            public R call(AggregateProtocol instance) throws IOException {
                return instance.getMax(ci, scan);
            }
        }, aMaxCallBack);
        return aMaxCallBack.getMax();
    }

    private void validateParameters(Scan scan) throws IOException {
        if (scan == null || Bytes.equals(scan.getStartRow(), scan.getStopRow()) && !Bytes.equals(scan.getStartRow(), HConstants.EMPTY_START_ROW) || Bytes.compareTo(scan.getStartRow(), scan.getStopRow()) > 0 && !Bytes.equals(scan.getStopRow(), HConstants.EMPTY_END_ROW)) {
            throw new IOException("Agg client Exception: Startrow should be smaller than Stoprow");
        }
        if (scan.getFamilyMap().size() != 1) {
            throw new IOException("There must be only one family.");
        }
    }

    public <R, S> R min(byte[] tableName, final ColumnInterpreter<R, S> ci, final Scan scan) throws Throwable {
        this.validateParameters(scan);
        HTable table = new HTable(this.conf, tableName);
        class MinCallBack
        implements Batch.Callback<R> {
            private R min = null;

            MinCallBack() {
            }

            public R getMinimum() {
                return this.min;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, R result) {
                this.min = this.min == null || result != null && ci.compare(result, this.min) < 0 ? result : this.min;
            }
        }
        MinCallBack minCallBack = new MinCallBack();
        table.coprocessorExec(AggregateProtocol.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtocol, R>(){

            @Override
            public R call(AggregateProtocol instance) throws IOException {
                return instance.getMin(ci, scan);
            }
        }, minCallBack);
        log.debug((Object)("Min fom all regions is: " + minCallBack.getMinimum()));
        return minCallBack.getMinimum();
    }

    public <R, S> long rowCount(byte[] tableName, final ColumnInterpreter<R, S> ci, final Scan scan) throws Throwable {
        this.validateParameters(scan);
        class RowNumCallback
        implements Batch.Callback<Long> {
            private final AtomicLong rowCountL = new AtomicLong(0L);

            RowNumCallback() {
            }

            public long getRowNumCount() {
                return this.rowCountL.get();
            }

            @Override
            public void update(byte[] region, byte[] row, Long result) {
                this.rowCountL.addAndGet(result);
            }
        }
        RowNumCallback rowNum = new RowNumCallback();
        HTable table = new HTable(this.conf, tableName);
        table.coprocessorExec(AggregateProtocol.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtocol, Long>(){

            @Override
            public Long call(AggregateProtocol instance) throws IOException {
                return instance.getRowNum(ci, scan);
            }
        }, rowNum);
        return rowNum.getRowNumCount();
    }

    public <R, S> S sum(byte[] tableName, final ColumnInterpreter<R, S> ci, final Scan scan) throws Throwable {
        this.validateParameters(scan);
        class SumCallBack
        implements Batch.Callback<S> {
            S sumVal = null;

            SumCallBack() {
            }

            public S getSumResult() {
                return this.sumVal;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, S result) {
                this.sumVal = ci.add(this.sumVal, result);
            }
        }
        SumCallBack sumCallBack = new SumCallBack();
        HTable table = new HTable(this.conf, tableName);
        table.coprocessorExec(AggregateProtocol.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtocol, S>(){

            @Override
            public S call(AggregateProtocol instance) throws IOException {
                return instance.getSum(ci, scan);
            }
        }, sumCallBack);
        return sumCallBack.getSumResult();
    }

    private <R, S> Pair<S, Long> getAvgArgs(byte[] tableName, final ColumnInterpreter<R, S> ci, final Scan scan) throws Throwable {
        this.validateParameters(scan);
        class AvgCallBack
        implements Batch.Callback<Pair<S, Long>> {
            S sum = null;
            Long rowCount = 0L;

            AvgCallBack() {
            }

            public Pair<S, Long> getAvgArgs() {
                return new Pair(this.sum, this.rowCount);
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, Pair<S, Long> result) {
                this.sum = ci.add(this.sum, result.getFirst());
                this.rowCount = this.rowCount + result.getSecond();
            }
        }
        AvgCallBack avgCallBack = new AvgCallBack();
        HTable table = new HTable(this.conf, tableName);
        table.coprocessorExec(AggregateProtocol.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtocol, Pair<S, Long>>(){

            @Override
            public Pair<S, Long> call(AggregateProtocol instance) throws IOException {
                return instance.getAvg(ci, scan);
            }
        }, avgCallBack);
        return avgCallBack.getAvgArgs();
    }

    public <R, S> double avg(byte[] tableName, ColumnInterpreter<R, S> ci, Scan scan) throws Throwable {
        Pair<S, Long> p = this.getAvgArgs(tableName, ci, scan);
        return ci.divideForAvg(p.getFirst(), p.getSecond());
    }

    private <R, S> Pair<List<S>, Long> getStdArgs(byte[] tableName, final ColumnInterpreter<R, S> ci, final Scan scan) throws Throwable {
        this.validateParameters(scan);
        class StdCallback
        implements Batch.Callback<Pair<List<S>, Long>> {
            long rowCountVal = 0L;
            S sumVal = null;
            S sumSqVal = null;

            StdCallback() {
            }

            public Pair<List<S>, Long> getStdParams() {
                ArrayList l = new ArrayList();
                l.add(this.sumVal);
                l.add(this.sumSqVal);
                Pair p = new Pair(l, this.rowCountVal);
                return p;
            }

            @Override
            public synchronized void update(byte[] region, byte[] row, Pair<List<S>, Long> result) {
                this.sumVal = ci.add(this.sumVal, result.getFirst().get(0));
                this.sumSqVal = ci.add(this.sumSqVal, result.getFirst().get(1));
                this.rowCountVal += result.getSecond().longValue();
            }
        }
        StdCallback stdCallback = new StdCallback();
        HTable table = new HTable(this.conf, tableName);
        table.coprocessorExec(AggregateProtocol.class, scan.getStartRow(), scan.getStopRow(), new Batch.Call<AggregateProtocol, Pair<List<S>, Long>>(){

            @Override
            public Pair<List<S>, Long> call(AggregateProtocol instance) throws IOException {
                return instance.getStd(ci, scan);
            }
        }, stdCallback);
        return stdCallback.getStdParams();
    }

    public <R, S> double std(byte[] tableName, ColumnInterpreter<R, S> ci, Scan scan) throws Throwable {
        Pair<List<S>, Long> p = this.getStdArgs(tableName, ci, scan);
        double res = 0.0;
        double avg = ci.divideForAvg(p.getFirst().get(0), p.getSecond());
        double avgOfSumSq = ci.divideForAvg(p.getFirst().get(1), p.getSecond());
        res = avgOfSumSq - avg * avg;
        res = Math.pow(res, 0.5);
        return res;
    }
}

