/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.util.Bytes;

public class LongColumnInterpreter
implements ColumnInterpreter<Long, Long> {
    @Override
    public Long getValue(byte[] colFamily, byte[] colQualifier, KeyValue kv) throws IOException {
        if (kv == null || kv.getValue().length != 8) {
            return null;
        }
        return Bytes.toLong(kv.getValue());
    }

    @Override
    public Long add(Long l1, Long l2) {
        if (l1 == null ^ l2 == null) {
            return l1 == null ? l2 : l1;
        }
        if (l1 == null) {
            return null;
        }
        return l1 + l2;
    }

    @Override
    public int compare(Long l1, Long l2) {
        if (l1 == null ^ l2 == null) {
            return l1 == null ? -1 : 1;
        }
        if (l1 == null) {
            return 0;
        }
        return l1.compareTo(l2);
    }

    @Override
    public Long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public Long increment(Long o) {
        return o == null ? null : Long.valueOf(o + 1L);
    }

    @Override
    public Long multiply(Long l1, Long l2) {
        return l1 == null || l2 == null ? null : Long.valueOf(l1 * l2);
    }

    @Override
    public Long getMinValue() {
        return Long.MIN_VALUE;
    }

    public void readFields(DataInput arg0) throws IOException {
    }

    public void write(DataOutput arg0) throws IOException {
    }

    @Override
    public double divideForAvg(Long l1, Long l2) {
        return l2 == null || l1 == null ? Double.NaN : l1.doubleValue() / l2.doubleValue();
    }

    @Override
    public Long castToReturnType(Long o) {
        return o;
    }
}

