/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.AggregateProtocol;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Pair;

public class AggregateImplementation
extends BaseEndpointCoprocessor
implements AggregateProtocol {
    protected static Log log = LogFactory.getLog(AggregateImplementation.class);

    @Override
    public ProtocolSignature getProtocolSignature(String protocol, long version, int clientMethodsHashCode) throws IOException {
        if (AggregateProtocol.class.getName().equals(protocol)) {
            return new ProtocolSignature(1L, null);
        }
        throw new IOException("Unknown protocol: " + protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> T getMax(ColumnInterpreter<T, S> ci, Scan scan) throws IOException {
        T max = null;
        RegionScanner scanner = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getScanner(scan);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        byte[] colFamily = scan.getFamilies()[0];
        byte[] qualifier = scan.getFamilyMap().get(colFamily).pollFirst();
        try {
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                for (KeyValue kv : results) {
                    T temp = ci.getValue(colFamily, qualifier, kv);
                    max = max == null || temp != null && ci.compare(temp, max) > 0 ? temp : max;
                }
                results.clear();
            } while (hasMoreRows);
        }
        finally {
            scanner.close();
        }
        log.info((Object)("Maximum from this region is " + ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getRegionNameAsString() + ": " + max));
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> T getMin(ColumnInterpreter<T, S> ci, Scan scan) throws IOException {
        T min = null;
        RegionScanner scanner = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getScanner(scan);
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        byte[] colFamily = scan.getFamilies()[0];
        byte[] qualifier = scan.getFamilyMap().get(colFamily).pollFirst();
        try {
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                for (KeyValue kv : results) {
                    T temp = ci.getValue(colFamily, qualifier, kv);
                    min = min == null || temp != null && ci.compare(temp, min) < 0 ? temp : min;
                }
                results.clear();
            } while (hasMoreRows);
        }
        finally {
            scanner.close();
        }
        log.info((Object)("Minimum from this region is " + ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getRegionNameAsString() + ": " + min));
        return min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> S getSum(ColumnInterpreter<T, S> ci, Scan scan) throws IOException {
        long sum = 0L;
        S sumVal = null;
        RegionScanner scanner = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getScanner(scan);
        byte[] colFamily = scan.getFamilies()[0];
        byte[] qualifier = scan.getFamilyMap().get(colFamily).pollFirst();
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        try {
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                for (KeyValue kv : results) {
                    T temp = ci.getValue(colFamily, qualifier, kv);
                    if (temp == null) continue;
                    sumVal = ci.add(sumVal, ci.castToReturnType(temp));
                }
                results.clear();
            } while (hasMoreRows);
        }
        finally {
            scanner.close();
        }
        log.debug((Object)("Sum from this region is " + ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getRegionNameAsString() + ": " + sum));
        return sumVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> long getRowNum(ColumnInterpreter<T, S> ci, Scan scan) throws IOException {
        long counter = 0L;
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        byte[] colFamily = scan.getFamilies()[0];
        byte[] qualifier = scan.getFamilyMap().get(colFamily).pollFirst();
        if (scan.getFilter() == null && qualifier == null) {
            scan.setFilter(new FirstKeyOnlyFilter());
        }
        RegionScanner scanner = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getScanner(scan);
        try {
            boolean hasMoreRows = false;
            do {
                hasMoreRows = scanner.next(results);
                if (results.size() > 0) {
                    ++counter;
                }
                results.clear();
            } while (hasMoreRows);
        }
        finally {
            scanner.close();
        }
        log.info((Object)("Row counter from this region is " + ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getRegionNameAsString() + ": " + counter));
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> Pair<S, Long> getAvg(ColumnInterpreter<T, S> ci, Scan scan) throws IOException {
        Object sumVal = null;
        Long rowCountVal = 0L;
        RegionScanner scanner = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getScanner(scan);
        byte[] colFamily = scan.getFamilies()[0];
        byte[] qualifier = scan.getFamilyMap().get(colFamily).pollFirst();
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        boolean hasMoreRows = false;
        try {
            do {
                results.clear();
                hasMoreRows = scanner.next(results);
                for (KeyValue kv : results) {
                    sumVal = ci.add(sumVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, kv)));
                }
                Long i$ = rowCountVal;
                Long l = rowCountVal = Long.valueOf(rowCountVal + 1L);
            } while (hasMoreRows);
        }
        finally {
            scanner.close();
        }
        Pair<Object, Long> pair = new Pair<Object, Long>(sumVal, rowCountVal);
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, S> Pair<List<S>, Long> getStd(ColumnInterpreter<T, S> ci, Scan scan) throws IOException {
        Object sumVal = null;
        Object sumSqVal = null;
        Object tempVal = null;
        long rowCountVal = 0L;
        RegionScanner scanner = ((RegionCoprocessorEnvironment)this.getEnvironment()).getRegion().getScanner(scan);
        byte[] colFamily = scan.getFamilies()[0];
        byte[] qualifier = scan.getFamilyMap().get(colFamily).pollFirst();
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        boolean hasMoreRows = false;
        try {
            do {
                tempVal = null;
                hasMoreRows = scanner.next(results);
                for (KeyValue kv : results) {
                    tempVal = ci.add(tempVal, ci.castToReturnType(ci.getValue(colFamily, qualifier, kv)));
                }
                results.clear();
                sumVal = ci.add(sumVal, tempVal);
                sumSqVal = ci.add(sumSqVal, ci.multiply(tempVal, tempVal));
                ++rowCountVal;
            } while (hasMoreRows);
        }
        finally {
            scanner.close();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(sumVal);
        l.add(sumSqVal);
        Pair<List<S>, Long> p = new Pair<List<S>, Long>(l, rowCountVal);
        return p;
    }
}

