/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;

public class ColumnPaginationFilter
extends FilterBase {
    private int limit = 0;
    private int offset = 0;
    private int count = 0;

    public ColumnPaginationFilter() {
    }

    public ColumnPaginationFilter(int limit, int offset) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"limit must be positive %s", (Object[])new Object[]{limit});
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be positive %s", (Object[])new Object[]{offset});
        this.limit = limit;
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.count >= this.offset + this.limit) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.count < this.offset ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        ++this.count;
        return code;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 but got: %s", (Object[])new Object[]{filterArguments.size()});
        int limit = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        int offset = ParseFilter.convertByteArrayToInt(filterArguments.get(1));
        return new ColumnPaginationFilter(limit, offset);
    }

    public void readFields(DataInput in) throws IOException {
        this.limit = in.readInt();
        this.offset = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.limit);
        out.writeInt(this.offset);
    }
}

