/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnPrefixFilter
extends FilterBase {
    protected byte[] prefix = null;

    public ColumnPrefixFilter() {
    }

    public ColumnPrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue kv) {
        if (this.prefix == null || kv.getBuffer() == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    public Filter.ReturnCode filterColumn(byte[] buffer, int qualifierOffset, int qualifierLength) {
        if (qualifierLength < this.prefix.length) {
            int cmp = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.prefix, 0, qualifierLength);
            if (cmp <= 0) {
                return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
            }
            return Filter.ReturnCode.NEXT_ROW;
        }
        int cmp = Bytes.compareTo(buffer, qualifierOffset, this.prefix.length, this.prefix, 0, this.prefix.length);
        if (cmp < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (cmp > 0) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new ColumnPrefixFilter(columnPrefix);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.prefix);
    }

    public void readFields(DataInput in) throws IOException {
        this.prefix = Bytes.readByteArray(in);
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue kv) {
        return KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), this.prefix, 0, this.prefix.length);
    }
}

