/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class DependentColumnFilter
extends CompareFilter {
    protected byte[] columnFamily;
    protected byte[] columnQualifier;
    protected boolean dropDependentColumn;
    protected Set<Long> stampSet = new HashSet<Long>();

    public DependentColumnFilter() {
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn, CompareFilter.CompareOp valueCompareOp, WritableByteArrayComparable valueComparator) {
        super(valueCompareOp, valueComparator);
        this.columnFamily = family;
        this.columnQualifier = qualifier;
        this.dropDependentColumn = dropDependentColumn;
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier) {
        this(family, qualifier, false);
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean dropDependentColumn) {
        this(family, qualifier, dropDependentColumn, CompareFilter.CompareOp.NO_OP, null);
    }

    public byte[] getFamily() {
        return this.columnFamily;
    }

    public byte[] getQualifier() {
        return this.columnQualifier;
    }

    public boolean dropDependentColumn() {
        return this.dropDependentColumn;
    }

    public boolean getDropDependentColumn() {
        return this.dropDependentColumn;
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (!v.matchingColumn(this.columnFamily, this.columnQualifier)) {
            return Filter.ReturnCode.INCLUDE;
        }
        if (this.comparator != null && this.doCompare(this.compareOp, this.comparator, v.getValue(), 0, v.getValueLength())) {
            return Filter.ReturnCode.SKIP;
        }
        this.stampSet.add(v.getTimestamp());
        if (this.dropDependentColumn) {
            return Filter.ReturnCode.SKIP;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public void filterRow(List<KeyValue> kvs) {
        Iterator<KeyValue> it = kvs.iterator();
        while (it.hasNext()) {
            KeyValue kv = it.next();
            if (this.stampSet.contains(kv.getTimestamp())) continue;
            it.remove();
        }
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public boolean filterRow() {
        return false;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        return false;
    }

    @Override
    public void reset() {
        this.stampSet.clear();
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 2 || filterArguments.size() == 3 || filterArguments.size() == 5 ? 1 : 0) != 0, (String)"Expected 2, 3 or 5 but got: %s", (Object[])new Object[]{filterArguments.size()});
        if (filterArguments.size() == 2) {
            byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
            byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
            return new DependentColumnFilter(family, qualifier);
        }
        if (filterArguments.size() == 3) {
            byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
            byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
            boolean dropDependentColumn = ParseFilter.convertByteArrayToBoolean(filterArguments.get(2));
            return new DependentColumnFilter(family, qualifier, dropDependentColumn);
        }
        if (filterArguments.size() == 5) {
            byte[] family = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
            byte[] qualifier = ParseFilter.removeQuotesFromByteArray(filterArguments.get(1));
            boolean dropDependentColumn = ParseFilter.convertByteArrayToBoolean(filterArguments.get(2));
            CompareFilter.CompareOp compareOp = ParseFilter.createCompareOp(filterArguments.get(3));
            WritableByteArrayComparable comparator = ParseFilter.createComparator(ParseFilter.removeQuotesFromByteArray(filterArguments.get(4)));
            return new DependentColumnFilter(family, qualifier, dropDependentColumn, compareOp, comparator);
        }
        throw new IllegalArgumentException("Expected 2, 3 or 5 but got: " + filterArguments.size());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.columnFamily = Bytes.readByteArray(in);
        if (this.columnFamily.length == 0) {
            this.columnFamily = null;
        }
        this.columnQualifier = Bytes.readByteArray(in);
        if (this.columnQualifier.length == 0) {
            this.columnQualifier = null;
        }
        this.dropDependentColumn = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Bytes.writeByteArray(out, this.columnFamily);
        Bytes.writeByteArray(out, this.columnQualifier);
        out.writeBoolean(this.dropDependentColumn);
    }
}

