/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class InclusiveStopFilter
extends FilterBase {
    private byte[] stopRowKey;
    private boolean done = false;

    public InclusiveStopFilter() {
    }

    public InclusiveStopFilter(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
    }

    public byte[] getStopRowKey() {
        return this.stopRowKey;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null) {
            return this.stopRowKey == null;
        }
        int cmp = Bytes.compareTo(this.stopRowKey, 0, this.stopRowKey.length, buffer, offset, length);
        if (cmp < 0) {
            this.done = true;
        }
        return this.done;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.done;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] stopRowKey = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new InclusiveStopFilter(stopRowKey);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.stopRowKey);
    }

    public void readFields(DataInput in) throws IOException {
        this.stopRowKey = Bytes.readByteArray(in);
    }
}

