/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class KeyOnlyFilter
extends FilterBase {
    boolean lenAsVal;

    public KeyOnlyFilter() {
        this(false);
    }

    public KeyOnlyFilter(boolean lenAsVal) {
        this.lenAsVal = lenAsVal;
    }

    @Override
    public KeyValue transform(KeyValue kv) {
        return kv.createKeyOnly(this.lenAsVal);
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 0 ? 1 : 0) != 0, (String)"Expected: 0 but got: %s", (Object[])new Object[]{filterArguments.size()});
        return new KeyOnlyFilter();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.lenAsVal);
    }

    public void readFields(DataInput in) throws IOException {
        this.lenAsVal = in.readBoolean();
    }
}

