/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class MultipleColumnPrefixFilter
extends FilterBase {
    protected byte[] hint = null;
    protected TreeSet<byte[]> sortedPrefixes = this.createTreeSet();

    public MultipleColumnPrefixFilter() {
    }

    public MultipleColumnPrefixFilter(byte[][] prefixes) {
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                if (this.sortedPrefixes.add(prefixes[i])) continue;
                throw new IllegalArgumentException("prefixes must be distinct");
            }
        }
    }

    public byte[][] getPrefix() {
        int count = 0;
        byte[][] temp = new byte[this.sortedPrefixes.size()][];
        for (byte[] prefixes : this.sortedPrefixes) {
            temp[count++] = prefixes;
        }
        return temp;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue kv) {
        if (this.sortedPrefixes.size() == 0 || kv.getBuffer() == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    public Filter.ReturnCode filterColumn(byte[] buffer, int qualifierOffset, int qualifierLength) {
        byte[] qualifier = Arrays.copyOfRange(buffer, qualifierOffset, qualifierLength + qualifierOffset);
        TreeSet lesserOrEqualPrefixes = (TreeSet)this.sortedPrefixes.headSet(qualifier, true);
        if (lesserOrEqualPrefixes.size() != 0) {
            byte[] largestPrefixSmallerThanQualifier = (byte[])lesserOrEqualPrefixes.last();
            if (Bytes.startsWith(qualifier, largestPrefixSmallerThanQualifier)) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (lesserOrEqualPrefixes.size() == this.sortedPrefixes.size()) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            this.hint = this.sortedPrefixes.higher(largestPrefixSmallerThanQualifier);
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.hint = this.sortedPrefixes.first();
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        byte[][] prefixes = new byte[filterArguments.size()][];
        for (int i = 0; i < filterArguments.size(); ++i) {
            byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(i));
            prefixes[i] = columnPrefix;
        }
        return new MultipleColumnPrefixFilter(prefixes);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.sortedPrefixes.size());
        for (byte[] element : this.sortedPrefixes) {
            Bytes.writeByteArray(out, element);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int x = in.readInt();
        this.sortedPrefixes = this.createTreeSet();
        for (int j = 0; j < x; ++j) {
            this.sortedPrefixes.add(Bytes.readByteArray(in));
        }
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue kv) {
        return KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), this.hint, 0, this.hint.length);
    }

    public TreeSet<byte[]> createTreeSet() {
        return new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException("prefixes can't be null");
                }
                byte[] b1 = (byte[])o1;
                byte[] b2 = (byte[])o2;
                return Bytes.compareTo(b1, 0, b1.length, b2, 0, b2.length);
            }
        });
    }
}

