/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;

public class PageFilter
extends FilterBase {
    private long pageSize = Long.MAX_VALUE;
    private int rowsAccepted = 0;

    public PageFilter() {
    }

    public PageFilter(long pageSize) {
        Preconditions.checkArgument((pageSize >= 0L ? 1 : 0) != 0, (String)"must be positive %s", (Object[])new Object[]{pageSize});
        this.pageSize = pageSize;
    }

    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public boolean filterAllRemaining() {
        return (long)this.rowsAccepted >= this.pageSize;
    }

    @Override
    public boolean filterRow() {
        ++this.rowsAccepted;
        return (long)this.rowsAccepted > this.pageSize;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        long pageSize = ParseFilter.convertByteArrayToLong(filterArguments.get(0));
        return new PageFilter(pageSize);
    }

    public void readFields(DataInput in) throws IOException {
        this.pageSize = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.pageSize);
    }
}

