/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class PrefixFilter
extends FilterBase {
    protected byte[] prefix = null;
    protected boolean passedPrefix = false;

    public PrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public PrefixFilter() {
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean filterRowKey(byte[] buffer, int offset, int length) {
        if (buffer == null || this.prefix == null) {
            return true;
        }
        if (length < this.prefix.length) {
            return true;
        }
        int cmp = Bytes.compareTo(buffer, offset, this.prefix.length, this.prefix, 0, this.prefix.length);
        if (cmp > 0) {
            this.passedPrefix = true;
        }
        return cmp != 0;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.passedPrefix;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] prefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new PrefixFilter(prefix);
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.prefix);
    }

    public void readFields(DataInput in) throws IOException {
        this.prefix = Bytes.readByteArray(in);
    }
}

