/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.io.RawComparator;

public abstract class AbstractHFileReader
implements HFile.Reader {
    private static final Log LOG = LogFactory.getLog(AbstractHFileReader.class);
    protected HFileBlock.FSReader fsBlockReader;
    protected FSDataInputStream istream;
    protected final boolean closeIStream;
    protected HFileBlockIndex.BlockIndexReader dataBlockIndexReader;
    protected HFileBlockIndex.BlockIndexReader metaBlockIndexReader;
    protected final FixedFileTrailer trailer;
    protected final Compression.Algorithm compressAlgo;
    protected byte[] lastKey = null;
    protected int avgKeyLen = -1;
    protected int avgValueLen = -1;
    protected RawComparator<byte[]> comparator;
    protected final long fileSize;
    protected final CacheConfig cacheConf;
    protected AtomicLong cacheHits = new AtomicLong();
    protected AtomicLong blockLoads = new AtomicLong();
    protected AtomicLong metaLoads = new AtomicLong();
    protected final Path path;
    protected final String name;
    protected HFile.FileInfo fileInfo;
    private final String cfStatsPrefix;

    protected AbstractHFileReader(Path path, FixedFileTrailer trailer, FSDataInputStream fsdis, long fileSize, boolean closeIStream, CacheConfig cacheConf) {
        this.trailer = trailer;
        this.compressAlgo = trailer.getCompressionCodec();
        this.cacheConf = cacheConf;
        this.fileSize = fileSize;
        this.istream = fsdis;
        this.closeIStream = closeIStream;
        this.path = path;
        this.name = path.getName();
        this.cfStatsPrefix = "cf." + AbstractHFileReader.parseCfNameFromPath(path.toString());
    }

    protected String toStringFirstKey() {
        return KeyValue.keyToString(this.getFirstKey());
    }

    protected String toStringLastKey() {
        return KeyValue.keyToString(this.getLastKey());
    }

    public static String parseCfNameFromPath(String path) {
        String[] splits = path.split("/");
        if (splits.length < 2) {
            LOG.warn((Object)("Could not determine the table and column family of the HFile path " + path));
            return "unknown";
        }
        return splits[splits.length - 2];
    }

    public abstract boolean isFileInfoLoaded();

    public String toString() {
        return "reader=" + this.path.toString() + (!this.isFileInfoLoaded() ? "" : ", compression=" + this.compressAlgo.getName() + ", cacheConf=" + this.cacheConf + ", firstKey=" + this.toStringFirstKey() + ", lastKey=" + this.toStringLastKey()) + ", avgKeyLen=" + this.avgKeyLen + ", avgValueLen=" + this.avgValueLen + ", entries=" + this.trailer.getEntryCount() + ", length=" + this.fileSize;
    }

    @Override
    public long length() {
        return this.fileSize;
    }

    @Override
    public HFileScanner getScanner(boolean cacheBlocks, boolean pread) {
        return this.getScanner(cacheBlocks, pread, false);
    }

    @Override
    public byte[] getFirstKey() {
        if (this.dataBlockIndexReader == null) {
            throw new BlockIndexNotLoadedException();
        }
        return this.dataBlockIndexReader.isEmpty() ? null : this.dataBlockIndexReader.getRootBlockKey(0);
    }

    @Override
    public byte[] getFirstRowKey() {
        byte[] firstKey = this.getFirstKey();
        if (firstKey == null) {
            return null;
        }
        return KeyValue.createKeyValueFromKey(firstKey).getRow();
    }

    @Override
    public byte[] getLastRowKey() {
        byte[] lastKey = this.getLastKey();
        if (lastKey == null) {
            return null;
        }
        return KeyValue.createKeyValueFromKey(lastKey).getRow();
    }

    @Override
    public long getEntries() {
        return this.trailer.getEntryCount();
    }

    @Override
    public RawComparator<byte[]> getComparator() {
        return this.comparator;
    }

    @Override
    public Compression.Algorithm getCompressionAlgorithm() {
        return this.compressAlgo;
    }

    @Override
    public long indexSize() {
        return (this.dataBlockIndexReader != null ? this.dataBlockIndexReader.heapSize() : 0L) + (this.metaBlockIndexReader != null ? this.metaBlockIndexReader.heapSize() : 0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HFileBlockIndex.BlockIndexReader getDataBlockIndexReader() {
        return this.dataBlockIndexReader;
    }

    @Override
    public String getColumnFamilyName() {
        return this.cfStatsPrefix;
    }

    @Override
    public FixedFileTrailer getTrailer() {
        return this.trailer;
    }

    public HFile.FileInfo loadFileInfo() throws IOException {
        return this.fileInfo;
    }

    HFileBlock.FSReader getUncachedBlockReader() {
        return this.fsBlockReader;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    protected static abstract class Scanner
    implements HFileScanner {
        protected ByteBuffer blockBuffer;
        protected boolean cacheBlocks;
        protected final boolean pread;
        protected final boolean isCompaction;
        protected int currKeyLen;
        protected int currValueLen;
        protected int currMemstoreTSLen;
        protected long currMemstoreTS;
        protected int blockFetches;

        public Scanner(boolean cacheBlocks, boolean pread, boolean isCompaction) {
            this.cacheBlocks = cacheBlocks;
            this.pread = pread;
            this.isCompaction = isCompaction;
        }

        @Override
        public boolean isSeeked() {
            return this.blockBuffer != null;
        }

        public String toString() {
            return "HFileScanner for reader " + String.valueOf(this.getReader());
        }

        protected void assertSeeked() {
            if (!this.isSeeked()) {
                throw new NotSeekedException();
            }
        }
    }

    public static class NotSeekedException
    extends IllegalStateException {
        public NotSeekedException() {
            super("Not seeked to a key/value");
        }
    }

    public static class BlockIndexNotLoadedException
    extends IllegalStateException {
        public BlockIndexNotLoadedException() {
            super("Block index not loaded");
        }
    }
}

